/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api.jira;

import com.atlassian.performance.tools.awsinfrastructure.api.storage.S3Artifact;
import com.atlassian.performance.tools.awsinfrastructure.api.storage.S3TarGzDistribution;
import com.atlassian.performance.tools.infrastructure.api.distribution.ProductDistribution;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/JiraSoftwareInternalDistribution;", "Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;", "version", "", "(Ljava/lang/String;)V", "unpackTimeout", "Ljava/time/Duration;", "(Ljava/lang/String;Ljava/time/Duration;)V", "install", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "destination", "aws-infrastructure"})
public final class JiraSoftwareInternalDistribution
implements ProductDistribution {
    private final String version;
    private final Duration unpackTimeout;

    @NotNull
    public String install(@NotNull SshConnection ssh, @NotNull String destination) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        S3TarGzDistribution distribution = new S3TarGzDistribution(new S3Artifact("us-east-1", "downloads-internal-us-east-1", "private/jira/" + this.version, "atlassian-jira-software-" + this.version + "-standalone.tar.gz"), this.unpackTimeout);
        return distribution.install(ssh, destination);
    }

    public JiraSoftwareInternalDistribution(@NotNull String version, @NotNull Duration unpackTimeout) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull((Object)unpackTimeout, (String)"unpackTimeout");
        this.version = version;
        this.unpackTimeout = unpackTimeout;
    }

    public JiraSoftwareInternalDistribution(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Duration duration = Duration.ofSeconds(90L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(90)");
        this(version, duration);
    }
}

