/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api.jira;

import com.atlassian.performance.tools.awsinfrastructure.api.RemoteLocation;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.StartedNode;
import com.atlassian.performance.tools.concurrency.api.TaskContextKt;
import com.atlassian.performance.tools.infrastructure.api.MeasurementSource;
import com.atlassian.performance.tools.infrastructure.api.jvm.jmx.JmxClient;
import com.atlassian.performance.tools.jvmtasks.api.TaskTimer;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/Jira;", "Lcom/atlassian/performance/tools/infrastructure/api/MeasurementSource;", "nodes", "", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/StartedNode;", "jiraHome", "Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;", "database", "address", "Ljava/net/URI;", "jmxClients", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/jmx/JmxClient;", "(Ljava/util/List;Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;Ljava/net/URI;Ljava/util/List;)V", "getAddress", "()Ljava/net/URI;", "getDatabase", "()Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;", "getJiraHome", "getJmxClients", "()Ljava/util/List;", "logger", "Lorg/apache/logging/log4j/Logger;", "gatherResults", "", "toString", "", "aws-infrastructure"})
public final class Jira
implements MeasurementSource {
    private final Logger logger;
    private final List<StartedNode> nodes;
    @NotNull
    private final RemoteLocation jiraHome;
    @Nullable
    private final RemoteLocation database;
    @NotNull
    private final URI address;
    @NotNull
    private final List<JmxClient> jmxClients;

    /*
     * WARNING - void declaration
     */
    public void gatherResults() {
        void $receiver$iv$iv;
        if (this.nodes.isEmpty()) {
            this.logger.warn("No Jira nodes known to JPT, not downloading node results");
            return;
        }
        ExecutorService executor = Executors.newFixedThreadPool(RangesKt.coerceAtMost((int)this.nodes.size(), (int)4), new ThreadFactoryBuilder().setNameFormat("results-gathering-thread-%d").build());
        Iterable $receiver$iv = this.nodes;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            StartedNode startedNode = (StartedNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            ExecutorService executorService = executor;
            Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"executor");
            CompletableFuture completableFuture = TaskContextKt.submitWithLogContext((ExecutorService)executorService, (String)("gather " + it), (Function0)((Function0)new Function0<Unit>((StartedNode)it){
                final /* synthetic */ StartedNode $it;

                public final void invoke() {
                    this.$it.gatherResults();
                }
                {
                    this.$it = startedNode;
                    super(0);
                }
            }));
            collection.add(completableFuture);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            CompletableFuture it = (CompletableFuture)element$iv;
            it.get();
        }
        TaskTimer.INSTANCE.time("gather analytics", (Function0)new Function0<Unit>(this){
            final /* synthetic */ Jira this$0;

            @Nullable
            public final Unit invoke() {
                Unit unit;
                StartedNode startedNode = (StartedNode)CollectionsKt.firstOrNull((List)Jira.access$getNodes$p(this.this$0));
                if (startedNode != null) {
                    startedNode.gatherAnalyticLogs();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
            {
                this.this$0 = jira;
                super(0);
            }
        });
        executor.shutdownNow();
    }

    @NotNull
    public String toString() {
        return "Jira(address=" + this.address + ')';
    }

    @NotNull
    public final RemoteLocation getJiraHome() {
        return this.jiraHome;
    }

    @Nullable
    public final RemoteLocation getDatabase() {
        return this.database;
    }

    @NotNull
    public final URI getAddress() {
        return this.address;
    }

    @NotNull
    public final List<JmxClient> getJmxClients() {
        return this.jmxClients;
    }

    public Jira(@NotNull List<StartedNode> nodes, @NotNull RemoteLocation jiraHome, @Nullable RemoteLocation database, @NotNull URI address, @NotNull List<? extends JmxClient> jmxClients) {
        Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
        Intrinsics.checkParameterIsNotNull((Object)jiraHome, (String)"jiraHome");
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        Intrinsics.checkParameterIsNotNull(jmxClients, (String)"jmxClients");
        this.nodes = nodes;
        this.jiraHome = jiraHome;
        this.database = database;
        this.address = address;
        this.jmxClients = jmxClients;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }

    public /* synthetic */ Jira(List list, RemoteLocation remoteLocation, RemoteLocation remoteLocation2, URI uRI, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(list, remoteLocation, remoteLocation2, uRI, list2);
    }

    @NotNull
    public static final /* synthetic */ List access$getNodes$p(Jira $this) {
        return $this.nodes;
    }
}

