/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api.jira;

import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.Subnet;
import com.amazonaws.services.ec2.model.Vpc;
import com.atlassian.performance.tools.aws.api.Aws;
import com.atlassian.performance.tools.aws.api.DependentResources;
import com.atlassian.performance.tools.aws.api.Investment;
import com.atlassian.performance.tools.aws.api.ProvisionedStack;
import com.atlassian.performance.tools.aws.api.Resource;
import com.atlassian.performance.tools.aws.api.SshKey;
import com.atlassian.performance.tools.aws.api.SshKeyFile;
import com.atlassian.performance.tools.aws.api.StackFormula;
import com.atlassian.performance.tools.aws.api.Storage;
import com.atlassian.performance.tools.awsinfrastructure.ApplicationStorageWrapper;
import com.atlassian.performance.tools.awsinfrastructure.InstanceFilters;
import com.atlassian.performance.tools.awsinfrastructure.TemplateBuilder;
import com.atlassian.performance.tools.awsinfrastructure.api.RemoteLocation;
import com.atlassian.performance.tools.awsinfrastructure.api.hardware.C4EightExtraLargeElastic;
import com.atlassian.performance.tools.awsinfrastructure.api.hardware.Computer;
import com.atlassian.performance.tools.awsinfrastructure.api.hardware.M4ExtraLargeElastic;
import com.atlassian.performance.tools.awsinfrastructure.api.hardware.Volume;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.Jira;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.JiraFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.ProvisionedJira;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.StartedNode;
import com.atlassian.performance.tools.awsinfrastructure.api.loadbalancer.ApacheEc2LoadBalancerFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.loadbalancer.ApacheProxyLoadBalancer;
import com.atlassian.performance.tools.awsinfrastructure.api.loadbalancer.LoadBalancerFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.loadbalancer.ProvisionedLoadBalancer;
import com.atlassian.performance.tools.awsinfrastructure.api.network.Network;
import com.atlassian.performance.tools.awsinfrastructure.api.network.NetworkFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.network.ProvisionedNetwork;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.AccessProvider;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.AccessRequester;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.ForIpAccessRequester;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.LocalPublicIpv4Provider;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.MultiAccessProvider;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.MultiAccessRequester;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.SecurityGroupIngressAccessProvider;
import com.atlassian.performance.tools.awsinfrastructure.api.storage.ApplicationStorage;
import com.atlassian.performance.tools.awsinfrastructure.jira.DataCenterNodeFormula;
import com.atlassian.performance.tools.awsinfrastructure.jira.DiagnosableNodeFormula;
import com.atlassian.performance.tools.awsinfrastructure.jira.NodeFormula;
import com.atlassian.performance.tools.awsinfrastructure.jira.StandaloneNodeFormula;
import com.atlassian.performance.tools.awsinfrastructure.jira.StoppedNode;
import com.atlassian.performance.tools.awsinfrastructure.jira.home.SharedHomeFormula;
import com.atlassian.performance.tools.concurrency.api.AbruptExecutorService;
import com.atlassian.performance.tools.concurrency.api.TaskContextKt;
import com.atlassian.performance.tools.infrastructure.api.app.Apps;
import com.atlassian.performance.tools.infrastructure.api.database.Database;
import com.atlassian.performance.tools.infrastructure.api.distribution.ProductDistribution;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraHomeSource;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraNodeConfig;
import com.atlassian.performance.tools.infrastructure.api.jira.SharedHome;
import com.atlassian.performance.tools.infrastructure.api.jvm.jmx.JmxClient;
import com.atlassian.performance.tools.infrastructure.api.jvm.jmx.RemoteJmx;
import com.atlassian.performance.tools.infrastructure.api.loadbalancer.LoadBalancer;
import com.atlassian.performance.tools.jvmtasks.api.TaskTimer;
import com.atlassian.performance.tools.ssh.api.Ssh;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import com.atlassian.performance.tools.ssh.api.SshHost;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u000256BE\b\u0017\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011B'\b\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0012B\u0089\u0001\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u0010\u0012\u0006\u0010\u001c\u001a\u00020\u0016\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u001f\u001a\u00020 \u0012\u0006\u0010!\u001a\u00020\"\u00a2\u0006\u0002\u0010#J>\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u00020 2\u0006\u00101\u001a\u000202H\u0016JF\u0010&\u001a\u00020'2\u0006\u00103\u001a\u0002042\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u00020 2\u0006\u00101\u001a\u000202H\u0002R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/DataCenterFormula;", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/JiraFormula;", "configs", "", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraNodeConfig;", "loadBalancerFormula", "Lcom/atlassian/performance/tools/awsinfrastructure/api/loadbalancer/LoadBalancerFormula;", "apps", "Lcom/atlassian/performance/tools/infrastructure/api/app/Apps;", "application", "Lcom/atlassian/performance/tools/awsinfrastructure/api/storage/ApplicationStorage;", "jiraHomeSource", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;", "database", "Lcom/atlassian/performance/tools/infrastructure/api/database/Database;", "computer", "Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Computer;", "(Ljava/util/List;Lcom/atlassian/performance/tools/awsinfrastructure/api/loadbalancer/LoadBalancerFormula;Lcom/atlassian/performance/tools/infrastructure/api/app/Apps;Lcom/atlassian/performance/tools/awsinfrastructure/api/storage/ApplicationStorage;Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;Lcom/atlassian/performance/tools/infrastructure/api/database/Database;Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Computer;)V", "(Lcom/atlassian/performance/tools/infrastructure/api/app/Apps;Lcom/atlassian/performance/tools/awsinfrastructure/api/storage/ApplicationStorage;Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;Lcom/atlassian/performance/tools/infrastructure/api/database/Database;)V", "productDistribution", "Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;", "jiraVolume", "Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Volume;", "stackCreationTimeout", "Ljava/time/Duration;", "overriddenNetwork", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/Network;", "databaseComputer", "databaseVolume", "accessRequester", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/access/AccessRequester;", "adminPasswordPlainText", "", "waitForUpgrades", "", "(Ljava/util/List;Lcom/atlassian/performance/tools/awsinfrastructure/api/loadbalancer/LoadBalancerFormula;Lcom/atlassian/performance/tools/infrastructure/api/app/Apps;Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;Lcom/atlassian/performance/tools/infrastructure/api/database/Database;Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Computer;Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Volume;Ljava/time/Duration;Lcom/atlassian/performance/tools/awsinfrastructure/api/network/Network;Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Computer;Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Volume;Lcom/atlassian/performance/tools/awsinfrastructure/api/network/access/AccessRequester;Ljava/lang/String;Z)V", "logger", "Lorg/apache/logging/log4j/Logger;", "provision", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/ProvisionedJira;", "investment", "Lcom/atlassian/performance/tools/aws/api/Investment;", "pluginsTransport", "Lcom/atlassian/performance/tools/aws/api/Storage;", "resultsTransport", "key", "Ljava/util/concurrent/Future;", "Lcom/atlassian/performance/tools/aws/api/SshKey;", "roleProfile", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "executor", "Ljava/util/concurrent/ExecutorService;", "Builder", "Defaults", "aws-infrastructure"})
public final class DataCenterFormula
implements JiraFormula {
    private final Logger logger;
    private final List<JiraNodeConfig> configs;
    private final LoadBalancerFormula loadBalancerFormula;
    private final Apps apps;
    private final ProductDistribution productDistribution;
    private final JiraHomeSource jiraHomeSource;
    private final Database database;
    private final Computer computer;
    private final Volume jiraVolume;
    private final Duration stackCreationTimeout;
    private final Network overriddenNetwork;
    private final Computer databaseComputer;
    private final Volume databaseVolume;
    private final AccessRequester accessRequester;
    private final String adminPasswordPlainText;
    private final boolean waitForUpgrades;

    @Override
    @NotNull
    public ProvisionedJira provision(@NotNull Investment investment, @NotNull Storage pluginsTransport, @NotNull Storage resultsTransport, @NotNull Future<SshKey> key, @NotNull String roleProfile, @NotNull Aws aws) {
        Intrinsics.checkParameterIsNotNull((Object)investment, (String)"investment");
        Intrinsics.checkParameterIsNotNull((Object)pluginsTransport, (String)"pluginsTransport");
        Intrinsics.checkParameterIsNotNull((Object)resultsTransport, (String)"resultsTransport");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)roleProfile, (String)"roleProfile");
        Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
        return (ProvisionedJira)TaskTimer.INSTANCE.time("provision Jira Data Center", (Function0)new Function0<ProvisionedJira>(this, investment, pluginsTransport, resultsTransport, key, roleProfile, aws){
            final /* synthetic */ DataCenterFormula this$0;
            final /* synthetic */ Investment $investment;
            final /* synthetic */ Storage $pluginsTransport;
            final /* synthetic */ Storage $resultsTransport;
            final /* synthetic */ Future $key;
            final /* synthetic */ String $roleProfile;
            final /* synthetic */ Aws $aws;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final ProvisionedJira invoke() {
                ProvisionedJira provisionedJira;
                DataCenterFormula.access$getLogger$p(this.this$0).info("Setting up Jira...");
                ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("data-center-provisioning-thread-%d").build());
                Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newCachedThrea\u2026   .build()\n            )");
                AutoCloseable autoCloseable = (AutoCloseable)new AbruptExecutorService(executorService);
                Throwable throwable = null;
                try {
                    AbruptExecutorService executor = (AbruptExecutorService)autoCloseable;
                    provisionedJira = DataCenterFormula.access$provision(this.this$0, (ExecutorService)executor, this.$investment, this.$pluginsTransport, this.$resultsTransport, this.$key, this.$roleProfile, this.$aws);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                return provisionedJira;
            }
            {
                this.this$0 = dataCenterFormula;
                this.$investment = investment;
                this.$pluginsTransport = storage;
                this.$resultsTransport = storage2;
                this.$key = future;
                this.$roleProfile = string;
                this.$aws = aws;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final ProvisionedJira provision(ExecutorService executor, Investment investment, Storage pluginsTransport, Storage resultsTransport, Future<SshKey> key, String roleProfile, Aws aws) {
        Collection<JmxClient> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Jira jira;
        StoppedNode it;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        Object item$iv$iv6;
        void $receiver$iv$iv3;
        Iterable $receiver$iv3;
        void $receiver$iv$iv4;
        void $receiver$iv4;
        MultiAccessProvider multiAccessProvider;
        Iterable $receiver$iv$iv5;
        Iterable $receiver$iv5;
        MultiAccessProvider multiAccessProvider2;
        Iterable $receiver$iv$iv6;
        Iterable $receiver$iv6;
        MultiAccessProvider multiAccessProvider3;
        Object object;
        Iterable $receiver$iv$iv7;
        Iterable $receiver$iv7;
        MultiAccessProvider multiAccessProvider4;
        String sharedHomeSshIp;
        String databaseSshIp;
        ProvisionedNetwork provisionedNetwork = new NetworkFormula(investment, aws).reuseOrProvision$aws_infrastructure(this.overriddenNetwork);
        Network network = provisionedNetwork.getNetwork();
        String template = new TemplateBuilder("2-nodes-dc.yaml").adaptTo(this.configs);
        CompletableFuture stackProvisioning2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"provision stack", (Function0)((Function0)new Function0<ProvisionedStack>(this, investment, template, key, roleProfile, aws, network){
            final /* synthetic */ DataCenterFormula this$0;
            final /* synthetic */ Investment $investment;
            final /* synthetic */ String $template;
            final /* synthetic */ Future $key;
            final /* synthetic */ String $roleProfile;
            final /* synthetic */ Aws $aws;
            final /* synthetic */ Network $network;

            @NotNull
            public final ProvisionedStack invoke() {
                Duration duration = DataCenterFormula.access$getStackCreationTimeout$p(this.this$0);
                Duration duration2 = null;
                Aws aws = this.$aws;
                List list = CollectionsKt.listOf((Object[])new Parameter[]{new Parameter().withParameterKey("KeyName").withParameterValue(((SshKey)this.$key.get()).getRemote().getName()), new Parameter().withParameterKey("InstanceProfile").withParameterValue(this.$roleProfile), new Parameter().withParameterKey("Ami").withParameterValue(this.$aws.getDefaultAmi()), new Parameter().withParameterKey("JiraInstanceType").withParameterValue(DataCenterFormula.access$getComputer$p(this.this$0).getInstanceType$aws_infrastructure().toString()), new Parameter().withParameterKey("JiraVolumeSize").withParameterValue(String.valueOf(DataCenterFormula.access$getJiraVolume$p(this.this$0).getSize())), new Parameter().withParameterKey("DatabaseInstanceType").withParameterValue(DataCenterFormula.access$getDatabaseComputer$p(this.this$0).getInstanceType$aws_infrastructure().toString()), new Parameter().withParameterKey("DatabaseVolumeSize").withParameterValue(String.valueOf(DataCenterFormula.access$getDatabaseVolume$p(this.this$0).getSize())), new Parameter().withParameterKey("Vpc").withParameterValue(this.$network.getVpc().getVpcId()), new Parameter().withParameterKey("Subnet").withParameterValue(this.$network.getSubnet().getSubnetId())});
                String string = this.$template;
                return new StackFormula(this.$investment, aws, string, list, duration2, duration, 16, null).provision();
            }
            {
                this.this$0 = dataCenterFormula;
                this.$investment = investment;
                this.$template = string;
                this.$key = future;
                this.$roleProfile = string2;
                this.$aws = aws;
                this.$network = network;
                super(0);
            }
        }));
        CompletableFuture uploadPlugins2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"upload plugins", (Function0)((Function0)new Function0<Unit>(this, pluginsTransport){
            final /* synthetic */ DataCenterFormula this$0;
            final /* synthetic */ Storage $pluginsTransport;

            public final void invoke() {
                Iterable $receiver$iv = DataCenterFormula.access$getApps$p(this.this$0).listFiles();
                for (T element$iv : $receiver$iv) {
                    File it = (File)element$iv;
                    this.$pluginsTransport.upload(it);
                }
            }
            {
                this.this$0 = dataCenterFormula;
                this.$pluginsTransport = storage;
                super(0);
            }
        }));
        ProvisionedStack jiraStack = (ProvisionedStack)stackProvisioning2.get();
        Path keyPath = key.get().getFile().getPath();
        List machines = jiraStack.listMachines();
        List<Instance> jiraNodes = new InstanceFilters().jiraInstances$aws_infrastructure(machines);
        Instance databaseMachine = new InstanceFilters().dbInstance$aws_infrastructure(machines);
        String databasePrivateIp = databaseMachine.getPrivateIpAddress();
        String string = databaseSshIp = databaseMachine.getPublicIpAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"databaseSshIp");
        Ssh databaseSsh = new Ssh(new SshHost(string, "ubuntu", keyPath), 5);
        Instance sharedHomeMachine = new InstanceFilters().sharedHome$aws_infrastructure(machines);
        String sharedHomePrivateIp = sharedHomeMachine.getPrivateIpAddress();
        String string2 = sharedHomeSshIp = sharedHomeMachine.getPublicIpAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sharedHomeSshIp");
        Ssh sharedHomeSsh = new Ssh(new SshHost(string2, "ubuntu", keyPath), 4);
        CompletableFuture futureLoadBalancer2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"provision load balancer", (Function0)((Function0)new Function0<ProvisionedLoadBalancer>(this, investment, jiraNodes, network, key, aws){
            final /* synthetic */ DataCenterFormula this$0;
            final /* synthetic */ Investment $investment;
            final /* synthetic */ List $jiraNodes;
            final /* synthetic */ Network $network;
            final /* synthetic */ Future $key;
            final /* synthetic */ Aws $aws;

            @NotNull
            public final ProvisionedLoadBalancer invoke() {
                LoadBalancerFormula loadBalancerFormula = DataCenterFormula.access$getLoadBalancerFormula$p(this.this$0);
                Subnet subnet = this.$network.getSubnet();
                Vpc vpc = this.$network.getVpc();
                V v = this.$key.get();
                Intrinsics.checkExpressionValueIsNotNull(v, (String)"key.get()");
                Aws aws = this.$aws;
                SshKey sshKey = (SshKey)v;
                Vpc vpc2 = vpc;
                Subnet subnet2 = subnet;
                return loadBalancerFormula.provision(this.$investment, this.$jiraNodes, vpc2, subnet2, sshKey, aws);
            }
            {
                this.this$0 = dataCenterFormula;
                this.$investment = investment;
                this.$jiraNodes = list;
                this.$network = network;
                this.$key = future;
                this.$aws = aws;
                super(0);
            }
        }));
        uploadPlugins2.get();
        CompletableFuture sharedHome2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"provision shared home", (Function0)((Function0)new Function0<SharedHome>(this, key, sharedHomeSshIp, pluginsTransport, sharedHomePrivateIp, sharedHomeSsh){
            final /* synthetic */ DataCenterFormula this$0;
            final /* synthetic */ Future $key;
            final /* synthetic */ String $sharedHomeSshIp;
            final /* synthetic */ Storage $pluginsTransport;
            final /* synthetic */ String $sharedHomePrivateIp;
            final /* synthetic */ Ssh $sharedHomeSsh;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final SharedHome invoke() {
                void var1_6;
                DataCenterFormula.access$getLogger$p(this.this$0).info("Setting up shared home...");
                SshKeyFile sshKeyFile = ((SshKey)this.$key.get()).getFile();
                String string = this.$sharedHomeSshIp;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sharedHomeSshIp");
                sshKeyFile.facilitateSsh(string);
                JiraHomeSource jiraHomeSource = DataCenterFormula.access$getJiraHomeSource$p(this.this$0);
                String string2 = this.$sharedHomePrivateIp;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sharedHomePrivateIp");
                Computer computer = DataCenterFormula.access$getComputer$p(this.this$0);
                Ssh ssh = this.$sharedHomeSsh;
                String string3 = string2;
                Storage storage = this.$pluginsTransport;
                JiraHomeSource jiraHomeSource2 = jiraHomeSource;
                SharedHome sharedHome2 = new SharedHomeFormula(storage, jiraHomeSource2, string3, ssh, computer).provision();
                DataCenterFormula.access$getLogger$p(this.this$0).info("Shared home is set up");
                return var1_6;
            }
            {
                this.this$0 = dataCenterFormula;
                this.$key = future;
                this.$sharedHomeSshIp = string;
                this.$pluginsTransport = storage;
                this.$sharedHomePrivateIp = string2;
                this.$sharedHomeSsh = ssh;
                super(0);
            }
        }));
        List nodeFormulas2 = SequencesKt.toList((Sequence)SequencesKt.mapIndexed((Sequence)SequencesKt.onEach((Sequence)CollectionsKt.asSequence((Iterable)jiraNodes), (Function1)((Function1)new Function1<Instance, Unit>(key){
            final /* synthetic */ Future $key;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull Instance instance) {
                Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
                AutoCloseable autoCloseable = (AutoCloseable)CloseableThreadContext.push((String)"a jira node");
                Throwable throwable = null;
                try {
                    CloseableThreadContext.Instance it = (CloseableThreadContext.Instance)autoCloseable;
                    String sshIpAddress = instance.getPublicIpAddress();
                    SshKeyFile sshKeyFile = ((SshKey)this.$key.get()).getFile();
                    String string = sshIpAddress;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sshIpAddress");
                    sshKeyFile.facilitateSsh(string);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            {
                this.$key = future;
                super(1);
            }
        })), (Function2)((Function2)new Function2<Integer, Instance, DiagnosableNodeFormula>(this, keyPath, resultsTransport, databasePrivateIp, pluginsTransport, sharedHome2){
            final /* synthetic */ DataCenterFormula this$0;
            final /* synthetic */ Path $keyPath;
            final /* synthetic */ Storage $resultsTransport;
            final /* synthetic */ String $databasePrivateIp;
            final /* synthetic */ Storage $pluginsTransport;
            final /* synthetic */ CompletableFuture $sharedHome;

            @NotNull
            public final DiagnosableNodeFormula invoke(int i, @NotNull Instance instance) {
                String sshIpAddress;
                Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
                String string = sshIpAddress = instance.getPublicIpAddress();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sshIpAddress");
                Ssh ssh = new Ssh(new SshHost(string, "ubuntu", this.$keyPath), 5);
                String string2 = this.$databasePrivateIp;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"databasePrivateIp");
                String string3 = DataCenterFormula.access$getAdminPasswordPlainText$p(this.this$0);
                Object object = DataCenterFormula.access$getComputer$p(this.this$0);
                JiraNodeConfig jiraNodeConfig = (JiraNodeConfig)DataCenterFormula.access$getConfigs$p(this.this$0).get(i);
                boolean bl = DataCenterFormula.access$getWaitForUpgrades$p(this.this$0);
                Ssh ssh2 = ssh;
                ProductDistribution productDistribution = DataCenterFormula.access$getProductDistribution$p(this.this$0);
                Storage storage = this.$pluginsTransport;
                JiraHomeSource jiraHomeSource = DataCenterFormula.access$getJiraHomeSource$p(this.this$0);
                String string4 = string2;
                Storage storage2 = this.$resultsTransport;
                NodeFormula nodeFormula = new StandaloneNodeFormula(jiraHomeSource, storage, storage2, string4, productDistribution, ssh2, bl, jiraNodeConfig, (Computer)object, string3);
                Future future = this.$sharedHome;
                String string5 = instance.getPrivateIpAddress();
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"instance.privateIpAddress");
                string3 = string5;
                object = future;
                int n = i;
                NodeFormula nodeFormula2 = nodeFormula;
                return new DiagnosableNodeFormula(new DataCenterNodeFormula(n, (Future<SharedHome>)object, nodeFormula2, string3));
            }
            {
                this.this$0 = dataCenterFormula;
                this.$keyPath = path;
                this.$resultsTransport = storage;
                this.$databasePrivateIp = string;
                this.$pluginsTransport = storage2;
                this.$sharedHome = completableFuture;
                super(2);
            }
        })));
        ProvisionedLoadBalancer provisionedLoadBalancer = (ProvisionedLoadBalancer)futureLoadBalancer2.get();
        LoadBalancer loadBalancer = provisionedLoadBalancer.getLoadBalancer();
        SecurityGroup jiraNodeSecurityGroup = jiraStack.findSecurityGroup("JiraNodeSecurityGroup");
        int n = 8080;
        SecurityGroupIngressAccessProvider jiraNodeHttpAccessProvider = new SecurityGroupIngressAccessProvider.Builder(aws.getEc2(), jiraNodeSecurityGroup, new IntRange(n, 8080)).build();
        Iterable iterable = this.configs;
        Object object2 = multiAccessProvider4;
        Object object3 = multiAccessProvider4;
        void var34_37 = $receiver$iv7;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv7) {
            JiraNodeConfig it2 = (JiraNodeConfig)element$iv$iv;
            Iterable list$iv$iv = it2.getDebug().getRequiredPorts();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection<SecurityGroupIngressAccessProvider> collection2 = (List)destination$iv$iv;
        $receiver$iv$iv7 = $receiver$iv7 = (Iterable)CollectionsKt.toSet((Iterable)collection2);
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv7, (int)10));
        for (Object item$iv$iv2 : $receiver$iv$iv7) {
            int it2 = ((Number)item$iv$iv2).intValue();
            collection2 = destination$iv$iv;
            int $i$a$1$flatMap = it2;
            object = new SecurityGroupIngressAccessProvider.Builder(aws.getEc2(), jiraNodeSecurityGroup, new IntRange($i$a$1$flatMap, it2)).build();
            collection2.add((SecurityGroupIngressAccessProvider)object);
        }
        collection2 = (List)destination$iv$iv;
        ((MultiAccessProvider)object2)((List<? extends AccessProvider>)collection2);
        MultiAccessProvider jiraNodeJvmDebugAccessProvider = object3;
        $receiver$iv$iv7 = this.configs;
        object2 = multiAccessProvider3;
        object3 = multiAccessProvider3;
        destination$iv$iv = $receiver$iv6;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv6) {
            JiraNodeConfig it3 = (JiraNodeConfig)element$iv$iv;
            Iterable list$iv$iv = it3.getRemoteJmx().getRequiredPorts();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        collection2 = (List)destination$iv$iv2;
        $receiver$iv$iv6 = $receiver$iv6 = (Iterable)CollectionsKt.toSet((Iterable)collection2);
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv6, (int)10));
        for (Object item$iv$iv3 : $receiver$iv$iv6) {
            int it3 = ((Number)item$iv$iv3).intValue();
            collection2 = destination$iv$iv2;
            int $i$a$1$flatMap = it3;
            object = new SecurityGroupIngressAccessProvider.Builder(aws.getEc2(), jiraNodeSecurityGroup, new IntRange($i$a$1$flatMap, it3)).build();
            collection2.add((SecurityGroupIngressAccessProvider)object);
        }
        collection2 = (List)destination$iv$iv2;
        ((MultiAccessProvider)object2)((List<? extends AccessProvider>)collection2);
        MultiAccessProvider jiraNodeJmxAccessProvider = object3;
        $receiver$iv$iv6 = this.configs;
        object2 = multiAccessProvider2;
        object3 = multiAccessProvider2;
        destination$iv$iv2 = $receiver$iv5;
        Collection destination$iv$iv3 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv5) {
            JiraNodeConfig it4 = (JiraNodeConfig)element$iv$iv;
            Iterable list$iv$iv = it4.getSplunkForwarder().getRequiredPorts();
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        collection2 = (List)destination$iv$iv3;
        $receiver$iv$iv5 = $receiver$iv5 = (Iterable)CollectionsKt.toSet((Iterable)collection2);
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv5, (int)10));
        for (Object item$iv$iv4 : $receiver$iv$iv5) {
            int it4 = ((Number)item$iv$iv4).intValue();
            collection2 = destination$iv$iv3;
            int $i$a$1$flatMap = it4;
            object = new SecurityGroupIngressAccessProvider.Builder(aws.getEc2(), jiraNodeSecurityGroup, new IntRange($i$a$1$flatMap, it4)).build();
            collection2.add((SecurityGroupIngressAccessProvider)object);
        }
        collection2 = (List)destination$iv$iv3;
        ((MultiAccessProvider)object2)((List<? extends AccessProvider>)collection2);
        MultiAccessProvider jiraNodeSplunkForwarderAccessProvider = object3;
        $receiver$iv$iv5 = SetsKt.setOf((Object[])new Integer[]{40001, 40011});
        object2 = multiAccessProvider;
        object3 = multiAccessProvider;
        destination$iv$iv3 = $receiver$iv4;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv4, (int)10));
        for (Object item$iv$iv5 : $receiver$iv$iv4) {
            void it5;
            int $i$a$1$flatMap = ((Number)item$iv$iv5).intValue();
            collection2 = destination$iv$iv4;
            void $i$a$2$map = it5;
            object = new SecurityGroupIngressAccessProvider.Builder(aws.getEc2(), jiraNodeSecurityGroup, new IntRange((int)$i$a$2$map, (int)it5)).build();
            collection2.add((SecurityGroupIngressAccessProvider)object);
        }
        collection2 = (List)destination$iv$iv4;
        ((MultiAccessProvider)object2)((List<? extends AccessProvider>)collection2);
        MultiAccessProvider jiraNodeRmiAccessProvider = object3;
        MultiAccessProvider jiraAccessProvider = new MultiAccessProvider(CollectionsKt.listOf((Object[])new AccessProvider[]{provisionedLoadBalancer.getAccessProvider(), jiraNodeHttpAccessProvider, jiraNodeJvmDebugAccessProvider, jiraNodeJmxAccessProvider, jiraNodeSplunkForwarderAccessProvider}));
        CompletableFuture rmiNodePublicAccess2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"rmi node public access", (Function0)((Function0)new Function0<Boolean>(jiraNodes, jiraNodeRmiAccessProvider){
            final /* synthetic */ List $jiraNodes;
            final /* synthetic */ MultiAccessProvider $jiraNodeRmiAccessProvider;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke() {
                void var3_5;
                Collection<ForIpAccessRequester> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                MultiAccessRequester multiAccessRequester;
                Iterable iterable = this.$jiraNodes;
                MultiAccessRequester multiAccessRequester2 = multiAccessRequester;
                MultiAccessRequester multiAccessRequester3 = multiAccessRequester;
                void var2_4 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    Instance instance = (Instance)item$iv$iv;
                    collection = destination$iv$iv;
                    ForIpAccessRequester forIpAccessRequester = new ForIpAccessRequester((Function0<String>)((Function0)new Function0<String>((Instance)it){
                        final /* synthetic */ Instance $it;

                        public final String invoke() {
                            String string = this.$it.getPublicIpAddress();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.publicIpAddress");
                            return string;
                        }
                        {
                            this.$it = instance;
                            super(0);
                        }
                    }));
                    collection.add(forIpAccessRequester);
                }
                collection = (List)var3_5;
                multiAccessRequester2((List<? extends AccessRequester>)collection);
                return multiAccessRequester3.requestAccess(this.$jiraNodeRmiAccessProvider);
            }
            {
                this.$jiraNodes = list;
                this.$jiraNodeRmiAccessProvider = multiAccessProvider;
                super(0);
            }
        }));
        CompletableFuture selfDashboardAccess2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"self dashboard access", (Function0)((Function0)new Function0<Boolean>(jiraNodes, provisionedLoadBalancer){
            final /* synthetic */ List $jiraNodes;
            final /* synthetic */ ProvisionedLoadBalancer $provisionedLoadBalancer;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke() {
                void var3_5;
                Collection<ForIpAccessRequester> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                MultiAccessRequester multiAccessRequester;
                Iterable iterable = this.$jiraNodes;
                MultiAccessRequester multiAccessRequester2 = multiAccessRequester;
                MultiAccessRequester multiAccessRequester3 = multiAccessRequester;
                void var2_4 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    Instance instance = (Instance)item$iv$iv;
                    collection = destination$iv$iv;
                    ForIpAccessRequester forIpAccessRequester = new ForIpAccessRequester((Function0<String>)((Function0)new Function0<String>((Instance)it){
                        final /* synthetic */ Instance $it;

                        public final String invoke() {
                            String string = this.$it.getPublicIpAddress();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.publicIpAddress");
                            return string;
                        }
                        {
                            this.$it = instance;
                            super(0);
                        }
                    }));
                    collection.add(forIpAccessRequester);
                }
                collection = (List)var3_5;
                multiAccessRequester2((List<? extends AccessRequester>)collection);
                return multiAccessRequester3.requestAccess(this.$provisionedLoadBalancer.getAccessProvider());
            }
            {
                this.$jiraNodes = list;
                this.$provisionedLoadBalancer = provisionedLoadBalancer;
                super(0);
            }
        }));
        CompletableFuture loadBalancerAccess2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"load balancer access", (Function0)((Function0)new Function0<Boolean>(provisionedLoadBalancer, jiraNodeHttpAccessProvider){
            final /* synthetic */ ProvisionedLoadBalancer $provisionedLoadBalancer;
            final /* synthetic */ SecurityGroupIngressAccessProvider $jiraNodeHttpAccessProvider;

            public final boolean invoke() {
                return this.$provisionedLoadBalancer.getAccessRequester().requestAccess(this.$jiraNodeHttpAccessProvider);
            }
            {
                this.$provisionedLoadBalancer = provisionedLoadBalancer;
                this.$jiraNodeHttpAccessProvider = securityGroupIngressAccessProvider;
                super(0);
            }
        }));
        CompletableFuture externalAccess2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"external access", (Function0)((Function0)new Function0<Boolean>(this, jiraAccessProvider){
            final /* synthetic */ DataCenterFormula this$0;
            final /* synthetic */ MultiAccessProvider $jiraAccessProvider;

            public final boolean invoke() {
                return DataCenterFormula.access$getAccessRequester$p(this.this$0).requestAccess(this.$jiraAccessProvider);
            }
            {
                this.this$0 = dataCenterFormula;
                this.$jiraAccessProvider = multiAccessProvider;
                super(0);
            }
        }));
        CompletableFuture setupDatabase2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"database", (Function0)((Function0)new Function0<RemoteLocation>(this, databaseSsh, key, databaseSshIp, loadBalancer){
            final /* synthetic */ DataCenterFormula this$0;
            final /* synthetic */ Ssh $databaseSsh;
            final /* synthetic */ Future $key;
            final /* synthetic */ String $databaseSshIp;
            final /* synthetic */ LoadBalancer $loadBalancer;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final RemoteLocation invoke() {
                RemoteLocation remoteLocation;
                Closeable closeable = (Closeable)this.$databaseSsh.newConnection();
                Throwable throwable = null;
                try {
                    SshConnection it = (SshConnection)closeable;
                    DataCenterFormula.access$getDatabaseComputer$p(this.this$0).setUp$aws_infrastructure(it);
                    DataCenterFormula.access$getLogger$p(this.this$0).info("Setting up database...");
                    SshKeyFile sshKeyFile = ((SshKey)this.$key.get()).getFile();
                    String string = this.$databaseSshIp;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"databaseSshIp");
                    sshKeyFile.facilitateSsh(string);
                    String databaseDataLocation = DataCenterFormula.access$getDatabase$p(this.this$0).setup(it);
                    DataCenterFormula.access$getLogger$p(this.this$0).info("Database is set up");
                    DataCenterFormula.access$getLogger$p(this.this$0).info("Starting database...");
                    DataCenterFormula.access$getDatabase$p(this.this$0).start(this.$loadBalancer.getUri(), it);
                    DataCenterFormula.access$getLogger$p(this.this$0).info("Database is started");
                    remoteLocation = new RemoteLocation(this.$databaseSsh.getHost(), databaseDataLocation);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return remoteLocation;
            }
            {
                this.this$0 = dataCenterFormula;
                this.$databaseSsh = ssh;
                this.$key = future;
                this.$databaseSshIp = string;
                this.$loadBalancer = loadBalancer;
                super(0);
            }
        }));
        Iterable $i$f$mapTo = $receiver$iv3 = (Iterable)nodeFormulas2;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
        for (Object item$iv$iv6 : $receiver$iv$iv3) {
            void it6;
            DiagnosableNodeFormula diagnosableNodeFormula = (DiagnosableNodeFormula)item$iv$iv6;
            object3 = destination$iv$iv5;
            object2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)("provision " + it6), (Function0)((Function0)new Function0<StoppedNode>((DiagnosableNodeFormula)it6){
                final /* synthetic */ DiagnosableNodeFormula $it;

                @NotNull
                public final StoppedNode invoke() {
                    return this.$it.provision();
                }
                {
                    this.$it = diagnosableNodeFormula;
                    super(0);
                }
            }));
            object3.add(object2);
        }
        List nodesProvisioning2 = (List)destination$iv$iv5;
        RemoteLocation databaseDataLocation = (RemoteLocation)setupDatabase2.get();
        List updateJiraConfiguration2 = loadBalancer instanceof ApacheProxyLoadBalancer ? CollectionsKt.listOf((Object)new Function2<Ssh, String, Unit>(loadBalancer){

            public final void invoke(@NotNull Ssh p1, @NotNull String p2) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                ((ApacheProxyLoadBalancer)((LoadBalancer)this.receiver)).updateJiraConfiguration(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ApacheProxyLoadBalancer.class);
            }

            public final String getName() {
                return "updateJiraConfiguration";
            }

            public final String getSignature() {
                return "updateJiraConfiguration(Lcom/atlassian/performance/tools/ssh/api/Ssh;Ljava/lang/String;)V";
            }
        }) : CollectionsKt.emptyList();
        Iterable iterable2 = nodesProvisioning2;
        item$iv$iv6 = $receiver$iv2;
        Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv7 : $receiver$iv$iv2) {
            CompletableFuture $i$f$map = (CompletableFuture)item$iv$iv7;
            object3 = destination$iv$iv6;
            object2 = (StoppedNode)((CompletableFuture)((Object)it)).get();
            object3.add(object2);
        }
        $receiver$iv2 = (List)destination$iv$iv6;
        $receiver$iv$iv2 = $receiver$iv2;
        destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv7 : $receiver$iv$iv2) {
            void node2;
            it = (StoppedNode)item$iv$iv7;
            object3 = destination$iv$iv6;
            object2 = (StartedNode)TaskTimer.INSTANCE.time("start " + node2, (Function0)new Function0<StartedNode>((StoppedNode)node2, updateJiraConfiguration2){
                final /* synthetic */ StoppedNode $node;
                final /* synthetic */ List $updateJiraConfiguration$inlined;
                {
                    this.$node = stoppedNode;
                    this.$updateJiraConfiguration$inlined = list;
                    super(0);
                }

                @NotNull
                public final StartedNode invoke() {
                    return this.$node.start(this.$updateJiraConfiguration$inlined);
                }
            });
            object3.add(object2);
        }
        List nodes = (List)destination$iv$iv6;
        if (!((Boolean)rmiNodePublicAccess2.get()).booleanValue()) {
            this.logger.warn("Jira nodes may not have access to other nodes RMI ports. This can cause slow Jira startup.");
        }
        if (!((Boolean)selfDashboardAccess2.get()).booleanValue()) {
            this.logger.warn("It's possible that Jira nodes don't have HTTP access to the load balancer. Dashboards may not work.");
        }
        if (!((Boolean)loadBalancerAccess2.get()).booleanValue()) {
            this.logger.warn("Load balancer may not have access to Jira nodes");
        }
        if (!((Boolean)externalAccess2.get()).booleanValue()) {
            this.logger.warn("It's possible that defined external access to Jira resources (e.g. http, debug, splunk) wasn't granted.");
        }
        executor.shutdownNow();
        TaskTimer.INSTANCE.time("wait for loadbalancer", (Function0)new Function0<Unit>(loadBalancer){
            final /* synthetic */ LoadBalancer $loadBalancer;

            public final void invoke() {
                Duration duration = Duration.ofMinutes(5L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(5)");
                this.$loadBalancer.waitUntilHealthy(duration);
            }
            {
                this.$loadBalancer = loadBalancer;
                super(0);
            }
        });
        $receiver$iv$iv2 = jiraNodes;
        URI uRI = loadBalancer.getUri();
        RemoteLocation remoteLocation = databaseDataLocation;
        object = new RemoteLocation(sharedHomeSsh.getHost(), ((SharedHome)sharedHome2.get()).getRemoteSharedHome());
        collection2 = nodes;
        object2 = jira;
        object3 = jira;
        destination$iv$iv6 = $receiver$iv;
        Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv8 : $receiver$iv$iv) {
            void node3;
            void i;
            int n2 = index$iv$iv++;
            Instance $i$f$mapTo2 = (Instance)item$iv$iv8;
            int $i$f$map = n2;
            collection = destination$iv$iv7;
            RemoteJmx remoteJmx = this.configs.get((int)i).getRemoteJmx();
            String string3 = node3.getPublicIpAddress();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"node.publicIpAddress");
            JmxClient jmxClient = remoteJmx.getClient(string3);
            collection.add(jmxClient);
        }
        collection = (List)destination$iv$iv7;
        ((Jira)object2)((List<StartedNode>)collection2, (RemoteLocation)object, remoteLocation, uRI, (List<? extends JmxClient>)collection);
        Object jira2 = object3;
        this.logger.info(jira2 + " is set up, will expire " + jiraStack.getExpiry());
        ProvisionedJira.Builder builder = new ProvisionedJira.Builder((Jira)jira2);
        Resource resource = provisionedLoadBalancer.getResource();
        ProvisionedStack provisionedStack = jiraStack;
        Intrinsics.checkExpressionValueIsNotNull((Object)provisionedStack, (String)"jiraStack");
        DependentResources dependentResources = new DependentResources(resource, (Resource)provisionedStack);
        object3 = builder;
        DependentResources instances = dependentResources;
        object2 = new DependentResources((Resource)instances, provisionedNetwork.getResource());
        return ((ProvisionedJira.Builder)object3).resource((Resource)object2).accessProvider(jiraAccessProvider).build();
    }

    private DataCenterFormula(List<JiraNodeConfig> configs, LoadBalancerFormula loadBalancerFormula, Apps apps, ProductDistribution productDistribution, JiraHomeSource jiraHomeSource, Database database, Computer computer, Volume jiraVolume, Duration stackCreationTimeout, Network overriddenNetwork, Computer databaseComputer, Volume databaseVolume, AccessRequester accessRequester, String adminPasswordPlainText, boolean waitForUpgrades) {
        this.configs = configs;
        this.loadBalancerFormula = loadBalancerFormula;
        this.apps = apps;
        this.productDistribution = productDistribution;
        this.jiraHomeSource = jiraHomeSource;
        this.database = database;
        this.computer = computer;
        this.jiraVolume = jiraVolume;
        this.stackCreationTimeout = stackCreationTimeout;
        this.overriddenNetwork = overriddenNetwork;
        this.databaseComputer = databaseComputer;
        this.databaseVolume = databaseVolume;
        this.accessRequester = accessRequester;
        this.adminPasswordPlainText = adminPasswordPlainText;
        this.waitForUpgrades = waitForUpgrades;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }

    /* synthetic */ DataCenterFormula(List list, LoadBalancerFormula loadBalancerFormula, Apps apps, ProductDistribution productDistribution, JiraHomeSource jiraHomeSource, Database database, Computer computer, Volume volume, Duration duration, Network network, Computer computer2, Volume volume2, AccessRequester accessRequester, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x200) != 0) {
            network = null;
        }
        this(list, loadBalancerFormula, apps, productDistribution, jiraHomeSource, database, computer, volume, duration, network, computer2, volume2, accessRequester, string, bl);
    }

    @Deprecated(message="Use DataCenterFormula.Builder instead.")
    public DataCenterFormula(@NotNull List<JiraNodeConfig> configs, @NotNull LoadBalancerFormula loadBalancerFormula, @NotNull Apps apps, @NotNull ApplicationStorage application, @NotNull JiraHomeSource jiraHomeSource, @NotNull Database database, @NotNull Computer computer) {
        Intrinsics.checkParameterIsNotNull(configs, (String)"configs");
        Intrinsics.checkParameterIsNotNull((Object)loadBalancerFormula, (String)"loadBalancerFormula");
        Intrinsics.checkParameterIsNotNull((Object)apps, (String)"apps");
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)jiraHomeSource, (String)"jiraHomeSource");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        Intrinsics.checkParameterIsNotNull((Object)computer, (String)"computer");
        ProductDistribution productDistribution = new ApplicationStorageWrapper(application);
        Volume volume = new Volume(100);
        Duration duration = Duration.ofMinutes(30L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(30)");
        this(configs, loadBalancerFormula, apps, productDistribution, jiraHomeSource, database, computer, volume, duration, null, new M4ExtraLargeElastic(), new Volume(100), Defaults.INSTANCE.getAccessRequester(), Defaults.INSTANCE.getAdminPasswordPlainText(), true, 512, null);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Use DataCenterFormula.Builder instead.")
    public DataCenterFormula(@NotNull Apps apps, @NotNull ApplicationStorage application, @NotNull JiraHomeSource jiraHomeSource, @NotNull Database database) {
        Collection<JiraNodeConfig> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)apps, (String)"apps");
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)jiraHomeSource, (String)"jiraHomeSource");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        int n = 1;
        Iterable iterable = (Iterable)new IntRange(n, 2);
        DataCenterFormula dataCenterFormula = this;
        void var6_8 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            JiraNodeConfig jiraNodeConfig = new JiraNodeConfig.Builder().name("jira-node-" + (int)it).build();
            collection.add(jiraNodeConfig);
        }
        collection = (List)destination$iv$iv;
        LoadBalancerFormula loadBalancerFormula = new ApacheEc2LoadBalancerFormula();
        ProductDistribution productDistribution = new ApplicationStorageWrapper(application);
        Computer computer = new C4EightExtraLargeElastic();
        Volume volume = new Volume(100);
        Duration duration = Duration.ofMinutes(30L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(30)");
        dataCenterFormula((List)collection, loadBalancerFormula, apps, productDistribution, jiraHomeSource, database, computer, volume, duration, null, new M4ExtraLargeElastic(), new Volume(100), Defaults.INSTANCE.getAccessRequester(), Defaults.INSTANCE.getAdminPasswordPlainText(), true, 512, null);
    }

    public /* synthetic */ DataCenterFormula(@NotNull List configs, @NotNull LoadBalancerFormula loadBalancerFormula, @NotNull Apps apps, @NotNull ProductDistribution productDistribution, @NotNull JiraHomeSource jiraHomeSource, @NotNull Database database, @NotNull Computer computer, @NotNull Volume jiraVolume, @NotNull Duration stackCreationTimeout, @Nullable Network overriddenNetwork, @NotNull Computer databaseComputer, @NotNull Volume databaseVolume, @NotNull AccessRequester accessRequester, @NotNull String adminPasswordPlainText, boolean waitForUpgrades, DefaultConstructorMarker $constructor_marker) {
        this(configs, loadBalancerFormula, apps, productDistribution, jiraHomeSource, database, computer, jiraVolume, stackCreationTimeout, overriddenNetwork, databaseComputer, databaseVolume, accessRequester, adminPasswordPlainText, waitForUpgrades);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(DataCenterFormula $this) {
        return $this.logger;
    }

    @NotNull
    public static final /* synthetic */ ProvisionedJira access$provision(DataCenterFormula $this, @NotNull ExecutorService executor, @NotNull Investment investment, @NotNull Storage pluginsTransport, @NotNull Storage resultsTransport, @NotNull Future key, @NotNull String roleProfile, @NotNull Aws aws) {
        return $this.provision(executor, investment, pluginsTransport, resultsTransport, key, roleProfile, aws);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/DataCenterFormula$Defaults;", "", "()V", "accessRequester", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/access/AccessRequester;", "getAccessRequester", "()Lcom/atlassian/performance/tools/awsinfrastructure/api/network/access/AccessRequester;", "adminPasswordPlainText", "", "getAdminPasswordPlainText", "()Ljava/lang/String;", "aws-infrastructure"})
    public static final class Defaults {
        @NotNull
        private static final AccessRequester accessRequester;
        @NotNull
        private static final String adminPasswordPlainText = "admin";
        public static final Defaults INSTANCE;

        @NotNull
        public final AccessRequester getAccessRequester() {
            return accessRequester;
        }

        @NotNull
        public final String getAdminPasswordPlainText() {
            return adminPasswordPlainText;
        }

        private Defaults() {
        }

        static {
            Defaults defaults;
            INSTANCE = defaults = new Defaults();
            accessRequester = new ForIpAccessRequester((Function0<String>)((Function0)new LocalPublicIpv4Provider()));
            adminPasswordPlainText = adminPasswordPlainText;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u001d\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010&\u001a\u00020\nJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010\u0017\u001a\u00020\u00002\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0016J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u0015\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b'J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/DataCenterFormula$Builder;", "", "application", "Lcom/atlassian/performance/tools/awsinfrastructure/api/storage/ApplicationStorage;", "jiraHomeSource", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;", "database", "Lcom/atlassian/performance/tools/infrastructure/api/database/Database;", "(Lcom/atlassian/performance/tools/awsinfrastructure/api/storage/ApplicationStorage;Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;Lcom/atlassian/performance/tools/infrastructure/api/database/Database;)V", "formula", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/DataCenterFormula;", "(Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/DataCenterFormula;)V", "productDistribution", "Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;", "(Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;Lcom/atlassian/performance/tools/infrastructure/api/database/Database;)V", "accessRequester", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/access/AccessRequester;", "adminPasswordPlainText", "", "apps", "Lcom/atlassian/performance/tools/infrastructure/api/app/Apps;", "computer", "Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Computer;", "configs", "", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraNodeConfig;", "databaseComputer", "databaseVolume", "Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Volume;", "jiraVolume", "loadBalancerFormula", "Lcom/atlassian/performance/tools/awsinfrastructure/api/loadbalancer/LoadBalancerFormula;", "network", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/Network;", "stackCreationTimeout", "Ljava/time/Duration;", "waitForUpgrades", "", "build", "network$aws_infrastructure", "aws-infrastructure"})
    public static final class Builder {
        private List<JiraNodeConfig> configs;
        private LoadBalancerFormula loadBalancerFormula;
        private Apps apps;
        private Computer computer;
        private Volume jiraVolume;
        private Duration stackCreationTimeout;
        private Network network;
        private Computer databaseComputer;
        private Volume databaseVolume;
        private AccessRequester accessRequester;
        private String adminPasswordPlainText;
        private boolean waitForUpgrades;
        private final ProductDistribution productDistribution;
        private final JiraHomeSource jiraHomeSource;
        private final Database database;

        @NotNull
        public final Builder configs(@NotNull List<JiraNodeConfig> configs) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(configs, (String)"configs");
            Builder $receiver = builder = this;
            $receiver.configs = configs;
            return builder;
        }

        @NotNull
        public final Builder loadBalancerFormula(@NotNull LoadBalancerFormula loadBalancerFormula) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)loadBalancerFormula, (String)"loadBalancerFormula");
            Builder $receiver = builder = this;
            $receiver.loadBalancerFormula = loadBalancerFormula;
            return builder;
        }

        @NotNull
        public final Builder apps(@NotNull Apps apps) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)apps, (String)"apps");
            Builder $receiver = builder = this;
            $receiver.apps = apps;
            return builder;
        }

        @NotNull
        public final Builder computer(@NotNull Computer computer) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)computer, (String)"computer");
            Builder $receiver = builder = this;
            $receiver.computer = computer;
            return builder;
        }

        @NotNull
        public final Builder jiraVolume(@NotNull Volume jiraVolume) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)jiraVolume, (String)"jiraVolume");
            Builder $receiver = builder = this;
            $receiver.jiraVolume = jiraVolume;
            return builder;
        }

        @NotNull
        public final Builder stackCreationTimeout(@NotNull Duration stackCreationTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)stackCreationTimeout, (String)"stackCreationTimeout");
            Builder $receiver = builder = this;
            $receiver.stackCreationTimeout = stackCreationTimeout;
            return builder;
        }

        @NotNull
        public final Builder databaseComputer(@NotNull Computer databaseComputer) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)databaseComputer, (String)"databaseComputer");
            Builder $receiver = builder = this;
            $receiver.databaseComputer = databaseComputer;
            return builder;
        }

        @NotNull
        public final Builder databaseVolume(@NotNull Volume databaseVolume) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)databaseVolume, (String)"databaseVolume");
            Builder $receiver = builder = this;
            $receiver.databaseVolume = databaseVolume;
            return builder;
        }

        @NotNull
        public final Builder adminPasswordPlainText(@NotNull String adminPasswordPlainText) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)adminPasswordPlainText, (String)"adminPasswordPlainText");
            Builder $receiver = builder = this;
            $receiver.adminPasswordPlainText = adminPasswordPlainText;
            return builder;
        }

        @NotNull
        public final Builder network$aws_infrastructure(@NotNull Network network) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
            Builder $receiver = builder = this;
            $receiver.network = network;
            return builder;
        }

        @NotNull
        public final Builder accessRequester(@NotNull AccessRequester accessRequester) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)accessRequester, (String)"accessRequester");
            Builder $receiver = builder = this;
            $receiver.accessRequester = accessRequester;
            return builder;
        }

        @NotNull
        public final Builder waitForUpgrades(boolean waitForUpgrades) {
            Builder builder;
            Builder $receiver = builder = this;
            $receiver.waitForUpgrades = waitForUpgrades;
            return builder;
        }

        @NotNull
        public final DataCenterFormula build() {
            return new DataCenterFormula(this.configs, this.loadBalancerFormula, this.apps, this.productDistribution, this.jiraHomeSource, this.database, this.computer, this.jiraVolume, this.stackCreationTimeout, this.network, this.databaseComputer, this.databaseVolume, this.accessRequester, this.adminPasswordPlainText, this.waitForUpgrades, null);
        }

        /*
         * WARNING - void declaration
         */
        public Builder(@NotNull ProductDistribution productDistribution, @NotNull JiraHomeSource jiraHomeSource, @NotNull Database database) {
            Collection<JiraNodeConfig> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)productDistribution, (String)"productDistribution");
            Intrinsics.checkParameterIsNotNull((Object)jiraHomeSource, (String)"jiraHomeSource");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            this.productDistribution = productDistribution;
            this.jiraHomeSource = jiraHomeSource;
            this.database = database;
            int n = 1;
            Iterable iterable = (Iterable)new IntRange(n, 2);
            Builder builder = this;
            void var5_7 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
                collection = destination$iv$iv;
                JiraNodeConfig jiraNodeConfig = new JiraNodeConfig.Builder().name("jira-node-" + (int)it).build();
                collection.add(jiraNodeConfig);
            }
            collection = (List)destination$iv$iv;
            builder.configs = collection;
            this.loadBalancerFormula = new ApacheEc2LoadBalancerFormula();
            this.apps = new Apps(CollectionsKt.emptyList());
            this.computer = new C4EightExtraLargeElastic();
            this.jiraVolume = new Volume(100);
            Duration duration = Duration.ofMinutes(30L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(30)");
            this.stackCreationTimeout = duration;
            this.databaseComputer = new M4ExtraLargeElastic();
            this.databaseVolume = new Volume(100);
            this.accessRequester = Defaults.INSTANCE.getAccessRequester();
            this.adminPasswordPlainText = "admin";
            this.waitForUpgrades = true;
        }

        @Deprecated(message="Use `ProductDistribution` instead of `ApplicationStorage`.")
        public Builder(@NotNull ApplicationStorage application, @NotNull JiraHomeSource jiraHomeSource, @NotNull Database database) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            Intrinsics.checkParameterIsNotNull((Object)jiraHomeSource, (String)"jiraHomeSource");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            this(new ApplicationStorageWrapper(application), jiraHomeSource, database);
        }

        public Builder(@NotNull DataCenterFormula formula) {
            Intrinsics.checkParameterIsNotNull((Object)formula, (String)"formula");
            this(formula.productDistribution, formula.jiraHomeSource, formula.database);
            this.configs = formula.configs;
            this.loadBalancerFormula = formula.loadBalancerFormula;
            this.apps = formula.apps;
            this.computer = formula.computer;
            this.jiraVolume = formula.jiraVolume;
            this.stackCreationTimeout = formula.stackCreationTimeout;
            this.network = formula.overriddenNetwork;
            this.databaseComputer = formula.databaseComputer;
            this.databaseVolume = formula.databaseVolume;
            this.accessRequester = formula.accessRequester;
            this.adminPasswordPlainText = formula.adminPasswordPlainText;
            this.waitForUpgrades = formula.waitForUpgrades;
        }
    }
}

