/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api.aws;

import com.atlassian.performance.tools.aws.api.StorageLocation;
import com.atlassian.performance.tools.awsinfrastructure.api.aws.AwsCli;
import com.atlassian.performance.tools.infrastructure.api.os.Ubuntu;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ.\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/aws/AwsCli;", "", "()V", "download", "", "location", "Lcom/atlassian/performance/tools/aws/api/StorageLocation;", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "target", "", "timeout", "Ljava/time/Duration;", "downloadFile", "file", "downloadFileCommand", "ensureAwsCli", "upload", "source", "uploadFile", "Companion", "aws-infrastructure"})
public final class AwsCli {
    private static final ConcurrentHashMap<String, Object> LOCKS;
    @Deprecated
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ensureAwsCli(@NotNull SshConnection ssh) {
        Object lock2;
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Object object = lock2 = LOCKS.computeIfAbsent(ssh.getHost().getIpAddress(), ensureAwsCli.lock.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"lock");
        Object object2 = object;
        synchronized (object2) {
            Duration duration = Duration.ofSeconds(30L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(30)");
            Level level = Level.TRACE;
            Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.TRACE");
            Level level2 = Level.TRACE;
            Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.TRACE");
            SshConnection.SshResult awsCliExecutionResult = ssh.safeExecute("aws --version", duration, level, level2);
            if (!awsCliExecutionResult.isSuccessful()) {
                Ubuntu ubuntu = new Ubuntu();
                List list = CollectionsKt.listOf((Object[])new String[]{"zip", "python"});
                Duration duration2 = Duration.ofMinutes(3L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofMinutes(3)");
                ubuntu.install(ssh, list, duration2);
                Duration duration3 = Duration.ofSeconds(50L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ofSeconds(50)");
                ssh.execute("curl --silent https://s3.amazonaws.com/aws-cli/awscli-bundle-1.15.51.zip -o awscli-bundle.zip", duration3);
                ssh.execute("unzip -n -q awscli-bundle.zip");
                Duration duration4 = Duration.ofSeconds(60L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration4, (String)"Duration.ofSeconds(60)");
                ssh.execute("sudo ./awscli-bundle/install -i /usr/local/aws -b /usr/local/bin/aws", duration4);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void download(@NotNull StorageLocation location, @NotNull SshConnection ssh, @NotNull String target, @NotNull Duration timeout) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        this.ensureAwsCli(ssh);
        ssh.execute("aws s3 sync --only-show-errors --region=" + location.getRegionName() + ' ' + location.getUri() + ' ' + target, timeout);
    }

    public static /* bridge */ /* synthetic */ void download$default(AwsCli awsCli, StorageLocation storageLocation, SshConnection sshConnection, String string, Duration duration, int n, Object object) {
        if ((n & 8) != 0) {
            Duration duration2 = Duration.ofSeconds(30L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofSeconds(30)");
            duration = duration2;
        }
        awsCli.download(storageLocation, sshConnection, string, duration);
    }

    public final void upload(@NotNull StorageLocation location, @NotNull SshConnection ssh, @NotNull String source, @NotNull Duration timeout) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        this.ensureAwsCli(ssh);
        ssh.execute("aws s3 sync --only-show-errors --region=" + location.getRegionName() + ' ' + source + ' ' + location.getUri(), timeout);
    }

    public final void downloadFile(@NotNull StorageLocation location, @NotNull SshConnection ssh, @NotNull String file, @NotNull String target, @NotNull Duration timeout) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        ssh.execute(this.downloadFileCommand(location, ssh, file, target), timeout);
    }

    @NotNull
    public final String downloadFileCommand(@NotNull StorageLocation location, @NotNull SshConnection ssh, @NotNull String file, @NotNull String target) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.ensureAwsCli(ssh);
        return "aws s3 cp --only-show-errors --region=" + location.getRegionName() + ' ' + location.getUri() + '/' + file + ' ' + target;
    }

    public final void uploadFile(@NotNull StorageLocation location, @NotNull SshConnection ssh, @NotNull String source, @NotNull Duration timeout) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        this.ensureAwsCli(ssh);
        ssh.execute("aws s3 cp --only-show-errors --region=" + location.getRegionName() + ' ' + source + ' ' + location.getUri() + '/' + source, timeout);
    }

    static {
        Companion = new Companion(null);
        LOCKS = new ConcurrentHashMap();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/aws/AwsCli$Companion;", "", "()V", "LOCKS", "Ljava/util/concurrent/ConcurrentHashMap;", "", "aws-infrastructure"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

