/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api;

import com.atlassian.performance.tools.aws.api.StorageLocation;
import com.atlassian.performance.tools.awsinfrastructure.api.dataset.S3DatasetPackage;
import com.atlassian.performance.tools.infrastructure.api.database.Database;
import com.atlassian.performance.tools.infrastructure.api.database.MySqlDatabase;
import com.atlassian.performance.tools.infrastructure.api.dataset.Dataset;
import com.atlassian.performance.tools.infrastructure.api.dataset.DatasetPackage;
import com.atlassian.performance.tools.infrastructure.api.dataset.FileArchiver;
import com.atlassian.performance.tools.infrastructure.api.dataset.HttpDatasetPackage;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraHomePackage;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraHomeSource;
import java.net.URI;
import java.time.Duration;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nJ\b\u0010\f\u001a\u00020\u0004H\u0007J\u0006\u0010\r\u001a\u00020\u0004J\u0006\u0010\u000e\u001a\u00020\u0004J\u0006\u0010\u000f\u001a\u00020\u0004\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/DatasetCatalogue;", "", "()V", "custom", "Lcom/atlassian/performance/tools/infrastructure/api/dataset/Dataset;", "location", "Lcom/atlassian/performance/tools/aws/api/StorageLocation;", "label", "", "databaseDownload", "Ljava/time/Duration;", "jiraHomeDownload", "largeJira", "largeJiraEight", "largeJiraSeven", "smallJiraSeven", "aws-infrastructure"})
public final class DatasetCatalogue {
    @Deprecated(message="Use largeJiraSeven() instead")
    @NotNull
    public final Dataset largeJira() {
        return this.largeJiraSeven();
    }

    @NotNull
    public final Dataset largeJiraSeven() {
        URI bucketUri = new URI("https://s3-eu-west-1.amazonaws.com/jpt-custom-datasets-storage-a008820-datasetbucket-1sjxdtrv5hdhj/");
        URI uRI = bucketUri.resolve("dataset-d4684761-116b-49ae-9cce-e45cecdcae2a/database.tar.bz2");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"bucketUri.resolve(\"datas\u2026dcae2a/database.tar.bz2\")");
        Duration duration = Duration.ofMinutes(17L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"ofMinutes(17)");
        Database database = (Database)new MySqlDatabase((DatasetPackage)new HttpDatasetPackage(uRI, duration));
        URI uRI2 = bucketUri.resolve("dataset-d4684761-116b-49ae-9cce-e45cecdcae2a/jirahome.tar.bz2");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI2, (String)"bucketUri.resolve(\"datas\u2026dcae2a/jirahome.tar.bz2\")");
        Duration duration2 = Duration.ofMinutes(21L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"ofMinutes(21)");
        JiraHomeSource jiraHomeSource = (JiraHomeSource)new JiraHomePackage((DatasetPackage)new HttpDatasetPackage(uRI2, duration2));
        Database database2 = database;
        String string = "2M issues, format 7";
        return new Dataset(database2, jiraHomeSource, string);
    }

    @NotNull
    public final Dataset largeJiraEight() {
        URI bucketUri = new URI("https://s3.eu-central-1.amazonaws.com/jpt-custom-datasets-storage-a008820-datasetbucket-1nrja8d1upind/");
        URI uRI = bucketUri.resolve("dataset-fa563790-84c2-4cdf-a49c-c5ca4b223c94/database.tar.bz2");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"bucketUri.resolve(\"datas\u2026223c94/database.tar.bz2\")");
        Duration duration = Duration.ofMinutes(17L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"ofMinutes(17)");
        Database database = (Database)new MySqlDatabase((DatasetPackage)new HttpDatasetPackage(uRI, duration));
        URI uRI2 = bucketUri.resolve("dataset-fa563790-84c2-4cdf-a49c-c5ca4b223c94/jirahome.tar.bz2");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI2, (String)"bucketUri.resolve(\"datas\u2026223c94/jirahome.tar.bz2\")");
        Duration duration2 = Duration.ofMinutes(21L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"ofMinutes(21)");
        JiraHomeSource jiraHomeSource = (JiraHomeSource)new JiraHomePackage((DatasetPackage)new HttpDatasetPackage(uRI2, duration2));
        Database database2 = database;
        String string = "2M issues, format 8";
        return new Dataset(database2, jiraHomeSource, string);
    }

    @NotNull
    public final Dataset smallJiraSeven() {
        URI uRI;
        URI uri = uRI = new URI("https://s3-eu-west-1.amazonaws.com/").resolve("jpt-custom-datasets-storage-a008820-datasetbucket-1sjxdtrv5hdhj/").resolve("dataset-f8dba866-9d1b-492e-b76c-f4a78ac3958c/");
        URI uRI2 = uri.resolve("database.tar.bz2");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI2, (String)"uri.resolve(\"database.tar.bz2\")");
        Duration duration = Duration.ofMinutes(6L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"ofMinutes(6)");
        Database database = (Database)new MySqlDatabase((DatasetPackage)new HttpDatasetPackage(uRI2, duration));
        URI uRI3 = uri.resolve("jirahome.tar.bz2");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI3, (String)"uri.resolve(\"jirahome.tar.bz2\")");
        Duration duration2 = Duration.ofMinutes(6L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"ofMinutes(6)");
        JiraHomeSource jiraHomeSource = (JiraHomeSource)new JiraHomePackage((DatasetPackage)new HttpDatasetPackage(uRI3, duration2));
        Database database2 = database;
        String string = "7k issues JSW 7.2.0";
        return new Dataset(database2, jiraHomeSource, string);
    }

    @NotNull
    public final Dataset custom(@NotNull StorageLocation location, @NotNull String label, @NotNull Duration databaseDownload, @NotNull Duration jiraHomeDownload) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        Intrinsics.checkParameterIsNotNull((Object)databaseDownload, (String)"databaseDownload");
        Intrinsics.checkParameterIsNotNull((Object)jiraHomeDownload, (String)"jiraHomeDownload");
        FileArchiver archiver = new FileArchiver();
        JiraHomeSource jiraHomeSource = (JiraHomeSource)new JiraHomePackage((DatasetPackage)new S3DatasetPackage(archiver.zippedName("jirahome"), location, "jirahome", jiraHomeDownload));
        Database database = (Database)new MySqlDatabase((DatasetPackage)new S3DatasetPackage(archiver.zippedName("database"), location, "database", databaseDownload));
        String string = label;
        return new Dataset(database, jiraHomeSource, string);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Dataset custom$default(DatasetCatalogue datasetCatalogue, StorageLocation storageLocation, String string, Duration duration, Duration duration2, int n, Object object) {
        if ((n & 2) != 0) {
            string = "custom";
        }
        if ((n & 4) != 0) {
            Duration duration3 = Duration.ofMinutes(10L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"ofMinutes(10)");
            duration = duration3;
        }
        if ((n & 8) != 0) {
            Duration duration4 = Duration.ofMinutes(10L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration4, (String)"ofMinutes(10)");
            duration2 = duration4;
        }
        return datasetCatalogue.custom(storageLocation, string, duration, duration2);
    }
}

