/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure;

import com.atlassian.performance.tools.infrastructure.api.jira.JiraNodeConfig;
import com.atlassian.performance.tools.io.api.ClasspathResourcesKt;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\r\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0006\u0010\u0011\u001a\u00020\u0003J\u001c\u0010\u0012\u001a\u00020\u00002\u0014\u0010\u0013\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u00030\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/TemplateBuilder;", "", "baseTemplateName", "", "(Ljava/lang/String;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "mappedTemplate", "Lcom/fasterxml/jackson/databind/JsonNode;", "kotlin.jvm.PlatformType", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "template", "adaptTo", "configs", "", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraNodeConfig;", "build", "replaceDescription", "descriptionTransform", "Lkotlin/Function1;", "setNodesCount", "desiredNodesCount", "", "toString", "aws-infrastructure"})
public final class TemplateBuilder {
    private final Logger logger;
    private final String template;
    private final ObjectMapper mapper;
    private final JsonNode mappedTemplate;
    private final String baseTemplateName;

    @NotNull
    public final String adaptTo(@NotNull List<JiraNodeConfig> configs) {
        Intrinsics.checkParameterIsNotNull(configs, (String)"configs");
        this.setNodesCount(configs.size());
        this.replaceDescription((Function1<? super String, String>)((Function1)new Function1<String, String>(configs){
            final /* synthetic */ List $configs;

            @NotNull
            public final String invoke(@Nullable String oldDescription) {
                String string;
                CharSequence charSequence;
                Regex regex;
                String string2 = oldDescription;
                if (string2 == null || (string2 = (regex = new Regex("\\d node")).replace(charSequence = (CharSequence)string2, string = this.$configs.size() + " node")) == null) {
                    string2 = "Serves a " + this.$configs.size() + " node Jira without a load balancer";
                }
                return string2;
            }
            {
                this.$configs = list;
                super(1);
            }
        }));
        return this.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TemplateBuilder setNodesCount(int desiredNodesCount) {
        Object resource;
        Iterator iterator;
        TemplateBuilder templateBuilder;
        TemplateBuilder $receiver = templateBuilder = this;
        List existingNodes = new ArrayList();
        JsonNode jsonNode = $receiver.mappedTemplate.get("Resources");
        if (jsonNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        }
        ObjectNode resources = (ObjectNode)jsonNode;
        Iterator iterator2 = resources.fieldNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterator2, (String)"resources.fieldNames()");
        Iterator iterator3 = iterator = iterator2;
        while (iterator3.hasNext()) {
            Object object = resource = (String)iterator3.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"resource");
            if (!StringsKt.startsWith((String)object, (String)"jira", (boolean)true) || !Intrinsics.areEqual((Object)resources.get((String)resource).get("Type").asText(), (Object)"AWS::EC2::Instance")) continue;
            $receiver.logger.debug("Existing Jira node in " + $receiver.baseTemplateName + ": " + (String)resource);
            existingNodes.add(resource);
        }
        resource = existingNodes;
        if (resource.size() == desiredNodesCount) {
            return $receiver;
        }
        JsonNode nodeTemplate = resources.get((String)existingNodes.get(0));
        for (String existingNode : existingNodes) {
            resources.remove(existingNode);
        }
        int existingNode = 1;
        int n = desiredNodesCount;
        if (existingNode <= n) {
            while (true) {
                void nodeNumber;
                resources.set("jira" + (int)nodeNumber, nodeTemplate);
                if (nodeNumber == n) break;
                ++nodeNumber;
            }
        }
        return templateBuilder;
    }

    @NotNull
    public final TemplateBuilder replaceDescription(@NotNull Function1<? super String, String> descriptionTransform) {
        TemplateBuilder templateBuilder;
        Intrinsics.checkParameterIsNotNull(descriptionTransform, (String)"descriptionTransform");
        TemplateBuilder $receiver = templateBuilder = this;
        JsonNode jsonNode = $receiver.mappedTemplate;
        if (jsonNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        }
        ObjectNode objectNode = (ObjectNode)jsonNode;
        ObjectNode it = objectNode;
        String currentDescription = it.has("Description") ? it.get("Description").asText() : null;
        it.put("Description", (String)descriptionTransform.invoke((Object)currentDescription));
        return templateBuilder;
    }

    @NotNull
    public String toString() {
        String string = this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.mappedTemplate);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mapper\n        .writerWi\u2026eAsString(mappedTemplate)");
        return StringsKt.replace$default((String)string, (String)"__Ref__", (String)"!Ref", (boolean)false, (int)4, null);
    }

    @NotNull
    public final String build() {
        String string;
        String it = string = this.toString();
        this.logger.debug("Transformed " + this.baseTemplateName + " into: \n" + it);
        return string;
    }

    public TemplateBuilder(@NotNull String baseTemplateName) {
        Intrinsics.checkParameterIsNotNull((Object)baseTemplateName, (String)"baseTemplateName");
        this.baseTemplateName = baseTemplateName;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        this.template = StringsKt.replace$default((String)ClasspathResourcesKt.readResourceText((String)("aws/" + this.baseTemplateName)), (String)"!Ref", (String)"__Ref__", (boolean)false, (int)4, null);
        this.mapper = new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER));
        this.mappedTemplate = this.mapper.readTree(this.template);
    }
}

