/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paralyzer.core.reporting;

import com.atlassian.paralyzer.api.Extension;
import com.atlassian.paralyzer.api.TestResult;
import com.atlassian.paralyzer.api.TestSuite;
import com.atlassian.paralyzer.api.engine.AfterSuite;
import com.atlassian.paralyzer.api.engine.BeforeSuite;
import com.atlassian.paralyzer.api.engine.TestEngineSettings;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public class SuiteExecutionTimeListener
implements BeforeSuite,
AfterSuite {
    private final Map<String, Instant> startTimes = new ConcurrentHashMap<String, Instant>();
    private final String extensionType = "ExecutionTime";
    private final String propertyName = "time";

    public void afterSuite(TestSuite suite, List<TestResult> results, TestEngineSettings settings) {
        Instant now = Instant.now();
        Instant startTime = this.startTimes.get(this.getSuiteId(suite));
        if (startTime != null) {
            this.startTimes.remove(this.getSuiteId(suite));
            Double executionTime = (double)(now.toEpochMilli() - startTime.toEpochMilli()) / 1000.0;
            suite.addExtension(new Extension("ExecutionTime", Collections.singletonMap("time", Optional.of(executionTime))));
        }
    }

    private String getSuiteId(TestSuite suite) {
        return suite.getTestEngineId() + "_" + suite.getUniqueId();
    }

    public void beforeSuite(TestSuite suite, TestEngineSettings settings) {
        this.startTimes.put(this.getSuiteId(suite), Instant.now());
    }

    public Predicate<String> getSupportedEnginePredicate() {
        return b -> true;
    }
}

