/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paralyzer.core;

import com.atlassian.paralyzer.api.NoRunnerAvailableException;
import com.atlassian.paralyzer.api.Paralyzer;
import com.atlassian.paralyzer.api.PluginModule;
import com.atlassian.paralyzer.api.Runner;
import com.atlassian.paralyzer.api.RunnerConnector;
import com.atlassian.paralyzer.api.RunnerExecutionStrategy;
import com.atlassian.paralyzer.api.Settings;
import com.atlassian.paralyzer.api.TestDiscoveryRequest;
import com.atlassian.paralyzer.api.TestEngine;
import com.atlassian.paralyzer.api.TestResult;
import com.atlassian.paralyzer.api.TestResultCollector;
import com.atlassian.paralyzer.api.TestResultListener;
import com.atlassian.paralyzer.api.TestSuiteProcessorChain;
import com.atlassian.paralyzer.api.dependency.management.DependencyContainer;
import com.atlassian.paralyzer.api.engine.AfterAll;
import com.atlassian.paralyzer.api.engine.AfterEach;
import com.atlassian.paralyzer.api.engine.AfterSuite;
import com.atlassian.paralyzer.api.engine.BeforeAll;
import com.atlassian.paralyzer.api.engine.BeforeEach;
import com.atlassian.paralyzer.api.engine.BeforeSuite;
import com.atlassian.paralyzer.api.engine.TestEngineListener;
import com.atlassian.paralyzer.core.DefaultTestSuiteProcessorChain;
import com.google.inject.AbstractModule;
import com.google.inject.ConfigurationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParalyzerCore
implements Paralyzer {
    private static final Logger log = LoggerFactory.getLogger(ParalyzerCore.class);
    protected final DependencyContainer dependencyContainer = new DependencyContainer();
    protected final List<PluginModule> plugins = new ArrayList<PluginModule>();
    protected Settings settings = new Settings();
    protected Set<TestEngine> testEngines;
    protected TestSuiteProcessorChain processorChain;
    protected RunnerExecutionStrategy executionStrategy;
    protected RunnerConnector runnerConnector;

    public ParalyzerCore() {
        this.dependencyContainer.addMultiInstanceType(TestEngine.class);
        this.dependencyContainer.addMultiInstanceType(TestResultCollector.class);
        this.dependencyContainer.addMultiInstanceType(TestResultListener.class);
        this.dependencyContainer.addMultiInstanceType(TestEngineListener.class);
        this.dependencyContainer.addMultiInstanceType(BeforeAll.class);
        this.dependencyContainer.addMultiInstanceType(AfterAll.class);
        this.dependencyContainer.addMultiInstanceType(AfterSuite.class);
        this.dependencyContainer.addMultiInstanceType(BeforeSuite.class);
        this.dependencyContainer.addMultiInstanceType(AfterEach.class);
        this.dependencyContainer.addMultiInstanceType(BeforeEach.class);
        this.dependencyContainer.addSingleInstanceType(TestSuiteProcessorChain.class);
        this.dependencyContainer.addSingleInstanceType(RunnerExecutionStrategy.class);
        this.dependencyContainer.addSingleInstanceType(RunnerConnector.class);
        this.dependencyContainer.addObject((Object)new DefaultTestSuiteProcessorChain());
    }

    public void addPluginObject(Object object) {
        this.dependencyContainer.addObject(object);
    }

    public void addPluginModule(PluginModule module) {
        log.info("Registered new plugin into Paralyzer: {}", (Object)module);
        this.dependencyContainer.addModule((AbstractModule)module);
        this.plugins.add(module);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void execute(TestDiscoveryRequest request) throws NoRunnerAvailableException {
        this.setUpPlugins();
        log.info("Init dependency container");
        this.dependencyContainer.init();
        log.info("Execution started");
        this.validateSettings(request);
        log.info("Settings validation successful");
        this.prepare();
        log.info("Prepare successful");
        try {
            Thread thread = new Thread(() -> {
                log.info("Test execution started");
                this.executeTests(request);
                log.info("Test execution successful");
                this.tearDown();
                log.info("Tear down successful");
                log.info("Still active threads: " + Thread.activeCount());
                Thread.currentThread().getThreadGroup().interrupt();
            });
            thread.start();
            thread.join();
        }
        catch (InterruptedException e) {
            log.info("Still active threads: " + Thread.activeCount());
        }
    }

    private void setUpPlugins() {
        this.plugins.forEach(pluginModule -> {
            log.debug("Set up plugin: {}", pluginModule);
            pluginModule.setUp(this.settings);
        });
    }

    protected void tearDown() {
        this.plugins.forEach(pluginModule -> {
            log.debug("Tear down plugin: {}", pluginModule);
            pluginModule.tearDown();
        });
    }

    protected void executeTests(TestDiscoveryRequest request) {
        List<TestResult> testResults = this.runTests(request);
        this.runnerConnector.tearDown();
        this.collectResults(testResults);
    }

    private void collectResults(List<TestResult> testResults) {
        log.info("Collecting results");
        Set testResultCollector = this.dependencyContainer.getSetOfInstances(TestResultCollector.class);
        if (testResultCollector != null) {
            testResultCollector.forEach(collector -> {
                log.debug("Collector: {}", collector);
                collector.collectResults(testResults);
            });
        }
    }

    private List<TestResult> runTests(TestDiscoveryRequest request) {
        this.testEngines.forEach(testEngine -> {
            log.debug("Executing TestEngine: {}", testEngine);
            List testSuites = testEngine.discoverTests(request);
            Stream testSuitesStream = this.processorChain.process(testSuites.stream(), testEngine.getUniqueId());
            this.executionStrategy.addTests(testSuitesStream.collect(Collectors.toList()));
        });
        return this.executionStrategy.executeTests();
    }

    protected void validateSettings(TestDiscoveryRequest request) {
        if (request == null) {
            throw new NullPointerException();
        }
        try {
            this.testEngines = this.dependencyContainer.getSetOfInstances(TestEngine.class);
            this.processorChain = (TestSuiteProcessorChain)this.dependencyContainer.getInstance(TestSuiteProcessorChain.class);
            this.executionStrategy = (RunnerExecutionStrategy)this.dependencyContainer.getInstance(RunnerExecutionStrategy.class);
            this.runnerConnector = (RunnerConnector)this.dependencyContainer.getInstance(RunnerConnector.class);
        }
        catch (ConfigurationException exception) {
            throw new IllegalStateException(exception);
        }
        if (this.testEngines.isEmpty() || this.processorChain == null || this.executionStrategy == null || this.runnerConnector == null) {
            throw new IllegalStateException();
        }
    }

    protected void prepare() throws NoRunnerAvailableException {
        this.prepareRunners();
        this.prepareTestEngines();
        this.preparePlugins();
    }

    protected void preparePlugins() {
        this.plugins.forEach(pluginModule -> {
            log.debug("Set up processor chain by plugin: {}", pluginModule);
            pluginModule.setUpProcessorsChain(this.processorChain);
        });
    }

    protected void prepareTestEngines() {
        Set testEngineListeners = this.dependencyContainer.getSetOfInstances(TestEngineListener.class);
        this.testEngines.forEach(testEngine -> testEngineListeners.stream().filter(listener -> listener.getSupportedEnginePredicate().test(testEngine.getUniqueId())).forEach(arg_0 -> ((TestEngine)testEngine).addListener(arg_0)));
    }

    protected void prepareRunners() throws NoRunnerAvailableException {
        Set testResultListeners = this.dependencyContainer.getSetOfInstances(TestResultListener.class);
        ArrayList<Runner> availableRunners = new ArrayList<Runner>(this.runnerConnector.getCurrentRunners());
        this.runnerConnector.addNewRunnerCallback(runner -> this.prepareTestRunner(testResultListeners, (Runner)runner));
        this.waitForRunnersIfNeeded(availableRunners);
        availableRunners.forEach(runner -> this.prepareTestRunner(testResultListeners, (Runner)runner));
    }

    protected void waitForRunnersIfNeeded(List<Runner> availableRunners) throws NoRunnerAvailableException {
        if (availableRunners.isEmpty()) {
            log.info("Waiting for runners");
            if (this.runnerConnector.isAcceptingNewRunners()) {
                this.waitForRunner();
            } else {
                log.error("No runners detected");
                throw new NoRunnerAvailableException();
            }
        }
    }

    protected void prepareTestRunner(Set<TestResultListener> testResultListeners, Runner runner) {
        testResultListeners.forEach(arg_0 -> ((Runner)runner).addTestResultListener(arg_0));
        this.executionStrategy.addTestRunner(runner);
    }

    protected void waitForRunner() throws NoRunnerAvailableException {
        Semaphore lock = new Semaphore(1);
        try {
            lock.acquire();
            this.runnerConnector.addNewRunnerCallback(runner -> lock.release());
            if (!lock.tryAcquire(this.settings.getWaitingForRunnersTimeoutMs(), TimeUnit.MILLISECONDS)) {
                log.error("Waiting for runners timeout");
                throw new NoRunnerAvailableException();
            }
        }
        catch (InterruptedException e) {
            log.error("Exception during waiting for runners", (Throwable)e);
            throw new NoRunnerAvailableException();
        }
    }
}

