/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paralyzer.core;

import com.atlassian.paralyzer.api.TestSuite;
import com.atlassian.paralyzer.api.TestSuiteProcessor;
import com.atlassian.paralyzer.api.TestSuiteProcessorChain;
import java.util.LinkedList;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class DefaultTestSuiteProcessorChain
implements TestSuiteProcessorChain {
    private LinkedList<TestSuiteProcessor> processors = new LinkedList();

    public Stream<TestSuite> process(Stream<TestSuite> stream, String testEngineId) {
        for (TestSuiteProcessor processor : this.processors) {
            if (!processor.getSupportedEnginePredicate().test(testEngineId)) continue;
            stream = processor.process(stream);
        }
        return stream;
    }

    public void addProcessorAt(TestSuiteProcessor processor, int index) {
        this.processors.add(index, processor);
    }

    public void addProcessorAfter(TestSuiteProcessor processor, Class<? extends TestSuiteProcessor> aClass) {
        OptionalInt index = IntStream.range(0, this.processors.size()).filter(i -> this.processors.get(i).getClass().equals(aClass)).findFirst();
        this.processors.add(index.orElse(0) + 1, processor);
    }

    public void addProcessorBefore(TestSuiteProcessor processor, Class<? extends TestSuiteProcessor> aClass) {
        OptionalInt index = IntStream.range(0, this.processors.size()).filter(i -> this.processors.get(i).getClass().equals(aClass)).findFirst();
        this.processors.add(index.orElse(0), processor);
    }

    public void addProcessorAtBegin(TestSuiteProcessor processor) {
        this.processors.addFirst(processor);
    }

    public void addProcessorAtEnd(TestSuiteProcessor processor) {
        this.processors.addLast(processor);
    }
}

