package com.atlassian.paralyzer.core;

import com.atlassian.paralyzer.api.TestSuite;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@AllArgsConstructor
@EqualsAndHashCode(of = {"uniqueId", "testEngineId"}, callSuper = false)
public class SimpleTestSuite extends DefaultExtendableType implements TestSuite {
    private final String uniqueId;
    private final String testEngineId;
    private final Object testEngineSuite;

    public SimpleTestSuite(String id, String testEngineId) {
        this.uniqueId = id;
        this.testEngineId = testEngineId;
        this.testEngineSuite = null;
    }

    @Override
    public String toString() {
        return getTestEngineId() + "/" + getUniqueId();
    }
}
