package com.atlassian.paralyzer.core;

import com.atlassian.paralyzer.api.TestResult;
import com.atlassian.paralyzer.api.TestSuite;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(of = {"uniqueId", "testEngineId"}, callSuper = false)
public class SimpleTestResult extends DefaultExtendableType implements TestResult {
    private final String uniqueId;
    private final String testEngineId;
    private final TestSuite testSuite;
    private Result result;
    private String logs;

    public SimpleTestResult(String id, String testEngineId) {
        this.uniqueId = id;
        this.testEngineId = testEngineId;
        this.testSuite = null;
    }

    public SimpleTestResult(String id, String testEngineId, Result result) {
        this.uniqueId = id;
        this.testEngineId = testEngineId;
        this.result = result;
        this.testSuite = null;
    }

    public SimpleTestResult(String uniqueId, String testEngineId, Result result, TestSuite testSuite) {
        this.uniqueId = uniqueId;
        this.testEngineId = testEngineId;
        this.testSuite = testSuite;
        this.result = result;
    }

    @Override
    public String toString() {
        return getTestEngineId() + "/" + getUniqueId();
    }
}
