package com.atlassian.paralyzer.core;

import com.atlassian.paralyzer.api.engine.LogInterceptor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.output.TeeOutputStream;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

@Slf4j
public class ConsoleLogInterceptor implements LogInterceptor {
    private ByteArrayOutputStream outputStream;
    private PrintStream printStream;
    private PrintStream outStream;
    private PrintStream errStream;

    @Override
    public void startIntercepting() {
        log.debug("Started intercepting console output");
        outputStream = new ByteArrayOutputStream();
        printStream = new PrintStream(new TeeOutputStream(outputStream, System.out));
        outStream = System.out;
        errStream = System.err;
        System.setOut(printStream);
        System.setErr(printStream);
    }

    @Override
    public String stopIntercepting() {
        System.setOut(outStream);
        System.setErr(errStream);
        log.debug("Stopped intercepting console output");
        return new String(outputStream.toByteArray());
    }
}
