/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paddle.task;

import com.atlassian.paddle.Group;
import com.atlassian.paddle.OutputReceiver;
import com.atlassian.paddle.search.DefaultSearcher;
import com.atlassian.paddle.search.GroupResultConverter;
import com.atlassian.paddle.search.GroupsSearch;
import com.atlassian.paddle.search.Search;
import com.atlassian.paddle.search.SearchException;
import com.atlassian.paddle.search.Searcher;
import com.atlassian.paddle.search.properties.GroupSearchProperties;
import com.atlassian.paddle.search.properties.MembershipSearchProperties;
import com.atlassian.paddle.task.Task;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.naming.directory.DirContext;

public class ListGroupsTask
implements Task {
    private final GroupSearchProperties groupSearchProperties;
    private final MembershipSearchProperties membershipSearchProperties;
    private final OutputReceiver outputReceiver;

    public ListGroupsTask(GroupSearchProperties groupSearchProperties, MembershipSearchProperties membershipSearchProperties, OutputReceiver outputReceiver) {
        this.groupSearchProperties = groupSearchProperties;
        this.membershipSearchProperties = membershipSearchProperties;
        this.outputReceiver = outputReceiver;
    }

    public void withConnection(DirContext context, Collection errors, long countLimit) {
        DefaultSearcher searcher = new DefaultSearcher(context, countLimit, this.outputReceiver);
        GroupsSearch search = new GroupsSearch(this.groupSearchProperties, this.membershipSearchProperties);
        Collection groups = this.doSearch(searcher, errors, search, countLimit);
        Iterator groupsIterator = groups.iterator();
        while (groupsIterator.hasNext()) {
            Group group = (Group)groupsIterator.next();
            this.outputReceiver.provideInfoFeedback(String.valueOf(group));
        }
    }

    private Collection doSearch(Searcher searcher, Collection errors, Search search, long memberCountLimit) {
        GroupResultConverter converter = new GroupResultConverter(this.membershipSearchProperties.getMembershipAttribute(), memberCountLimit);
        try {
            return searcher.search(search, converter);
        }
        catch (SearchException e) {
            this.outputReceiver.provideErrorFeedback(e.getMessage(), e);
            errors.add(e.getMessage());
            return Collections.EMPTY_LIST;
        }
    }
}

