/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paddle.configuration;

import com.atlassian.paddle.OutputReceiver;
import com.atlassian.paddle.configuration.Configuration;
import com.atlassian.paddle.configuration.ConfigurationReader;
import com.atlassian.paddle.connection.ConnectionProperties;
import com.atlassian.paddle.connection.DefaultConnectionProperties;
import com.atlassian.paddle.search.properties.DefaultGroupSearchProperties;
import com.atlassian.paddle.search.properties.DefaultMembershipSearchProperties;
import com.atlassian.paddle.search.properties.DefaultUserSearchProperties;
import com.atlassian.paddle.search.properties.GroupSearchProperties;
import com.atlassian.paddle.search.properties.MembershipSearchProperties;
import com.atlassian.paddle.search.properties.UserSearchProperties;

public class AtlassianUserConfigurationReader
implements ConfigurationReader {
    private final Configuration configuration;
    private final OutputReceiver logger;

    public AtlassianUserConfigurationReader(Configuration configuration, OutputReceiver logger) {
        this.configuration = configuration;
        this.logger = logger;
    }

    public ConnectionProperties getConnectionProperties() {
        DefaultConnectionProperties connectionProperties = new DefaultConnectionProperties(this.configuration.getAttributeInfoIfMissing("host", this.logger), this.configuration.getAttributeInfoIfMissing("port", this.logger), this.configuration.getAttributeInfoIfMissing("securityAuthentication", this.logger), this.configuration.getAttributeInfoIfMissing("securityProtocol", this.logger), this.configuration.getAttribute("securityPrincipal"), this.configuration.getAttribute("securityCredential"));
        if (connectionProperties.isAnonymousAuthentication()) {
            this.logger.provideInfoFeedback("\nDetected that you are logging into LDAP anonymously.\n");
        } else {
            if (connectionProperties.getUsername() == null) {
                this.logger.provideInfoFeedback("Username is missing from configuration, and anonymous authentication not configured");
            }
            if (connectionProperties.getPassword() == null) {
                this.logger.provideInfoFeedback("Password is missing from configuration, and anonymous authentication not configured");
            }
        }
        return connectionProperties;
    }

    public UserSearchProperties getUserSearchProperties() {
        return new DefaultUserSearchProperties(this.configuration.getAttributeInfoIfMissing("baseUserNamespace", this.logger), this.configuration.getAttributeInfoIfMissing("userSearchFilter", this.logger), "true".equalsIgnoreCase(this.configuration.getAttribute("userSearchAllDepths")), this.configuration.getAttributeInfoIfMissing("usernameAttribute", this.logger), this.configuration.getAttributeInfoIfMissing("firstnameAttribute", this.logger), this.configuration.getAttributeInfoIfMissing("surnameAttribute", this.logger), this.configuration.getAttributeInfoIfMissing("emailAttribute", this.logger));
    }

    public GroupSearchProperties getGroupSearchProperties() {
        return new DefaultGroupSearchProperties(this.configuration.getAttributeInfoIfMissing("baseGroupNamespace", this.logger), this.configuration.getAttributeInfoIfMissing("groupSearchFilter", this.logger), "true".equalsIgnoreCase(this.configuration.getAttribute("groupSearchAllDepths")), this.configuration.getAttributeInfoIfMissing("groupnameAttribute", this.logger));
    }

    public MembershipSearchProperties getMembershipSearchProperties() {
        return new DefaultMembershipSearchProperties(this.configuration.getAttributeInfoIfMissing("membershipAttribute", this.logger), true, true);
    }
}

