/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.paddle;

import com.atlassian.paddle.OutputReceiver;
import org.apache.commons.lang.exception.ExceptionUtils;

public class StringOutputReceiver
implements OutputReceiver {
    private StringBuffer buffer = new StringBuffer();
    private boolean debugOn = false;

    public void provideInfoFeedback(String info) {
        this.buffer.append(info).append("\n");
    }

    public void provideErrorFeedback(String error, Exception e) {
        this.buffer.append(error).append("\n");
        this.buffer.append(ExceptionUtils.getFullStackTrace((Throwable)e)).append("\n");
    }

    public void provideDebugFeedback(String debug) {
        if (this.debugOn) {
            this.buffer.append(debug).append("\n");
        }
    }

    public void setDebuggingFeedback(boolean on) {
        this.debugOn = on;
    }

    public String getOutput() {
        return this.buffer.toString();
    }
}

