/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.user.provider.ofbiz;

import com.opensymphony.user.Entity;
import com.opensymphony.user.provider.AccessProvider;
import com.opensymphony.user.provider.ofbiz.OFBizAbstractProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilMisc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OFBizAccessProvider
extends OFBizAbstractProvider
implements AccessProvider {
    private static final Logger LOG = Logger.getLogger(OFBizAccessProvider.class);
    protected List<String> groupsCache;
    protected final Map<String, List<String>> groupUsersCache = Collections.synchronizedMap(new HashMap());
    protected final Map<String, List<String>> userGroupsCache = Collections.synchronizedMap(new HashMap());
    protected Object groupsCacheLock = new Object();
    protected String groupEntity;
    protected String groupSequence;
    protected String membershipEntity;
    protected String membershipSequence;

    @Override
    public boolean addToGroup(String userName, String groupName) {
        try {
            if (!this.inGroup(userName, groupName)) {
                Long id = this.getDelegator().getNextSeqId(this.membershipSequence);
                GenericValue v = this.getDelegator().makeValue(this.membershipEntity, UtilMisc.toMap((String)"id", (Object)id, (String)"userName", (Object)userName, (String)"groupName", (Object)groupName));
                v.create();
                if (this.exclusiveAccess) {
                    this.userGroupsCache.remove(userName);
                    this.groupUsersCache.remove(groupName);
                }
            }
            return true;
        }
        catch (GenericEntityException e) {
            LOG.error((Object)"Could not add user to group", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(String name) {
        block5: {
            try {
                Long id = this.getDelegator().getNextSeqId(this.groupSequence);
                GenericValue v = this.getDelegator().makeValue(this.groupEntity, UtilMisc.toMap((String)"id", (Object)id, (String)"name", (Object)name));
                v.create();
                if (!this.exclusiveAccess) break block5;
                Object object = this.groupsCacheLock;
                synchronized (object) {
                    this.groupsCache.add(name);
                    Collections.sort(this.groupsCache);
                }
            }
            catch (GenericEntityException e) {
                LOG.error((Object)"Could not create group", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushCaches() {
        super.flushCaches();
        if (this.exclusiveAccess) {
            Object object = this.groupsCacheLock;
            synchronized (object) {
                this.groupsCache = null;
            }
            this.userGroupsCache.clear();
            this.groupUsersCache.clear();
        }
    }

    @Override
    public boolean handles(String name) {
        try {
            if (this.list().contains(name)) {
                return true;
            }
            if (this.findUser(name) != null) {
                return true;
            }
        }
        catch (GenericEntityException e) {
            LOG.error((Object)("GenericEntityException: " + (Object)((Object)e)), (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean inGroup(String userName, String groupName) {
        if (this.exclusiveAccess) {
            return this.listUsersInGroup(groupName).contains(userName);
        }
        try {
            GenericValue v = this.findByUsernameAndGroup(userName, groupName);
            if (v != null) {
                return true;
            }
        }
        catch (GenericEntityException e) {
            LOG.error((Object)"Could not verify that user is in group", (Throwable)e);
            return false;
        }
        return false;
    }

    @Override
    public boolean init(Properties properties) {
        boolean superResult = super.init(properties);
        this.groupEntity = properties.getProperty("groupEntity", "OSGroup");
        this.groupSequence = properties.getProperty("groupSequence", "OSGroup");
        this.membershipEntity = properties.getProperty("membershipEntity", "OSMembership");
        this.membershipSequence = properties.getProperty("membershipSequence", "OSMembership");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("groupEntity: " + this.groupEntity));
            LOG.debug((Object)("groupSequence: " + this.groupSequence));
            LOG.debug((Object)("membershipEntity: " + this.membershipEntity));
            LOG.debug((Object)("membershipSequence: " + this.membershipSequence));
        }
        this.userGroupsCache.clear();
        this.groupUsersCache.clear();
        return superResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> list() {
        try {
            if (this.exclusiveAccess) {
                Object object = this.groupsCacheLock;
                synchronized (object) {
                    if (this.groupsCache != null) {
                        return this.groupsCache;
                    }
                }
            }
            List col = this.getDelegator().findAll(this.groupEntity, UtilMisc.toList((Object)"name ASC"));
            ArrayList<String> list = new ArrayList<String>();
            for (GenericValue o : col) {
                list.add(o.getString("name"));
            }
            if (this.exclusiveAccess) {
                Object object = this.groupsCacheLock;
                synchronized (object) {
                    this.groupsCache = list;
                }
            }
            return list;
        }
        catch (GenericEntityException e) {
            LOG.error((Object)"Could not list groups", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<String> listGroupsContainingUser(String userName) {
        List<String> cachedValue;
        if (this.exclusiveAccess && (cachedValue = this.userGroupsCache.get(userName)) != null) {
            return cachedValue;
        }
        ArrayList<String> list = new ArrayList<String>();
        try {
            List c = this.getDelegator().findByAnd(this.membershipEntity, UtilMisc.toMap((String)"userName", (Object)userName));
            for (GenericValue value : c) {
                list.add(value.getString("groupName"));
            }
            if (this.exclusiveAccess) {
                this.userGroupsCache.put(userName, list);
            }
        }
        catch (GenericEntityException e) {
            LOG.error((Object)"Could not list groups containing user", (Throwable)e);
        }
        return list;
    }

    @Override
    public List<String> listUsersInGroup(String groupName) {
        List<String> cachedValue;
        if (this.exclusiveAccess && (cachedValue = this.groupUsersCache.get(groupName)) != null) {
            return cachedValue;
        }
        ArrayList<String> list = new ArrayList<String>();
        try {
            List c = this.getDelegator().findByAnd(this.membershipEntity, UtilMisc.toMap((String)"groupName", (Object)groupName));
            for (GenericValue value : c) {
                list.add(value.getString("userName"));
            }
            if (this.exclusiveAccess) {
                this.groupUsersCache.put(groupName, list);
            }
        }
        catch (GenericEntityException e) {
            LOG.error((Object)"Could not list users in group", (Throwable)e);
        }
        return list;
    }

    @Override
    public boolean load(String name, Entity.Accessor accessor) {
        accessor.setMutable(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String name) {
        try {
            this.getDelegator().removeByAnd(this.groupEntity, UtilMisc.toMap((String)"name", (Object)name));
            if (this.exclusiveAccess) {
                Object object = this.groupsCacheLock;
                synchronized (object) {
                    this.groupsCache.remove(name);
                }
            }
            return true;
        }
        catch (GenericEntityException e) {
            LOG.error((Object)"Could not remove group", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean removeFromGroup(String userName, String groupName) {
        try {
            this.getDelegator().removeByAnd(this.membershipEntity, UtilMisc.toMap((String)"userName", (Object)userName, (String)"groupName", (Object)groupName));
            if (this.exclusiveAccess) {
                this.userGroupsCache.remove(userName);
                this.groupUsersCache.remove(groupName);
            }
            return true;
        }
        catch (GenericEntityException e) {
            LOG.error((Object)"Could not remove group", (Throwable)e);
            return false;
        }
    }

    private GenericValue findByUsernameAndGroup(String userName, String groupName) throws GenericEntityException {
        List c = this.getDelegator().findByAnd(this.membershipEntity, UtilMisc.toMap((String)"userName", (Object)userName, (String)"groupName", (Object)groupName));
        if (c.size() > 0) {
            return (GenericValue)c.iterator().next();
        }
        return null;
    }
}

