/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.user.provider.ldap;

import com.opensymphony.user.Entity;
import com.opensymphony.user.UserManager;
import com.opensymphony.user.provider.CredentialsProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Logger;

public class LDAPCredentialsProvider
implements CredentialsProvider {
    private static final Logger log = Logger.getLogger(LDAPCredentialsProvider.class);
    private static Map cache = Collections.synchronizedMap(new HashMap());
    Hashtable env;
    String providerName;
    String searchBase;
    String uidSearchName;
    long timeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean authenticate(String name, String password) {
        if (password == null) return false;
        if ("".equals(password)) {
            return false;
        }
        TimeAndPassword tp = (TimeAndPassword)cache.get(name);
        if (tp != null && tp.password.equals(password) && tp.time > System.currentTimeMillis()) {
            if (!log.isDebugEnabled()) return true;
            log.debug((Object)("Successful authentication for " + name + " from cached " + this.providerName() + " lookup"));
            return true;
        }
        InitialDirContext adminCtx = null;
        Context userCtx = null;
        try {
            block26: {
                block25: {
                    NamingEnumeration<SearchResult> resultsMatchingUsername;
                    try {
                        adminCtx = new InitialDirContext(this.env);
                    }
                    catch (NamingException e) {
                        log.error((Object)("Could not connect to " + this.providerName() + ". Please check your " + "host ('" + this.env.get("java.naming.provider.url") + "'), " + "bind DN ('" + this.env.get("java.naming.security.principal") + "') and bind password."), (Throwable)e);
                        return this.tryNextCredentialsProviders(name, password);
                    }
                    String filter = new StringBuffer(this.uidSearchName).append("=").append(name).toString();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Doing initial search (connected as " + this.env.get("java.naming.security.principal") + "): base='" + this.searchBase + "', filter='" + filter + "'"));
                    }
                    SearchControls ctls = new SearchControls();
                    ctls.setReturningAttributes(new String[]{this.uidSearchName});
                    ctls.setSearchScope(2);
                    try {
                        resultsMatchingUsername = adminCtx.search(this.searchBase, filter, ctls);
                    }
                    catch (NamingException e) {
                        log.error((Object)("Connected to " + this.providerName() + ", but could not perform " + (this.env.containsKey("java.naming.security.principal") ? "authenticated" : "anonymous") + " search from base '" + this.searchBase + "'"), (Throwable)e);
                        return this.tryNextCredentialsProviders(name, password);
                    }
                    if (log.isDebugEnabled()) {
                        if (resultsMatchingUsername != null && resultsMatchingUsername.hasMore()) {
                            log.debug((Object)"Found user(s)");
                        } else {
                            log.debug((Object)"No users found");
                        }
                    }
                    while (resultsMatchingUsername != null) {
                        if (!resultsMatchingUsername.hasMore()) return this.tryNextCredentialsProviders(name, password);
                        SearchResult userSR = resultsMatchingUsername.next();
                        String userDN = userSR.isRelative() ? userSR.getName() + "," + this.searchBase : userSR.getName();
                        try {
                            Hashtable env2 = (Hashtable)this.env.clone();
                            env2.put("java.naming.security.principal", userDN);
                            env2.put("java.naming.security.credentials", password);
                            userCtx = new InitialDirContext(env2);
                            break block25;
                        }
                        catch (AuthenticationException ae) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("User with dn '" + userDN + "' found, but authentication failed."));
                            }
                            boolean bl = false;
                            if (adminCtx != null) {
                                adminCtx.close();
                            }
                            if (userCtx == null) return bl;
                            userCtx.close();
                            return bl;
                        }
                        catch (NamingException e) {
                            log.error((Object)("Initial connect and search successful, but second phase connection to " + this.providerName() + " as '" + userDN + "' failed."), (Throwable)e);
                        }
                    }
                    return this.tryNextCredentialsProviders(name, password);
                }
                if (!log.isDebugEnabled()) break block26;
                log.debug((Object)("User '" + name + "' successfully authenticated; caching for " + this.timeout + " ms"));
            }
            cache.put(name, new TimeAndPassword(System.currentTimeMillis() + this.timeout, password));
            return true;
            finally {
                if (adminCtx != null) {
                    adminCtx.close();
                }
                if (userCtx != null) {
                    userCtx.close();
                }
            }
        }
        catch (PartialResultException pre) {
            log.error((Object)("Connected but encountered error checking if " + this.providerName() + " had more results.  For Unprocessed Continuation References, try adding <property name=\"java.naming.referral\">follow</property> to the LDAPCredentialsProvider config."), (Throwable)pre);
            return this.tryNextCredentialsProviders(name, password);
        }
        catch (NamingException e) {
            log.error((Object)("Connected but encountered error checking if " + this.providerName() + " had more results."), (Throwable)e);
        }
        return this.tryNextCredentialsProviders(name, password);
    }

    public boolean changePassword(String name, String password) {
        Collection<CredentialsProvider> credentialsProviders = UserManager.getInstance().getCredentialsProviders();
        for (CredentialsProvider provider : credentialsProviders) {
            boolean isLDAP = provider instanceof LDAPCredentialsProvider;
            if (isLDAP || !provider.handles(name)) continue;
            return provider.changePassword(name, password);
        }
        return false;
    }

    public boolean create(String name) {
        return false;
    }

    public boolean equals(Object o) {
        if (o != null && o.getClass().equals(this.getClass())) {
            LDAPCredentialsProvider other = (LDAPCredentialsProvider)o;
            return this.env.equals(other.env);
        }
        return false;
    }

    public void flushCaches() {
        cache = Collections.synchronizedMap(new HashMap());
    }

    public boolean handles(String name) {
        TimeAndPassword tp = (TimeAndPassword)cache.get(name);
        if (tp != null && tp.time > System.currentTimeMillis()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cached lookup: Credentials for '" + name + "' could be handled by " + this.providerName()));
            }
            return true;
        }
        Collection<CredentialsProvider> credentialsProviders = UserManager.getInstance().getCredentialsProviders();
        boolean handles = false;
        for (CredentialsProvider provider : credentialsProviders) {
            boolean isLDAP = provider instanceof LDAPCredentialsProvider;
            if (isLDAP || !provider.handles(name)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("'" + name + "' could be handled by " + this.providerName()));
            }
            handles = true;
            break;
        }
        if (log.isDebugEnabled() && !handles) {
            log.debug((Object)("Credentials for '" + name + "' NOT handled by LDAP, because '" + name + "' not handled by any other credentials provider. Check you have at least one other" + " credentials provider, and that they contain this user."));
        }
        return handles;
    }

    public int hashCode() {
        return this.env.hashCode();
    }

    public boolean init(Properties properties) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Credentials Provider " + this.providerName() + " $Revision: 1.10 $ initializing"));
        }
        this.env = new Hashtable<Object, Object>(properties);
        this.env.put("java.naming.security.authentication", "simple");
        this.searchBase = properties.getProperty("searchBase");
        this.uidSearchName = properties.getProperty("uidSearchName");
        this.providerName = properties.getProperty("providerName");
        try {
            this.timeout = Long.parseLong(properties.getProperty("cacheTimeout"));
        }
        catch (NumberFormatException e) {
            this.timeout = 1800000L;
        }
        return true;
    }

    public List list() {
        return Collections.EMPTY_LIST;
    }

    public boolean load(String name, Entity.Accessor accessor) {
        Collection<CredentialsProvider> credentialsProviders = UserManager.getInstance().getCredentialsProviders();
        for (CredentialsProvider provider : credentialsProviders) {
            boolean isLDAP = provider instanceof LDAPCredentialsProvider;
            if (isLDAP || !provider.handles(name)) continue;
            return provider.load(name, accessor);
        }
        return true;
    }

    public boolean remove(String name) {
        Collection<CredentialsProvider> credentialsProviders = UserManager.getInstance().getCredentialsProviders();
        cache.remove(name);
        for (CredentialsProvider provider : credentialsProviders) {
            boolean isLDAP = provider instanceof LDAPCredentialsProvider;
            if (isLDAP || !provider.handles(name)) continue;
            return provider.remove(name);
        }
        return false;
    }

    public boolean store(String name, Entity.Accessor accessor) {
        Collection<CredentialsProvider> credentialsProviders = UserManager.getInstance().getCredentialsProviders();
        for (CredentialsProvider provider : credentialsProviders) {
            boolean isLDAP = provider instanceof LDAPCredentialsProvider;
            if (isLDAP || !provider.handles(name)) continue;
            return provider.store(name, accessor);
        }
        return true;
    }

    private final String providerName() {
        return this.providerName == null ? "LDAP" : "LDAP provider '" + this.providerName + "'";
    }

    private boolean tryNextCredentialsProviders(String name, String password) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Couldn't authenticate against " + this.providerName() + ", trying other CredentialsProviders"));
        }
        Collection<CredentialsProvider> credentialsProviders = UserManager.getInstance().getCredentialsProviders();
        boolean onUntriedProvider = false;
        for (CredentialsProvider nextProvider : credentialsProviders) {
            boolean result;
            if (!onUntriedProvider) {
                if (!this.equals(nextProvider)) continue;
                onUntriedProvider = true;
                continue;
            }
            String nextProviderName = null;
            if (log.isDebugEnabled()) {
                String string = nextProviderName = nextProvider instanceof LDAPCredentialsProvider ? ((LDAPCredentialsProvider)nextProvider).providerName() : nextProvider.getClass().getName();
            }
            if (!nextProvider.handles(name)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Next provider " + nextProviderName + "' could handle user; checking authentication..."));
            }
            if (result = nextProvider.authenticate(name, password)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User authenticated by '" + nextProviderName + "'"));
                }
                cache.put(name, new TimeAndPassword(System.currentTimeMillis() + this.timeout, password));
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Next provider '" + nextProviderName + "' failed to authenticate user."));
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"No non-LDAP authenticators could authenticate this user");
        }
        return false;
    }

    private class TimeAndPassword {
        public String password;
        public long time;

        public TimeAndPassword(long time, String password) {
            this.time = time;
            this.password = password;
        }
    }
}

