/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.MfDcState;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;
import com.benryan.graphics.wmf.records.RecordCreationException;
import java.awt.Dimension;

public class MfCmdSetWindowExt
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_HEIGHT = 0;
    private static final int POS_WIDTH = 1;
    private int height;
    private int width;
    private int scaled_width;
    private int scaled_height;

    @Override
    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        Dimension dim = this.getScaledDimension();
        state.setWindowExt(dim.width, dim.height);
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdSetWindowExt();
    }

    @Override
    public void setRecord(MfRecord record) {
        int height = record.getParam(0);
        int width = record.getParam(1);
        this.setDimension(width, height);
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(2);
        Dimension dim = this.getDimension();
        record.setParam(0, dim.height);
        record.setParam(1, dim.width);
        return record;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[SET_WINDOW_EXT] dimension=");
        b.append(this.getDimension());
        return b.toString();
    }

    public Dimension getDimension() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getScaledDimension() {
        return new Dimension(this.scaled_width, this.scaled_height);
    }

    public void setDimension(int w, int h) {
        this.width = w;
        this.height = h;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    @Override
    protected void scaleXChanged() {
        this.scaled_width = this.getScaledX(this.width);
    }

    @Override
    protected void scaleYChanged() {
        this.scaled_height = this.getScaledY(this.height);
    }

    @Override
    public int getFunction() {
        return 524;
    }
}

