/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.MfDcState;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;
import com.benryan.graphics.wmf.records.RecordCreationException;

public class MfCmdSetTextJustification
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_SPACELENGTH = 0;
    private static final int POS_BREAKCOUNT = 1;
    private int extraSpaceLength;
    private int breakCount;

    @Override
    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        state.setTextJustification(this.extraSpaceLength, this.breakCount);
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdSetTextJustification();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[SET_TEXT_JUSTIFICATION] breakCount=");
        b.append(this.getBreakCount());
        b.append(" extraSpaceLength=");
        b.append(this.getExtraSpaceLength());
        return b.toString();
    }

    @Override
    public void setRecord(MfRecord record) {
        int spaceLength = record.getParam(0);
        int breakCount = record.getParam(1);
        this.setExtraSpaceLength(spaceLength);
        this.setBreakCount(breakCount);
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(2);
        record.setParam(1, this.getBreakCount());
        record.setParam(0, this.getExtraSpaceLength());
        return record;
    }

    @Override
    public int getFunction() {
        return 522;
    }

    public int getBreakCount() {
        return this.breakCount;
    }

    public void setBreakCount(int count) {
        this.breakCount = count;
    }

    public int getExtraSpaceLength() {
        return this.extraSpaceLength;
    }

    public void setExtraSpaceLength(int count) {
        this.extraSpaceLength = count;
    }

    @Override
    protected void scaleXChanged() {
    }

    @Override
    protected void scaleYChanged() {
    }
}

