/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.MfLogPalette;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.WmfObject;
import com.benryan.graphics.wmf.records.MfCmd;
import com.benryan.graphics.wmf.records.RecordCreationException;

public class MfCmdSelectPalette
extends MfCmd {
    private static final int RECORD_SIZE = 1;
    private static final int POS_OBJECT_ID = 0;
    private int objectId;

    @Override
    public void replay(WmfFile file) {
        WmfObject object = file.getObject(this.objectId);
        if (object == null) {
            throw new NullPointerException();
        }
        switch (object.getType()) {
            case 3: {
                file.getCurrentState().setLogPalette((MfLogPalette)object);
                break;
            }
            default: {
                throw new IllegalStateException("Object is no palette");
            }
        }
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdSelectPalette();
    }

    @Override
    public void setRecord(MfRecord record) {
        int id = record.getParam(0);
        this.setObjectId(id);
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(1);
        record.setParam(0, this.getObjectId());
        return record;
    }

    @Override
    public int getFunction() {
        return 564;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public void setObjectId(int id) {
        this.objectId = id;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[SELECT_PALETTE] object=");
        b.append(this.getObjectId());
        return b.toString();
    }

    @Override
    protected void scaleXChanged() {
    }

    @Override
    protected void scaleYChanged() {
    }
}

