/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;
import com.benryan.graphics.wmf.records.RecordCreationException;

public class MfCmdScaleWindowExt
extends MfCmd {
    private static final int RECORD_SIZE = 4;
    private static final int POS_Y_DENOM = 0;
    private static final int POS_X_DENOM = 2;
    private static final int POS_Y_NUM = 1;
    private static final int POS_X_NUM = 3;
    private int yNum;
    private int yDenom;
    private int xNum;
    private int xDenom;

    @Override
    public void replay(WmfFile file) {
        file.getGraphics2D().scale((double)this.getXNum() / (double)this.getXDenom(), (double)this.getYNum() / (double)this.getYDenom());
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(4);
        record.setParam(2, this.getXDenom());
        record.setParam(3, this.getXNum());
        record.setParam(0, this.getYDenom());
        record.setParam(1, this.getYNum());
        return record;
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdScaleWindowExt();
    }

    @Override
    public int getFunction() {
        return 1024;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[SCALE_WINDOW] scaleX=");
        b.append(this.getXNum());
        b.append("/");
        b.append(this.getXDenom());
        b.append(" scaley=");
        b.append(this.getYNum());
        b.append("/");
        b.append(this.getYDenom());
        return b.toString();
    }

    @Override
    public void setRecord(MfRecord record) {
        int yD = record.getParam(0);
        int yN = record.getParam(1);
        int xD = record.getParam(2);
        int xN = record.getParam(3);
        this.setXScale(xN, xD);
        this.setYScale(yN, yD);
    }

    public void setXScale(int xNum, int xDenom) {
        this.xNum = xNum;
        this.xDenom = xDenom;
    }

    public void setYScale(int yNum, int yDenom) {
        this.yNum = yNum;
        this.yDenom = yDenom;
    }

    public double getXScale() {
        return (double)this.xNum / (double)this.xDenom;
    }

    public int getXNum() {
        return this.xNum;
    }

    public int getXDenom() {
        return this.xDenom;
    }

    public double getYScale() {
        return (double)this.yNum / (double)this.yDenom;
    }

    public int getYNum() {
        return this.yNum;
    }

    public int getYDenom() {
        return this.yDenom;
    }

    @Override
    protected void scaleXChanged() {
    }

    @Override
    protected void scaleYChanged() {
    }
}

