/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.records;

import com.benryan.graphics.wmf.MfLogFont;
import com.benryan.graphics.wmf.MfRecord;
import com.benryan.graphics.wmf.WmfFile;
import com.benryan.graphics.wmf.records.MfCmd;

public class MfCmdCreateFont
extends MfCmd {
    public static final int CHARSET_ANSI = 0;
    public static final int CHARSET_DEFAULT = 1;
    public static final int CHARSET_SYMBOL = 2;
    public static final int CHARSET_SHIFTJIS = 128;
    public static final int CHARSET_OEM = 255;
    private static int FONT_FACE_MAX = 31;
    private static int FIXED_RECORD_SIZE = 9;
    private static int POS_HEIGHT = 0;
    private static int POS_WIDTH = 1;
    private static int POS_ESCAPEMENT = 2;
    private static int POS_ORIENTATION = 3;
    private static int POS_WEIGHT = 4;
    private static int POS_FLAGS1 = 5;
    private static int POS_FLAGS2 = 6;
    private static int POS_PRECISION = 7;
    private static int POS_QUALITY = 8;
    private static int POS_FONTFACE = 9;
    private int height;
    private int width;
    private int scaled_height;
    private int scaled_width;
    private int escapement;
    private int orientation;
    private int weight;
    private boolean italic;
    private boolean underline;
    private boolean strikeout;
    private int charset;
    private int outprecision;
    private int clipprecision;
    private int quality;
    private int pitchAndFamily;
    private String facename;

    @Override
    public void replay(WmfFile file) {
        MfLogFont lfont = new MfLogFont();
        lfont.setFace(this.getFontFace());
        lfont.setSize(this.getScaledHeight());
        int style = 0;
        style = this.getWeight() > 650 ? 1 : 0;
        if (this.isItalic()) {
            style += 2;
        }
        lfont.setStyle(style);
        lfont.setUnderline(this.isUnderline());
        lfont.setStrikeOut(this.isStrikeout());
        lfont.setRotation(this.getEscapement() / 10);
        file.getCurrentState().setLogFont(lfont);
        file.storeObject(lfont);
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdCreateFont();
    }

    @Override
    public MfRecord getRecord() {
        String fontFace = this.getFontFace();
        if (fontFace.length() > FONT_FACE_MAX) {
            fontFace = fontFace.substring(0, FONT_FACE_MAX);
        }
        MfRecord record = new MfRecord(FIXED_RECORD_SIZE + fontFace.length());
        record.setParam(POS_HEIGHT, this.getHeight());
        record.setParam(POS_WIDTH, this.getWidth());
        record.setParam(POS_ESCAPEMENT, this.getEscapement());
        record.setParam(POS_ORIENTATION, this.getOrientation());
        record.setParam(POS_WEIGHT, this.getWeight());
        record.setParam(POS_FLAGS1, this.formFlags(this.isUnderline(), this.isItalic()));
        record.setParam(POS_FLAGS2, this.formFlags(this.isStrikeout(), false) + this.getCharset());
        record.setParam(POS_PRECISION, this.getOutputPrecision() << 8 + this.getClipPrecision());
        record.setParam(POS_QUALITY, this.getQuality() << 8 + this.getPitchAndFamily());
        record.setStringParam(POS_FONTFACE, fontFace);
        return record;
    }

    @Override
    public void setRecord(MfRecord record) {
        int height = record.getParam(POS_HEIGHT);
        if (height == 0) {
            height = 10;
        }
        if (height < 0) {
            height *= -1;
        }
        int width = record.getParam(POS_WIDTH);
        int escape = record.getParam(POS_ESCAPEMENT);
        int orientation = record.getParam(POS_ORIENTATION);
        int weight = record.getParam(POS_WEIGHT);
        int italic = record.getParam(POS_FLAGS1) & 0xFF;
        int underline = record.getParam(POS_FLAGS1) & 0xFF00;
        int strikeout = record.getParam(POS_FLAGS2) & 0xFF;
        int charset = record.getParam(POS_FLAGS2) & 0xFF00;
        int outprec = record.getParam(POS_PRECISION) & 0xFF;
        int clipprec = record.getParam(POS_PRECISION) & 0xFF00;
        int quality = record.getParam(POS_QUALITY) & 0xFF;
        int pitch = record.getParam(POS_QUALITY) & 0xFF00;
        String facename = record.getStringParam(POS_FONTFACE, 32);
        this.setCharset(charset);
        this.setClipPrecision(clipprec);
        this.setEscapement(escape);
        this.setFontFace(facename);
        this.setHeight(height);
        this.setItalic(italic != 0);
        this.setOrientation(orientation);
        this.setOutputPrecision(outprec);
        this.setPitchAndFamily(pitch);
        this.setQuality(quality);
        this.setStrikeout(strikeout != 0);
        this.setUnderline(underline != 0);
        this.setWeight(weight);
        this.setWidth(width);
    }

    private int formFlags(boolean f1, boolean f2) {
        int retval = 0;
        if (f1) {
            retval += 256;
        }
        if (f2) {
            ++retval;
        }
        return retval;
    }

    @Override
    public int getFunction() {
        return 763;
    }

    public void setFontFace(String facename) {
        this.facename = facename;
    }

    public String getFontFace() {
        return this.facename;
    }

    public void setPitchAndFamily(int pitchAndFamily) {
        this.pitchAndFamily = pitchAndFamily;
    }

    public int getPitchAndFamily() {
        return this.pitchAndFamily;
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public int getQuality() {
        return this.quality;
    }

    public void setClipPrecision(int clipprecision) {
        this.clipprecision = clipprecision;
    }

    public int getClipPrecision() {
        return this.clipprecision;
    }

    public void setOutputPrecision(int outprecision) {
        this.outprecision = outprecision;
    }

    public int getOutputPrecision() {
        return this.outprecision;
    }

    public void setCharset(int charset) {
        this.charset = charset;
    }

    public int getCharset() {
        return this.charset;
    }

    public void setHeight(int height) {
        this.height = height;
        this.scaleYChanged();
    }

    public int getHeight() {
        return this.height;
    }

    public int getScaledHeight() {
        return this.scaled_height;
    }

    public void setWidth(int width) {
        this.width = width;
        this.scaleXChanged();
    }

    @Override
    protected void scaleXChanged() {
        this.scaled_width = this.getScaledWidth(this.width);
    }

    @Override
    protected void scaleYChanged() {
        this.scaled_height = this.getScaledHeight(this.height);
    }

    public int getWidth() {
        return this.width;
    }

    public int getScaledWidth() {
        return this.scaled_width;
    }

    public void setEscapement(int escapement) {
        this.escapement = escapement;
    }

    public int getEscapement() {
        return this.escapement;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setUnderline(boolean ul) {
        this.underline = ul;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setStrikeout(boolean so) {
        this.strikeout = so;
    }

    public boolean isStrikeout() {
        return this.strikeout;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[CREATE_FONT] face=");
        b.append(this.getFontFace());
        b.append(" height=");
        b.append(this.getHeight());
        b.append(" width=");
        b.append(this.getWidth());
        b.append(" weight=");
        b.append(this.getWeight());
        b.append(" italic=");
        b.append(this.isItalic());
        b.append(" Strikeout=");
        b.append(this.isStrikeout());
        b.append(" Underline=");
        b.append(this.isUnderline());
        b.append(" outprecision=");
        b.append(this.getOutputPrecision());
        b.append(" escapement=");
        b.append(this.getEscapement());
        return b.toString();
    }
}

