/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf.bitmap;

import com.benryan.graphics.wmf.bitmap.GDIPalette;
import java.io.IOException;
import java.io.InputStream;

public abstract class BitmapCompression {
    private int height;
    private int width;
    private int bpp;
    private boolean topDown;

    public void setDimension(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getBpp() {
        return this.bpp;
    }

    public void setBpp(int bpp) {
        this.bpp = bpp;
    }

    public void setTopDown(boolean b) {
        this.topDown = b;
    }

    public boolean isTopDown() {
        return this.topDown;
    }

    public abstract int[] decompress(InputStream var1, GDIPalette var2) throws IOException;

    public static int[] expandMonocrome(int b, GDIPalette pal) {
        int tColor = pal.lookupColor(1);
        int fColor = pal.lookupColor(0);
        int[] retval = new int[]{(b & 1) == 1 ? tColor : fColor, (b & 2) == 2 ? tColor : fColor, (b & 4) == 4 ? tColor : fColor, (b & 8) == 8 ? tColor : fColor, (b & 0x10) == 16 ? tColor : fColor, (b & 0x20) == 32 ? tColor : fColor, (b & 0x40) == 64 ? tColor : fColor, (b & 0x80) == 128 ? tColor : fColor};
        return retval;
    }

    public static int[] expand4BitTuple(int b, GDIPalette pal) {
        int[] retval = new int[]{pal.lookupColor((b & 0xF0) >> 4), pal.lookupColor(b & 0xF)};
        return retval;
    }
}

