/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf;

import com.benryan.graphics.wmf.WmfFile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;

public class WmfImageProducer
implements ImageProducer {
    private WmfFile metafile;
    private ArrayList consumers = new ArrayList();

    public WmfImageProducer(String inName, int width, int height) throws IOException {
        this.metafile = new WmfFile(inName, width, height);
    }

    public WmfImageProducer(URL inName, int width, int height) throws IOException {
        this.metafile = new WmfFile(inName, width, height);
    }

    public WmfImageProducer(URL inName) throws IOException {
        this.metafile = new WmfFile(inName);
    }

    @Override
    public synchronized void addConsumer(ImageConsumer ic) {
        if (this.isConsumer(ic)) {
            return;
        }
        this.consumers.add(ic);
    }

    @Override
    public synchronized boolean isConsumer(ImageConsumer ic) {
        return this.consumers.contains(ic);
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer ic) {
        this.consumers.remove(ic);
    }

    @Override
    public synchronized void requestTopDownLeftRightResend(ImageConsumer ic) {
        this.startProduction(ic);
    }

    @Override
    public synchronized void startProduction(ImageConsumer pic) {
        int i;
        if (pic != null) {
            this.addConsumer(pic);
        }
        ImageConsumer[] cons = this.consumers.toArray(new ImageConsumer[this.consumers.size()]);
        BufferedImage image = this.metafile.replay(true);
        int w = image.getWidth();
        int h = image.getHeight();
        ColorModel model = image.getColorModel();
        for (int i2 = 0; i2 < cons.length; ++i2) {
            ImageConsumer ic = cons[i2];
            ic.setHints(2);
            ic.setHints(16);
            ic.setHints(8);
            ic.setHints(4);
            ic.setDimensions(w, h);
            ic.setColorModel(model);
        }
        int LINES = 10;
        int[] pixels = new int[w * 10];
        for (i = 0; i < h; i += 10) {
            int rows = 0;
            rows = i + 10 > h ? h - i : 10;
            pixels = image.getRGB(0, i, w, rows, pixels, 0, w);
            for (int j = 0; j < cons.length; ++j) {
                ImageConsumer ic = cons[j];
                ic.setPixels(0, i, w, rows, model, pixels, 0, w);
            }
        }
        for (i = 0; i < cons.length; ++i) {
            ImageConsumer ic = cons[i];
            ic.imageComplete(3);
        }
        if (pic != null) {
            this.removeConsumer(pic);
        }
    }
}

