/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf;

import com.benryan.graphics.wmf.GDIColor;
import com.benryan.graphics.wmf.WmfObject;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;

public class MfLogBrush
implements WmfObject {
    private static final boolean WHITE = false;
    private static final boolean BLACK = true;
    private static final boolean[] IMG_HS_HORIZONTAL = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final boolean[] IMG_HS_VERTICAL = new boolean[]{false, false, false, true, true, false, false, false, false, false, false, true, true, false, false, false, false, false, false, true, true, false, false, false, false, false, false, true, true, false, false, false, false, false, false, true, true, false, false, false, false, false, false, true, true, false, false, false, false, false, false, true, true, false, false, false, false, false, false, true, true, false, false, false};
    private static final boolean[] IMG_HS_FDIAGONAL = new boolean[]{true, true, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false, true};
    private static final boolean[] IMG_HS_BDIAGONAL = new boolean[]{true, false, false, false, false, false, false, true, false, false, false, false, false, false, true, true, false, false, false, false, false, true, true, false, false, false, false, false, true, true, false, false, false, false, false, true, true, false, false, false, false, false, true, true, false, false, false, false, false, true, true, false, false, false, false, false, true, true, false, false, false, false, false, false};
    private static final boolean[] IMG_HS_CROSS = new boolean[]{false, false, false, true, true, false, false, false, false, false, false, true, true, false, false, false, false, false, false, true, true, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, true, true, false, false, false, false, false, false, true, true, false, false, false, false, false, false, true, true, false, false, false};
    private static final boolean[] IMG_HS_DIAGCROSS = new boolean[]{true, true, false, false, false, false, true, true, false, true, true, false, false, true, true, false, false, false, true, true, true, true, false, false, false, false, false, true, true, false, false, false, false, false, true, true, true, true, false, false, false, true, true, false, false, true, true, false, true, true, false, false, false, false, true, true, true, false, false, false, false, false, false, true};
    public static final int COLOR_FULL_ALPHA = 0xFFFFFF;
    public static final int BS_SOLID = 0;
    public static final int BS_NULL = 1;
    public static final int BS_HATCHED = 2;
    public static final int BS_PATTERN = 3;
    public static final int BS_INDEXED = 4;
    public static final int BS_DIBPATTERN = 5;
    public static final int HS_HORIZONTAL = 0;
    public static final int HS_VERTICAL = 1;
    public static final int HS_FDIAGONAL = 2;
    public static final int HS_BDIAGONAL = 3;
    public static final int HS_CROSS = 4;
    public static final int HS_DIAGCROSS = 5;
    private int style = 0;
    private Color color = Color.white;
    private Color bgColor = new Color(0xFFFFFF);
    private int hatch = 0;
    private Paint lastPaint;
    private BufferedImage bitmap;

    public boolean isVisible() {
        return this.getStyle() != 1;
    }

    @Override
    public int getType() {
        return 2;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.lastPaint = null;
    }

    public int getHatchedStyle() {
        return this.hatch;
    }

    public void setHatchedStyle(int hstyle) {
        this.hatch = hstyle;
        this.lastPaint = null;
    }

    public Paint getPaint() {
        if (this.lastPaint != null) {
            return this.lastPaint;
        }
        switch (this.getStyle()) {
            case 0: {
                this.lastPaint = this.getColor();
                break;
            }
            case 1: {
                this.lastPaint = new GDIColor(0xFFFFFF);
                break;
            }
            case 2: {
                BufferedImage image = this.createHatchStyle();
                this.lastPaint = new TexturePaint(image, new Rectangle(0, 0, image.getWidth(), image.getHeight()));
                break;
            }
            case 5: {
                if (this.bitmap == null) {
                    this.lastPaint = new GDIColor(0xFFFFFF);
                    break;
                }
                this.lastPaint = new TexturePaint(this.bitmap, new Rectangle(0, 0, this.bitmap.getWidth(), this.bitmap.getHeight()));
                break;
            }
            default: {
                this.lastPaint = new GDIColor(0xFFFFFF);
            }
        }
        return this.lastPaint;
    }

    private BufferedImage createHatchStyle() {
        int style = this.getHatchedStyle();
        BufferedImage image = new BufferedImage(8, 8, 2);
        switch (style) {
            case 0: {
                image.setRGB(0, 0, 8, 8, this.transform(IMG_HS_HORIZONTAL), 0, 8);
                break;
            }
            case 1: {
                image.setRGB(0, 0, 8, 8, this.transform(IMG_HS_VERTICAL), 0, 8);
                break;
            }
            case 2: {
                image.setRGB(0, 0, 8, 8, this.transform(IMG_HS_FDIAGONAL), 0, 8);
                break;
            }
            case 3: {
                image.setRGB(0, 0, 8, 8, this.transform(IMG_HS_BDIAGONAL), 0, 8);
                break;
            }
            case 4: {
                image.setRGB(0, 0, 8, 8, this.transform(IMG_HS_CROSS), 0, 8);
                break;
            }
            case 5: {
                image.setRGB(0, 0, 8, 8, this.transform(IMG_HS_DIAGCROSS), 0, 8);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return image;
    }

    public int[] transform(boolean[] data) {
        int color = this.getColor().getRGB();
        int bgColor = this.getBackgroundColor().getRGB();
        int[] retval = new int[data.length];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = data[i] ? color : bgColor;
        }
        return retval;
    }

    public void setBackgroundColor(Color bg) {
        this.bgColor = bg;
        this.lastPaint = null;
    }

    public Color getBackgroundColor() {
        return this.bgColor;
    }

    public void setBitmap(BufferedImage bitmap) {
        this.bitmap = bitmap;
    }
}

