/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.graphics.wmf;

import com.benryan.graphics.wmf.Buffer;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;

public class MfHeader
extends Buffer {
    public static final int QUALITY_NO = 0;
    public static final int QUALITY_MAYBE = 1;
    public static final int QUALITY_YES = 2;
    private static final int PLACEABLE_HEADER_SIZE = 22;
    private static final int STANDARD_HEADER_SIZE = 18;
    private static final int WMF_FILE_TYPE = 22;
    private static final int WMF_HEADER_SIZE = 24;
    private static final int WMF_FILE_SIZE = 28;
    private static final int WMF_NUM_OF_REC = 32;
    private static final int WMF_MAX_REC_SIZE = 34;
    private static final int WMF_TYPE_MEM = 0;
    private static final int ALDUS_MAGIC_NUMBER_VAL = -1698247209;
    private static final int ALDUS_MAGIC_NUMBER_POS = 0;
    private static final int ALDUS_POS_LEFT = 6;
    private static final int ALDUS_POS_TOP = 8;
    private static final int ALDUS_POS_RIGHT = 10;
    private static final int ALDUS_POS_BOTTOM = 12;
    private static final int ALDUS_RESOLUTION = 14;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int isMetafile(String inName, InputStream in) {
        if (in != null) {
            MfHeader header = new MfHeader();
            try {
                in.mark(40);
                header.read(in);
            }
            catch (IOException e) {
                header = null;
            }
            finally {
                try {
                    in.reset();
                }
                catch (IOException iOException) {}
            }
            if (header == null || !header.isValid()) {
                return 0;
            }
            if (header.isPlaceable()) {
                return 2;
            }
        }
        if (inName.regionMatches(true, inName.length() - 4, ".wmf", 0, 4)) {
            return 1;
        }
        return 0;
    }

    public void read(InputStream in) throws IOException {
        int total = 40;
        this.setCapacity(40);
        this.read(in, 0, 4);
        if (this.isPlaceable()) {
            this.read(in, 4, 36);
        } else {
            this.move(0, 4, 22);
            this.read(in, 26, 14);
        }
    }

    private boolean isPlaceable() {
        return this.getInt(0) == -1698247209;
    }

    public boolean isValid() {
        int type = this.getShort(22);
        if (type == 0) {
            return false;
        }
        return this.getShort(24) == 9;
    }

    public Rectangle getBBox() {
        int left = this.getShort(6);
        int top = this.getShort(8);
        int right = this.getShort(10);
        int bottom = this.getShort(12);
        return new Rectangle(left, top, right - left, bottom - top);
    }

    public int getUnitsPerInch() {
        return this.getShort(14);
    }

    public int getFileSize() {
        return this.getInt(28) * 2;
    }

    public int getObjectsSize() {
        return this.getShort(32);
    }

    public int getMaxRecordSize() {
        return this.getInt(34) * 2;
    }

    public int getHeaderSize() {
        if (this.isPlaceable()) {
            return 40;
        }
        return 18;
    }
}

