/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc.sql.escape;

import java.util.Objects;
import java.util.Set;

public interface ReservedKeywordsAware {
    public static final Character ESCAPE_CHARACTER_DOUBLE_QUOTE = Character.valueOf('\"');
    public static final Character START_ESCAPE_CHARACTER_SQUARE_BRACKET = Character.valueOf('[');
    public static final Character END_ESCAPE_CHARACTER_SQUARE_BRACKET = Character.valueOf(']');
    public static final Character ESCAPE_CHARACTER_BACK_TICK = Character.valueOf('`');

    public Set<String> getReservedKeywords();

    default public Character getStartEscapeCharacter() {
        return ESCAPE_CHARACTER_DOUBLE_QUOTE;
    }

    default public Character getEndEscapeCharacter() {
        return ESCAPE_CHARACTER_DOUBLE_QUOTE;
    }

    default public boolean enableEscaping() {
        return false;
    }

    default public String escapeColumnName(String colName) {
        if (this.enableEscaping()) {
            Objects.requireNonNull(colName);
            StringBuilder stringBuilder = new StringBuilder();
            if (this.getReservedKeywords().contains(colName.trim().toUpperCase())) {
                return stringBuilder.append(this.getStartEscapeCharacter()).append(colName).append(this.getEndEscapeCharacter()).toString();
            }
            return colName;
        }
        return colName;
    }
}

