/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericTransactionException;
import org.ofbiz.core.entity.TransactionFactory;
import org.ofbiz.core.entity.TransactionUtil;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseTypeFactory;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.util.Debug;

public class SequenceUtil {
    public static final String module = SequenceUtil.class.getName();
    private final Map<String, SequenceBank> sequences = new Hashtable<String, SequenceBank>();
    private final String helperName;
    private final String tableName;
    private final String nameColName;
    private final String idColName;
    private final boolean clustering;
    private volatile DatabaseType databaseType;

    public SequenceUtil(String helperName, ModelEntity seqEntity, String nameFieldName, String idFieldName, boolean clustering) {
        this.helperName = helperName;
        if (seqEntity == null) {
            throw new IllegalArgumentException("The sequence model entity was null but is required.");
        }
        this.tableName = seqEntity.getTableName(helperName);
        ModelField nameField = seqEntity.getField(nameFieldName);
        if (nameField == null) {
            throw new IllegalArgumentException("Could not find the field definition for the sequence name field " + nameFieldName);
        }
        this.nameColName = nameField.getColName();
        ModelField idField = seqEntity.getField(idFieldName);
        if (idField == null) {
            throw new IllegalArgumentException("Could not find the field definition for the sequence id field " + idFieldName);
        }
        this.idColName = idField.getColName();
        this.clustering = clustering;
    }

    public Long getNextSeqId(String seqName) {
        SequenceBank bank = this.sequences.get(seqName);
        if (bank == null) {
            bank = this.constructSequenceBank(seqName);
        }
        return bank.getNextSeqId();
    }

    private synchronized SequenceBank constructSequenceBank(String seqName) {
        return this.sequences.computeIfAbsent(seqName, key -> new SequenceBank((String)key, this, this.clustering));
    }

    private Optional<DatabaseType> getDatabaseTypeSingleton(Connection connection) {
        if (this.databaseType == null) {
            this.databaseType = DatabaseTypeFactory.getTypeForConnection(connection);
        }
        return Optional.ofNullable(this.databaseType);
    }

    private void closeQuietly(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception sqle) {
            Debug.logWarning((Throwable)sqle, (String)"Error closing connection in sequence util");
        }
    }

    private void closeQuietly(PreparedStatement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception sqle) {
            Debug.logWarning((Throwable)sqle, (String)"Error closing statement in sequence util");
        }
    }

    private void closeQuietly(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception sqle) {
            Debug.logWarning((Throwable)sqle, (String)"Error closing result set in sequence util");
        }
    }

    class SequenceBank {
        public static final long bankSize = 100L;
        public static final long startSeqId = 10000L;
        public static final int minWaitNanos = 500000;
        public static final int maxWaitNanos = 1000000;
        public static final int maxTries = 5;
        private volatile long curSeqId;
        private volatile long maxSeqId;
        private final String seqName;
        private final SequenceUtil parentUtil;
        private final boolean clusterMode;

        public SequenceBank(String seqName, SequenceUtil parentUtil, boolean clusterMode) {
            this.seqName = seqName;
            this.parentUtil = parentUtil;
            this.clusterMode = clusterMode;
            this.curSeqId = 0L;
            this.maxSeqId = 0L;
            this.fillBank();
        }

        public synchronized Long getNextSeqId() {
            if (this.curSeqId < this.maxSeqId) {
                Long retSeqId = this.curSeqId;
                ++this.curSeqId;
                return retSeqId;
            }
            this.fillBank();
            if (this.curSeqId < this.maxSeqId) {
                Long retSeqId = this.curSeqId;
                ++this.curSeqId;
                return retSeqId;
            }
            Debug.logError((String)"[SequenceUtil.SequenceBank.getNextSeqId] Fill bank failed, returning null", (String)module);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected synchronized void fillBank() {
            block44: {
                if (this.curSeqId < this.maxSeqId) {
                    return;
                }
                val1 = 0L;
                val2 = 0L;
                manualTX = true;
                suspendedTransaction = null;
                transactionManager = null;
                try {
                    if (TransactionUtil.getStatus() != 0) break block44;
                    manualTX = false;
                    try {
                        transactionManager = TransactionFactory.getTransactionManager();
                        if (transactionManager != null) {
                            suspendedTransaction = transactionManager.suspend();
                            manualTX = true;
                        }
                    }
                    catch (SystemException e) {
                        Debug.logError((Throwable)e, (String)"System Error suspending transaction in sequence util");
                    }
                }
                catch (GenericTransactionException e) {
                    Debug.logWarning((String)("[SequenceUtil.SequenceBank.fillBank] Exception was thrown trying to check transaction status: " + e.toString()), (String)SequenceUtil.module);
                }
            }
            connection = null;
            try {
                connection = ConnectionFactory.getConnection(this.parentUtil.helperName);
            }
            catch (SQLException | GenericEntityException sqle) {
                Debug.logWarning((String)"[SequenceUtil.SequenceBank.fillBank]: Unable to establish a connection with the database... Error was:", (String)SequenceUtil.module);
                Debug.logWarning((String)sqle.getMessage(), (String)SequenceUtil.module);
            }
            selectPstmt = null;
            insertPstmt = null;
            updatePstmt = null;
            try {
                connection.setAutoCommit(false);
            }
            catch (SQLException sqle) {
                manualTX = false;
            }
            numTries = 0;
            while (val1 + 100L != val2) {
                block45: {
                    rs1 = null;
                    rs2 = null;
                    try {
                        if (Debug.verboseOn()) {
                            Debug.logVerbose((String)("[SequenceUtil.SequenceBank.fillBank] Trying to get a bank of sequenced ids for " + this.seqName + "; start of loop val1=" + val1 + ", val2=" + val2 + ", bankSize=100"), (String)SequenceUtil.module);
                        }
                        if (selectPstmt == null) {
                            selectSyntax = this.parentUtil.getDatabaseTypeSingleton(connection).map((Function<DatabaseType, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$fillBank$0(org.ofbiz.core.entity.jdbc.dbtype.DatabaseType ), (Lorg/ofbiz/core/entity/jdbc/dbtype/DatabaseType;)Ljava/lang/String;)((SequenceBank)this)).orElseGet((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$fillBank$1(), ()Ljava/lang/String;)());
                            selectPstmt = connection.prepareStatement(MessageFormat.format(selectSyntax, new Object[]{this.parentUtil.idColName, this.parentUtil.tableName, this.parentUtil.nameColName + "=?"}));
                        }
                        selectPstmt.setString(1, this.seqName);
                        selectPstmt.execute();
                        rs1 = selectPstmt.getResultSet();
                        if (!rs1.next()) {
                            Debug.logVerbose((String)("[SequenceUtil.SequenceBank.fillBank] first select failed: trying to add row, result set was empty for sequence: " + this.seqName), (String)SequenceUtil.module);
                            if (insertPstmt == null) {
                                insertPstmt = connection.prepareStatement("INSERT INTO " + this.parentUtil.tableName + " (" + this.parentUtil.nameColName + ", " + this.parentUtil.idColName + ") VALUES (?,?)");
                            }
                            insertPstmt.setString(1, this.seqName);
                            insertPstmt.setLong(2, 10000L);
                            insertPstmt.execute();
                            if (insertPstmt.getUpdateCount() <= 0) {
                                SequenceUtil.this.closeQuietly(rs2);
                                SequenceUtil.this.closeQuietly(rs1);
                                SequenceUtil.this.closeQuietly(updatePstmt);
                                SequenceUtil.this.closeQuietly(insertPstmt);
                                SequenceUtil.this.closeQuietly(selectPstmt);
                                SequenceUtil.this.closeQuietly(connection);
                                return;
                            }
                            SequenceUtil.this.closeQuietly(rs2);
                            SequenceUtil.this.closeQuietly(rs1);
                            continue;
                        }
                        val1 = rs1.getLong(this.parentUtil.idColName);
                        if (updatePstmt == null) {
                            updatePstmt = connection.prepareStatement("UPDATE " + this.parentUtil.tableName + " SET " + this.parentUtil.idColName + "=" + this.parentUtil.idColName + "+100 WHERE " + this.parentUtil.nameColName + "=?");
                        }
                        updatePstmt.setString(1, this.seqName);
                        updatePstmt.execute();
                        if (updatePstmt.getUpdateCount() <= 0) {
                            Debug.logWarning((String)("[SequenceUtil.SequenceBank.fillBank] update failed, no rows changes for seqName: " + this.seqName), (String)SequenceUtil.module);
                            SequenceUtil.this.closeQuietly(rs2);
                            SequenceUtil.this.closeQuietly(rs1);
                            SequenceUtil.this.closeQuietly(updatePstmt);
                            SequenceUtil.this.closeQuietly(insertPstmt);
                            SequenceUtil.this.closeQuietly(selectPstmt);
                            SequenceUtil.this.closeQuietly(connection);
                            return;
                        }
                        if (manualTX) {
                            connection.commit();
                        }
                        selectPstmt.setString(1, this.seqName);
                        selectPstmt.execute();
                        rs2 = selectPstmt.getResultSet();
                        if (!rs2.next()) {
                            Debug.logWarning((String)("[SequenceUtil.SequenceBank.fillBank] second select failed: aborting, result set was empty for sequence: " + this.seqName), (String)SequenceUtil.module);
                            SequenceUtil.this.closeQuietly(rs2);
                            SequenceUtil.this.closeQuietly(rs1);
                            SequenceUtil.this.closeQuietly(updatePstmt);
                            SequenceUtil.this.closeQuietly(insertPstmt);
                            SequenceUtil.this.closeQuietly(selectPstmt);
                            SequenceUtil.this.closeQuietly(connection);
                            return;
                        }
                        val2 = rs2.getLong(this.parentUtil.idColName);
                    }
                    catch (Throwable var17_24) {
                        SequenceUtil.this.closeQuietly(rs2);
                        SequenceUtil.this.closeQuietly(rs1);
                        throw var17_24;
                    }
                    if (manualTX) {
                        connection.commit();
                    }
                    if (val1 + 100L == val2) ** GOTO lbl129
                    if (numTries < 5) break block45;
                    Debug.logError((String)"[SequenceUtil.SequenceBank.fillBank] maxTries (5) reached, giving up.", (String)SequenceUtil.module);
                    SequenceUtil.this.closeQuietly(rs2);
                    SequenceUtil.this.closeQuietly(rs1);
                    SequenceUtil.this.closeQuietly(updatePstmt);
                    SequenceUtil.this.closeQuietly(insertPstmt);
                    SequenceUtil.this.closeQuietly(selectPstmt);
                    SequenceUtil.this.closeQuietly(connection);
                    return;
                }
                waitTime = new Double(Math.random() * 500000.0).intValue() + 500000;
                try {
                    this.wait(0L, waitTime);
                }
                catch (Exception e) {
                    Debug.logWarning((Throwable)e, (String)"Error waiting in sequence util");
                }
lbl129:
                // 3 sources

                ++numTries;
                SequenceUtil.this.closeQuietly(rs2);
                SequenceUtil.this.closeQuietly(rs1);
            }
            this.curSeqId = val1;
            this.maxSeqId = val2;
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("[SequenceUtil.SequenceBank.fillBank] Successfully got a bank of sequenced ids for " + this.seqName + "; curSeqId=" + this.curSeqId + ", maxSeqId=" + this.maxSeqId + ", bankSize=100"), (String)SequenceUtil.module);
            }
            SequenceUtil.this.closeQuietly(updatePstmt);
            SequenceUtil.this.closeQuietly(insertPstmt);
            SequenceUtil.this.closeQuietly(selectPstmt);
            SequenceUtil.this.closeQuietly(connection);
            if (suspendedTransaction == null) return;
            ** try [egrp 16[TRYBLOCK] [24, 25, 26 : 1155->1182)] { 
lbl143:
            // 1 sources

            ** GOTO lbl-1000
            catch (SQLException sqle) {
                Debug.logWarning((Throwable)sqle, (String)"[SequenceUtil.SequenceBank.fillBank] SQL Exception", (String)SequenceUtil.module);
                return;
            }
            finally {
                SequenceUtil.this.closeQuietly(updatePstmt);
                SequenceUtil.this.closeQuietly(insertPstmt);
                SequenceUtil.this.closeQuietly(selectPstmt);
                SequenceUtil.this.closeQuietly(connection);
            }
lbl-1000:
            // 1 sources

            {
                if (transactionManager == null) {
                    transactionManager = TransactionFactory.getTransactionManager();
                }
                if (transactionManager == null) return;
                transactionManager.resume(suspendedTransaction);
                return;
            }
lbl161:
            // 1 sources

            catch (InvalidTransactionException e) {
                Debug.logError((Throwable)e, (String)"InvalidTransaction Error resuming suspended transaction in sequence util");
                return;
            }
lbl164:
            // 1 sources

            catch (IllegalStateException e) {
                Debug.logError((Throwable)e, (String)"IllegalState Error resuming suspended transaction in sequence util");
                return;
            }
lbl167:
            // 1 sources

            catch (SystemException e) {
                Debug.logError((Throwable)e, (String)"System Error resuming suspended transaction in sequence util");
            }
        }

        private static /* synthetic */ String lambda$fillBank$1() {
            return "SELECT {0} FROM {1} WHERE {2}";
        }

        private /* synthetic */ String lambda$fillBank$0(DatabaseType databaseType) {
            return databaseType.getSimpleSelectSqlSyntax(this.clusterMode);
        }
    }
}

