/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc.dbtype;

import java.sql.Connection;
import java.sql.SQLException;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;
import org.ofbiz.core.entity.jdbc.dbtype.AbstractDatabaseType;

public class Oracle10GDatabaseType
extends AbstractDatabaseType {
    public Oracle10GDatabaseType() {
        super("Oracle 9i and 10g", "oracle10g", new String[]{"ORACLE"});
    }

    @Override
    public boolean matchesConnection(Connection con) throws SQLException {
        return this.productNameMatches(con) && this.versionGreaterThanOrEqual(con, 9, 0);
    }

    @Override
    protected String getChangeColumnTypeStructure() {
        return "ALTER TABLE {0} MODIFY {1} {2}";
    }

    public static boolean detectUnicodeWidening(String typeName, DatabaseUtil.ColumnCheckInfo ccInfo, String oracleSpecificExtension) {
        return "VARCHAR2".equals(typeName.toUpperCase()) && "CHAR".equals(oracleSpecificExtension) && !Oracle10GDatabaseType.detectUnicodeExtension(ccInfo);
    }

    public static boolean detectUnicodeExtension(DatabaseUtil.ColumnCheckInfo ccInfo) {
        return "VARCHAR2".equals(ccInfo.typeName.trim().toUpperCase()) && 4 * ccInfo.columnSize == ccInfo.maxSizeInBytes;
    }

    @Override
    public String getDropIndexStructure() {
        return "DROP INDEX {schemaName_with_dot}{indexName}";
    }

    @Override
    public String getSimpleSelectSqlSyntax(boolean clusterMode) {
        if (clusterMode) {
            return "SELECT {0} FROM {1} WHERE {2} FOR UPDATE";
        }
        return "SELECT {0} FROM {1} WHERE {2}";
    }
}

