/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.ParserConfigurationException;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.DistributedCacheClear;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityListIterator;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericEntityNotFoundException;
import org.ofbiz.core.entity.GenericHelper;
import org.ofbiz.core.entity.GenericHelperFactory;
import org.ofbiz.core.entity.GenericModelException;
import org.ofbiz.core.entity.GenericPK;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.SequenceUtil;
import org.ofbiz.core.entity.TransactionUtil;
import org.ofbiz.core.entity.Transformation;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelFieldType;
import org.ofbiz.core.entity.model.ModelFieldTypeReader;
import org.ofbiz.core.entity.model.ModelGroupReader;
import org.ofbiz.core.entity.model.ModelKeyMap;
import org.ofbiz.core.entity.model.ModelReader;
import org.ofbiz.core.entity.model.ModelRelation;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilCache;
import org.ofbiz.core.util.UtilMisc;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class GenericDelegator
implements DelegatorInterface {
    public static final String module = GenericDelegator.class.getName();
    private static final String MESSAGE = "Database is locked";
    private static final LoadingCache<String, GenericDelegator> delegatorCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, GenericDelegator>(){

        public GenericDelegator load(String delegatorName) throws GenericEntityException {
            return new GenericDelegator(delegatorName);
        }
    });
    private static AtomicBoolean isLocked = new AtomicBoolean(false);
    protected EntityConfigUtil.DelegatorInfo delegatorInfo;
    protected DistributedCacheClear distributedCacheClear;
    protected ModelGroupReader modelGroupReader;
    protected ModelReader modelReader;
    protected SequenceUtil sequencer;
    protected String delegatorName;
    protected UtilCache<GenericEntity, GenericValue> primaryKeyCache;
    protected UtilCache<GenericPK, List<GenericValue>> andCache;
    protected UtilCache<String, List<GenericValue>> allCache;
    protected Map<String, Set<Set<String>>> andCacheFieldSets = new HashMap<String, Set<Set<String>>>();

    public static GenericDelegator getGenericDelegator(String delegatorName) {
        return (GenericDelegator)delegatorCache.getUnchecked((Object)delegatorName);
    }

    public static synchronized void removeGenericDelegator(String delegatorName) {
        delegatorCache.invalidate((Object)delegatorName);
    }

    public static void lock() {
        isLocked.set(true);
    }

    public static void unlock() {
        isLocked.set(false);
    }

    public static boolean isLocked() {
        return isLocked.get();
    }

    protected GenericDelegator() {
    }

    protected GenericDelegator(String delegatorName) throws GenericEntityException {
        if (Debug.infoOn()) {
            Debug.logInfo((String)("Creating new Delegator with name \"" + delegatorName + "\"."), (String)module);
        }
        this.delegatorName = delegatorName;
        this.modelReader = ModelReader.getModelReader(delegatorName);
        this.modelGroupReader = ModelGroupReader.getModelGroupReader(delegatorName);
        this.primaryKeyCache = new UtilCache("entity.xFindByPrimaryKey." + delegatorName, 0L, 0L, true);
        this.allCache = new UtilCache("entity.FindAll." + delegatorName, 0L, 0L, true);
        this.andCache = new UtilCache("entity.FindByAnd." + delegatorName, 0L, 0L, true);
        if (!GenericDelegator.isLocked()) {
            this.initialiseAndCheckDatabase();
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (this.getDelegatorInfo().useDistributedCacheClear) {
            String distributedCacheClearClassName = this.getDelegatorInfo().distributedCacheClearClassName;
            try {
                Class<?> dccClass = loader.loadClass(distributedCacheClearClassName);
                this.distributedCacheClear = (DistributedCacheClear)dccClass.newInstance();
                this.distributedCacheClear.setDelegator(this, this.getDelegatorInfo().distributedCacheClearUserLoginId);
            }
            catch (ClassNotFoundException e) {
                Debug.logWarning((Throwable)e, (String)("DistributedCacheClear class with name " + distributedCacheClearClassName + " was not found, distributed cache clearing will be disabled"));
            }
            catch (InstantiationException e) {
                Debug.logWarning((Throwable)e, (String)("DistributedCacheClear class with name " + distributedCacheClearClassName + " could not be instantiated, distributed cache clearing will be disabled"));
            }
            catch (IllegalAccessException e) {
                Debug.logWarning((Throwable)e, (String)("DistributedCacheClear class with name " + distributedCacheClearClassName + " could not be accessed (illegal), distributed cache clearing will be disabled"));
            }
            catch (ClassCastException e) {
                Debug.logWarning((Throwable)e, (String)("DistributedCacheClear class with name " + distributedCacheClearClassName + " does not implement the DistributedCacheClear interface, distributed cache clearing will be disabled"));
            }
        }
    }

    public void initialiseAndCheckDatabase() {
        GenericDelegator.checkIfLocked();
        Iterator groups = UtilMisc.toIterator(this.getModelGroupReader().getGroupNames());
        while (groups != null && groups.hasNext()) {
            String groupName = (String)groups.next();
            String helperName = this.getGroupHelperName(groupName);
            if (Debug.infoOn()) {
                Debug.logInfo((String)("Delegator \"" + this.delegatorName + "\" initializing helper \"" + helperName + "\" for entity group \"" + groupName + "\"."), (String)module);
            }
            TreeSet<String> helpersDone = new TreeSet<String>();
            if (helperName == null || helperName.length() <= 0) continue;
            if (helpersDone.contains(helperName)) {
                if (!Debug.infoOn()) continue;
                Debug.logInfo((String)("Helper \"" + helperName + "\" already initialized, not re-initializing."), (String)module);
                continue;
            }
            helpersDone.add(helperName);
            ModelFieldTypeReader.getModelFieldTypeReader(helperName);
            GenericHelper helper = GenericHelperFactory.getHelper(helperName);
            DatasourceInfo datasourceInfo = EntityConfigUtil.getInstance().getDatasourceInfo(helperName);
            if (!datasourceInfo.isCheckOnStart()) continue;
            if (Debug.infoOn()) {
                Debug.logInfo((String)("Doing database check as requested in entityengine.xml with addMissing=" + datasourceInfo.isAddMissingOnStart()), (String)module);
            }
            try {
                helper.checkDataSource(this.getModelEntityMapByGroup(groupName), null, datasourceInfo.isAddMissingOnStart());
            }
            catch (GenericEntityException e) {
                Debug.logWarning((String)e.getMessage(), (String)module);
            }
        }
    }

    @Override
    public String getDelegatorName() {
        GenericDelegator.checkIfLocked();
        return this.delegatorName;
    }

    protected EntityConfigUtil.DelegatorInfo getDelegatorInfo() {
        if (this.delegatorInfo == null) {
            this.delegatorInfo = EntityConfigUtil.getInstance().getDelegatorInfo(this.delegatorName);
        }
        return this.delegatorInfo;
    }

    @Override
    public ModelReader getModelReader() {
        GenericDelegator.checkIfLocked();
        return this.modelReader;
    }

    @Override
    public ModelGroupReader getModelGroupReader() {
        GenericDelegator.checkIfLocked();
        return this.modelGroupReader;
    }

    @Override
    public ModelEntity getModelEntity(String entityName) {
        GenericDelegator.checkIfLocked();
        try {
            return this.getModelReader().getModelEntity(entityName);
        }
        catch (GenericEntityException e) {
            Debug.logError((Throwable)((Object)e), (String)"Error getting entity definition from model", (String)module);
            return null;
        }
    }

    @Override
    public String getEntityGroupName(String entityName) {
        GenericDelegator.checkIfLocked();
        return this.getModelGroupReader().getEntityGroupName(entityName);
    }

    @Override
    public List<ModelEntity> getModelEntitiesByGroup(String groupName) {
        GenericDelegator.checkIfLocked();
        Iterator enames = UtilMisc.toIterator(this.getModelGroupReader().getEntityNamesByGroup(groupName));
        LinkedList<ModelEntity> entities = new LinkedList<ModelEntity>();
        if (enames == null || !enames.hasNext()) {
            return entities;
        }
        while (enames.hasNext()) {
            String ename = (String)enames.next();
            ModelEntity entity = this.getModelEntity(ename);
            if (entity == null) continue;
            entities.add(entity);
        }
        return entities;
    }

    @Override
    public Map<String, ModelEntity> getModelEntityMapByGroup(String groupName) {
        GenericDelegator.checkIfLocked();
        Iterator enames = UtilMisc.toIterator(this.getModelGroupReader().getEntityNamesByGroup(groupName));
        HashMap<String, ModelEntity> entities = new HashMap<String, ModelEntity>();
        if (enames == null || !enames.hasNext()) {
            return entities;
        }
        int errorCount = 0;
        while (enames.hasNext()) {
            String ename = (String)enames.next();
            try {
                ModelEntity entity = this.getModelReader().getModelEntity(ename);
                if (entity != null) {
                    entities.put(entity.getEntityName(), entity);
                    continue;
                }
                throw new IllegalStateException("Program Error: entity was null with name " + ename);
            }
            catch (GenericEntityException ex) {
                ++errorCount;
                Debug.logError((String)("Entity " + ename + " named in Entity Group with name " + groupName + " are not defined in any Entity Definition file"));
            }
        }
        if (errorCount > 0) {
            Debug.logError((String)(errorCount + " entities were named in ModelGroup but not defined in any EntityModel"));
        }
        return entities;
    }

    @Override
    public String getGroupHelperName(String groupName) {
        GenericDelegator.checkIfLocked();
        return this.getDelegatorInfo().groupMap.get(groupName);
    }

    @Override
    public String getEntityHelperName(String entityName) {
        GenericDelegator.checkIfLocked();
        String groupName = this.getModelGroupReader().getEntityGroupName(entityName);
        return this.getGroupHelperName(groupName);
    }

    @Override
    public String getEntityHelperName(ModelEntity entity) {
        GenericDelegator.checkIfLocked();
        if (entity == null) {
            return null;
        }
        return this.getEntityHelperName(entity.getEntityName());
    }

    @Override
    public GenericHelper getEntityHelper(String entityName) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        String helperName = this.getEntityHelperName(entityName);
        if (helperName != null && helperName.length() > 0) {
            return GenericHelperFactory.getHelper(helperName);
        }
        throw new GenericEntityException("Helper name not found for entity " + entityName);
    }

    @Override
    public GenericHelper getEntityHelper(ModelEntity entity) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.getEntityHelper(entity.getEntityName());
    }

    @Override
    public ModelFieldType getEntityFieldType(ModelEntity entity, String type) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        String helperName = this.getEntityHelperName(entity);
        if (helperName == null || helperName.length() == 0) {
            return null;
        }
        ModelFieldTypeReader modelFieldTypeReader = ModelFieldTypeReader.getModelFieldTypeReader(helperName);
        if (modelFieldTypeReader == null) {
            throw new GenericEntityException("ModelFieldTypeReader not found for entity " + entity.getEntityName() + " with helper name " + helperName);
        }
        return modelFieldTypeReader.getModelFieldType(type);
    }

    @Override
    public Collection<String> getEntityFieldTypeNames(ModelEntity entity) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        String helperName = this.getEntityHelperName(entity);
        if (helperName == null || helperName.length() == 0) {
            return null;
        }
        ModelFieldTypeReader modelFieldTypeReader = ModelFieldTypeReader.getModelFieldTypeReader(helperName);
        if (modelFieldTypeReader == null) {
            throw new GenericEntityException("ModelFieldTypeReader not found for entity " + entity.getEntityName() + " with helper name " + helperName);
        }
        return modelFieldTypeReader.getFieldTypeNames();
    }

    @Override
    public GenericValue makeValue(String entityName, Map<String, ?> fields) {
        GenericDelegator.checkIfLocked();
        ModelEntity entity = this.getModelEntity(entityName);
        if (entity == null) {
            throw new IllegalArgumentException("[GenericDelegator.makeValue] could not find entity for entityName: " + entityName);
        }
        return new GenericValue(this, entity, fields);
    }

    @Override
    public GenericPK makePK(String entityName, Map<String, ?> fields) {
        GenericDelegator.checkIfLocked();
        ModelEntity entity = this.getModelEntity(entityName);
        if (entity == null) {
            throw new IllegalArgumentException("[GenericDelegator.makePK] could not find entity for entityName: " + entityName);
        }
        GenericPK pk = new GenericPK(entity, fields);
        pk.setDelegator(this);
        return pk;
    }

    @Override
    public GenericValue create(String entityName, Map<String, ?> fields) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        if (entityName == null || fields == null) {
            return null;
        }
        ModelEntity entity = this.getModelReader().getModelEntity(entityName);
        GenericValue genericValue = new GenericValue(this, entity, fields);
        return this.create(genericValue, true);
    }

    @Override
    public GenericValue create(GenericValue value) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.create(value, true);
    }

    @Override
    public GenericValue create(GenericValue value, boolean doCacheClear) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        GenericHelper helper = this.getEntityHelper(value.getEntityName());
        value.setDelegator(this);
        value = helper.create(value);
        if (value != null) {
            value.setDelegator(this);
            if (value.lockEnabled()) {
                this.refresh(value, doCacheClear);
            } else if (doCacheClear) {
                this.clearCacheLine(value);
            }
        }
        return value;
    }

    @Override
    public GenericValue create(GenericPK primaryKey) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.create(primaryKey, true);
    }

    @Override
    public GenericValue create(GenericPK primaryKey, boolean doCacheClear) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        if (primaryKey == null) {
            throw new IllegalArgumentException("Cannot create from a null primaryKey");
        }
        return this.create(new GenericValue(primaryKey), doCacheClear);
    }

    @Override
    public GenericValue findByPrimaryKey(GenericPK primaryKey) throws GenericEntityException {
        GenericValue value;
        GenericDelegator.checkIfLocked();
        GenericHelper helper = this.getEntityHelper(primaryKey.getEntityName());
        if (!primaryKey.isPrimaryKey()) {
            throw new IllegalArgumentException("[GenericDelegator.findByPrimaryKey] Passed primary key is not a valid primary key: " + primaryKey);
        }
        try {
            value = helper.findByPrimaryKey(primaryKey);
        }
        catch (GenericEntityNotFoundException e) {
            value = null;
        }
        if (value != null) {
            value.setDelegator(this);
        }
        return value;
    }

    @Override
    public GenericValue findByPrimaryKeyCache(GenericPK primaryKey) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        GenericValue value = this.getFromPrimaryKeyCache(primaryKey);
        if (value == null && (value = this.findByPrimaryKey(primaryKey)) != null) {
            this.putInPrimaryKeyCache(primaryKey, value);
        }
        return value;
    }

    @Override
    public GenericValue findByPrimaryKey(String entityName, Map<String, ?> fields) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.findByPrimaryKey(this.makePK(entityName, fields));
    }

    @Override
    public GenericValue findByPrimaryKeyCache(String entityName, Map<String, ?> fields) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.findByPrimaryKeyCache(this.makePK(entityName, fields));
    }

    @Override
    public GenericValue findByPrimaryKeyPartial(GenericPK primaryKey, Set<String> keys) throws GenericEntityException {
        GenericValue value;
        GenericDelegator.checkIfLocked();
        GenericHelper helper = this.getEntityHelper(primaryKey.getEntityName());
        if (!primaryKey.isPrimaryKey()) {
            throw new IllegalArgumentException("[GenericDelegator.findByPrimaryKey] Passed primary key is not a valid primary key: " + primaryKey);
        }
        try {
            value = helper.findByPrimaryKeyPartial(primaryKey, keys);
        }
        catch (GenericEntityNotFoundException e) {
            value = null;
        }
        if (value != null) {
            value.setDelegator(this);
        }
        return value;
    }

    @Override
    public List<GenericValue> findAllByPrimaryKeys(Collection<? extends GenericPK> primaryKeys) throws GenericEntityException {
        String helperName;
        GenericDelegator.checkIfLocked();
        if (primaryKeys == null) {
            return null;
        }
        LinkedList<GenericValue> results = new LinkedList<GenericValue>();
        HashMap<String, LinkedList<GenericPK>> pksPerHelper = new HashMap<String, LinkedList<GenericPK>>();
        for (GenericPK genericPK : primaryKeys) {
            helperName = this.getEntityHelperName(genericPK.getEntityName());
            LinkedList<GenericPK> pks = (LinkedList<GenericPK>)pksPerHelper.get(helperName);
            if (pks == null) {
                pks = new LinkedList<GenericPK>();
                pksPerHelper.put(helperName, pks);
            }
            pks.add(genericPK);
        }
        for (Map.Entry entry : pksPerHelper.entrySet()) {
            helperName = (String)entry.getKey();
            GenericHelper helper = GenericHelperFactory.getHelper(helperName);
            List<GenericValue> values = helper.findAllByPrimaryKeys((List)entry.getValue());
            results.addAll(values);
        }
        return results;
    }

    @Override
    public List<GenericValue> findAllByPrimaryKeysCache(Collection<? extends GenericPK> primaryKeys) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        if (primaryKeys == null) {
            return null;
        }
        LinkedList<GenericValue> results = new LinkedList<GenericValue>();
        HashMap<String, LinkedList<GenericPK>> pksPerHelper = new HashMap<String, LinkedList<GenericPK>>();
        for (GenericPK genericPK : primaryKeys) {
            GenericValue value = this.getFromPrimaryKeyCache(genericPK);
            if (value != null) {
                results.add(value);
                continue;
            }
            String helperName = this.getEntityHelperName(genericPK.getEntityName());
            LinkedList<GenericPK> pks = (LinkedList<GenericPK>)pksPerHelper.get(helperName);
            if (pks == null) {
                pks = new LinkedList<GenericPK>();
                pksPerHelper.put(helperName, pks);
            }
            pks.add(genericPK);
        }
        for (Map.Entry entry : pksPerHelper.entrySet()) {
            String helperName = (String)entry.getKey();
            GenericHelper helper = GenericHelperFactory.getHelper(helperName);
            List<GenericValue> values = helper.findAllByPrimaryKeys((List)entry.getValue());
            this.putAllInPrimaryKeyCache(values);
            results.addAll(values);
        }
        return results;
    }

    @Override
    public List<GenericValue> findAll(String entityName) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.findByAnd(entityName, new HashMap(), null);
    }

    @Override
    public List<GenericValue> findAll(String entityName, List<String> orderBy) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.findByAnd(entityName, new HashMap(), orderBy);
    }

    @Override
    public List<GenericValue> findAllCache(String entityName) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.findAllCache(entityName, null);
    }

    @Override
    public List<GenericValue> findAllCache(String entityName, List<String> orderBy) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        List<GenericValue> lst = this.getFromAllCache(entityName);
        if (lst == null && (lst = this.findAll(entityName, orderBy)) != null) {
            this.putInAllCache(entityName, lst);
        }
        return lst;
    }

    @Override
    public List<GenericValue> findByAnd(String entityName, Map<String, ?> fields) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.findByAnd(entityName, fields, null);
    }

    @Override
    public List<GenericValue> findByOr(String entityName, Map<String, ?> fields) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.findByOr(entityName, fields, null);
    }

    @Override
    public List<GenericValue> findByAnd(String entityName, Map<String, ?> fields, List<String> orderBy) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        ModelEntity modelEntity = this.getModelReader().getModelEntity(entityName);
        return this.findByAnd(modelEntity, fields, orderBy);
    }

    @Override
    public List<GenericValue> findByAnd(ModelEntity modelEntity, Map<String, ?> fields, List<String> orderBy) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        GenericHelper helper = this.getEntityHelper(modelEntity);
        if (fields != null && !modelEntity.areFields(fields.keySet())) {
            throw new GenericModelException("At least one of the passed fields is not valid: " + fields.keySet());
        }
        List<GenericValue> list = helper.findByAnd(modelEntity, fields, orderBy);
        this.absorbList(list);
        return list;
    }

    @Override
    public List<GenericValue> findByOr(String entityName, Map<String, ?> fields, List<String> orderBy) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        ModelEntity modelEntity = this.getModelReader().getModelEntity(entityName);
        GenericHelper helper = this.getEntityHelper(entityName);
        if (fields != null && !modelEntity.areFields(fields.keySet())) {
            throw new IllegalArgumentException("[GenericDelegator.findByOr] At least of the passed fields is not valid: " + fields.keySet());
        }
        List<GenericValue> list = helper.findByOr(modelEntity, fields, orderBy);
        this.absorbList(list);
        return list;
    }

    @Override
    public List<GenericValue> findByAndCache(String entityName, Map<String, ?> fields) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.findByAndCache(entityName, fields, null);
    }

    @Override
    public List<GenericValue> findByAndCache(String entityName, Map<String, ?> fields, List<String> orderBy) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        ModelEntity modelEntity = this.getModelReader().getModelEntity(entityName);
        List<GenericValue> lst = this.getFromAndCache(modelEntity, fields);
        if (lst == null && (lst = this.findByAnd(modelEntity, fields, orderBy)) != null) {
            this.putInAndCache(modelEntity, fields, lst);
        }
        return lst;
    }

    @Override
    public List<GenericValue> findByAnd(String entityName, List<? extends EntityCondition> expressions) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        EntityConditionList ecl = new EntityConditionList(expressions, EntityOperator.AND);
        return this.findByCondition(entityName, ecl, null, null);
    }

    @Override
    public List<GenericValue> findByAnd(String entityName, List<? extends EntityCondition> expressions, List<String> orderBy) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        EntityConditionList ecl = new EntityConditionList(expressions, EntityOperator.AND);
        return this.findByCondition(entityName, ecl, null, orderBy);
    }

    @Override
    public List<GenericValue> findByOr(String entityName, List<? extends EntityCondition> expressions) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        EntityConditionList ecl = new EntityConditionList(expressions, EntityOperator.OR);
        return this.findByCondition(entityName, ecl, null, null);
    }

    @Override
    public List<GenericValue> findByOr(String entityName, List<? extends EntityCondition> expressions, List<String> orderBy) throws GenericEntityException {
        EntityConditionList ecl = new EntityConditionList(expressions, EntityOperator.OR);
        return this.findByCondition(entityName, ecl, null, orderBy);
    }

    @Override
    public List<GenericValue> findByLike(String entityName, Map<String, ?> fields) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.findByLike(entityName, fields, null);
    }

    @Override
    public List<GenericValue> findByLike(String entityName, Map<String, ?> fields, List<String> orderBy) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        LinkedList<EntityExpr> likeExpressions = new LinkedList<EntityExpr>();
        if (fields != null) {
            for (Map.Entry<String, ?> entry : fields.entrySet()) {
                likeExpressions.add(new EntityExpr(entry.getKey(), EntityOperator.LIKE, entry.getValue()));
            }
        }
        EntityConditionList ecl = new EntityConditionList(likeExpressions, EntityOperator.AND);
        return this.findByCondition(entityName, ecl, null, orderBy);
    }

    @Override
    public List<GenericValue> findByCondition(String entityName, EntityCondition entityCondition, Collection<String> fieldsToSelect, List<String> orderBy) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        ModelEntity modelEntity = this.getModelReader().getModelEntity(entityName);
        if (entityCondition != null) {
            entityCondition.checkCondition(modelEntity);
        }
        GenericHelper helper = this.getEntityHelper(entityName);
        List<GenericValue> list = helper.findByCondition(modelEntity, entityCondition, fieldsToSelect, orderBy);
        this.absorbList(list);
        return list;
    }

    @Override
    public int countByAnd(String entityName, String fieldName, List<? extends EntityCondition> expressions, EntityFindOptions findOptions) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        EntityConditionList ecl = expressions == null ? null : new EntityConditionList(expressions, EntityOperator.AND);
        return this.countByCondition(entityName, fieldName, ecl, findOptions);
    }

    @Override
    public int countByOr(String entityName, String fieldName, List<? extends EntityCondition> expressions, EntityFindOptions findOptions) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        EntityConditionList ecl = expressions == null ? null : new EntityConditionList(expressions, EntityOperator.OR);
        return this.countByCondition(entityName, fieldName, ecl, findOptions);
    }

    @Override
    public int countByCondition(String entityName, String fieldName, EntityCondition entityCondition, EntityFindOptions findOptions) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        ModelEntity modelEntity = this.getModelReader().getModelEntity(entityName);
        if (entityCondition != null) {
            entityCondition.checkCondition(modelEntity);
        }
        GenericHelper helper = this.getEntityHelper(entityName);
        return helper.count(modelEntity, fieldName, entityCondition, findOptions);
    }

    @Override
    public int countAll(String entityName) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.countByCondition(entityName, null, null, null);
    }

    @Override
    public EntityListIterator findListIteratorByCondition(String entityName, EntityCondition entityCondition, Collection<String> fieldsToSelect, List<String> orderBy) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.findListIteratorByCondition(entityName, entityCondition, null, fieldsToSelect, orderBy, null);
    }

    @Override
    public EntityListIterator findListIteratorByCondition(String entityName, EntityCondition whereEntityCondition, EntityCondition havingEntityCondition, Collection<String> fieldsToSelect, List<String> orderBy, EntityFindOptions findOptions) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        ModelEntity modelEntity = this.getModelReader().getModelEntity(entityName);
        if (whereEntityCondition != null) {
            whereEntityCondition.checkCondition(modelEntity);
        }
        if (havingEntityCondition != null) {
            havingEntityCondition.checkCondition(modelEntity);
        }
        GenericHelper helper = this.getEntityHelper(entityName);
        EntityListIterator eli = helper.findListIteratorByCondition(modelEntity, whereEntityCondition, havingEntityCondition, fieldsToSelect, orderBy, findOptions);
        eli.setDelegator(this);
        return eli;
    }

    @Override
    public int removeByPrimaryKey(GenericPK primaryKey) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.removeByPrimaryKey(primaryKey, true);
    }

    @Override
    public int removeByPrimaryKey(GenericPK primaryKey, boolean doCacheClear) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        if (doCacheClear) {
            this.clearCacheLine(primaryKey);
        }
        GenericHelper helper = this.getEntityHelper(primaryKey.getEntityName());
        return helper.removeByPrimaryKey(primaryKey);
    }

    @Override
    public int removeValue(GenericValue value) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.removeValue(value, true);
    }

    @Override
    public int removeValue(GenericValue value, boolean doCacheClear) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        GenericHelper helper = this.getEntityHelper(value.getEntityName());
        if (doCacheClear) {
            this.clearCacheLine(value);
        }
        return helper.removeByPrimaryKey(value.getPrimaryKey());
    }

    @Override
    public int removeByAnd(String entityName, Map<String, ?> fields) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.removeByAnd(entityName, fields, true);
    }

    @Override
    public int removeByAnd(String entityName, Map<String, ?> fields, boolean doCacheClear) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        GenericValue dummyValue = this.makeValue(entityName, fields);
        ModelEntity modelEntity = this.getModelReader().getModelEntity(entityName);
        GenericHelper helper = this.getEntityHelper(entityName);
        if (doCacheClear) {
            this.clearCacheLine(entityName, fields);
        }
        return helper.removeByAnd(modelEntity, dummyValue.getAllFields());
    }

    @Override
    public int removeByCondition(String entityName, EntityCondition whereCondition) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.removeByCondition(entityName, whereCondition, true);
    }

    @Override
    public int removeByCondition(String entityName, EntityCondition whereCondition, boolean doCacheClear) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        ModelEntity modelEntity = this.getModelReader().getModelEntity(entityName);
        GenericHelper helper = this.getEntityHelper(entityName);
        if (doCacheClear) {
            List<GenericValue> toBeDeleted = helper.findByCondition(modelEntity, whereCondition, null, null);
            this.clearAllCacheLinesByValue(toBeDeleted);
        }
        return helper.removeByCondition(modelEntity, whereCondition);
    }

    @Override
    public List<GenericValue> getMultiRelation(GenericValue value, String relationNameOne, String relationNameTwo, List<String> orderBy) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        ModelEntity modelEntity = value.getModelEntity();
        ModelRelation modelRelationOne = modelEntity.getRelation(relationNameOne);
        ModelEntity modelEntityOne = this.getModelEntity(modelRelationOne.getRelEntityName());
        ModelRelation modelRelationTwo = modelEntityOne.getRelation(relationNameTwo);
        ModelEntity modelEntityTwo = this.getModelEntity(modelRelationTwo.getRelEntityName());
        GenericHelper helper = this.getEntityHelper(modelEntity);
        return helper.findByMultiRelation(value, modelRelationOne, modelEntityOne, modelRelationTwo, modelEntityTwo, orderBy);
    }

    @Override
    public List<GenericValue> getMultiRelation(GenericValue value, String relationNameOne, String relationNameTwo) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.getMultiRelation(value, relationNameOne, relationNameTwo, null);
    }

    @Override
    public List<GenericValue> getRelated(String relationName, GenericValue value) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.getRelated(relationName, null, null, value);
    }

    @Override
    public List<GenericValue> getRelatedByAnd(String relationName, Map<String, ?> byAndFields, GenericValue value) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.getRelated(relationName, byAndFields, null, value);
    }

    @Override
    public List<GenericValue> getRelatedOrderBy(String relationName, List<String> orderBy, GenericValue value) throws GenericEntityException {
        return this.getRelated(relationName, null, orderBy, value);
    }

    @Override
    public List<GenericValue> getRelated(String relationName, Map<String, ?> byAndFields, List<String> orderBy, GenericValue value) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        ModelEntity modelEntity = value.getModelEntity();
        ModelRelation relation = modelEntity.getRelation(relationName);
        if (relation == null) {
            throw new GenericModelException("Could not find relation for relationName: " + relationName + " for value " + value);
        }
        HashMap<String, Object> fields = byAndFields == null ? new HashMap<String, Object>() : new HashMap(byAndFields);
        for (int i = 0; i < relation.getKeyMapsSize(); ++i) {
            ModelKeyMap keyMap = relation.getKeyMap(i);
            fields.put(keyMap.getRelFieldName(), value.get(keyMap.getFieldName()));
        }
        return this.findByAnd(relation.getRelEntityName(), fields, orderBy);
    }

    @Override
    public GenericPK getRelatedDummyPK(String relationName, Map<String, ?> byAndFields, GenericValue value) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        ModelEntity modelEntity = value.getModelEntity();
        ModelRelation relation = modelEntity.getRelation(relationName);
        if (relation == null) {
            throw new GenericModelException("Could not find relation for relationName: " + relationName + " for value " + value);
        }
        ModelEntity relatedEntity = this.getModelReader().getModelEntity(relation.getRelEntityName());
        HashMap<String, Object> fields = byAndFields == null ? new HashMap<String, Object>() : new HashMap(byAndFields);
        for (int i = 0; i < relation.getKeyMapsSize(); ++i) {
            ModelKeyMap keyMap = relation.getKeyMap(i);
            fields.put(keyMap.getRelFieldName(), value.get(keyMap.getFieldName()));
        }
        GenericPK dummyPK = new GenericPK(relatedEntity, fields);
        dummyPK.setDelegator(this);
        return dummyPK;
    }

    @Override
    public List<GenericValue> getRelatedCache(String relationName, GenericValue value) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        ModelEntity modelEntity = value.getModelEntity();
        ModelRelation relation = modelEntity.getRelation(relationName);
        if (relation == null) {
            throw new GenericModelException("Could not find relation for relationName: " + relationName + " for value " + value);
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (int i = 0; i < relation.getKeyMapsSize(); ++i) {
            ModelKeyMap keyMap = relation.getKeyMap(i);
            fields.put(keyMap.getRelFieldName(), value.get(keyMap.getFieldName()));
        }
        return this.findByAndCache(relation.getRelEntityName(), fields, null);
    }

    @Override
    public GenericValue getRelatedOne(String relationName, GenericValue value) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        ModelRelation relation = value.getModelEntity().getRelation(relationName);
        if (relation == null) {
            throw new GenericModelException("Could not find relation for relationName: " + relationName + " for value " + value);
        }
        if (!"one".equals(relation.getType()) && !"one-nofk".equals(relation.getType())) {
            throw new IllegalArgumentException("Relation is not a 'one' or a 'one-nofk' relation: " + relationName + " of entity " + value.getEntityName());
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (int i = 0; i < relation.getKeyMapsSize(); ++i) {
            ModelKeyMap keyMap = relation.getKeyMap(i);
            fields.put(keyMap.getRelFieldName(), value.get(keyMap.getFieldName()));
        }
        return this.findByPrimaryKey(relation.getRelEntityName(), fields);
    }

    @Override
    public GenericValue getRelatedOneCache(String relationName, GenericValue value) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        ModelEntity modelEntity = value.getModelEntity();
        ModelRelation relation = modelEntity.getRelation(relationName);
        if (relation == null) {
            throw new GenericModelException("Could not find relation for relationName: " + relationName + " for value " + value);
        }
        if (!"one".equals(relation.getType()) && !"one-nofk".equals(relation.getType())) {
            throw new IllegalArgumentException("Relation is not a 'one' or a 'one-nofk' relation: " + relationName + " of entity " + value.getEntityName());
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (int i = 0; i < relation.getKeyMapsSize(); ++i) {
            ModelKeyMap keyMap = relation.getKeyMap(i);
            fields.put(keyMap.getRelFieldName(), value.get(keyMap.getFieldName()));
        }
        return this.findByPrimaryKeyCache(relation.getRelEntityName(), fields);
    }

    @Override
    public int removeRelated(String relationName, GenericValue value) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.removeRelated(relationName, value, true);
    }

    @Override
    public int removeRelated(String relationName, GenericValue value, boolean doCacheClear) throws GenericEntityException {
        ModelEntity modelEntity = value.getModelEntity();
        ModelRelation relation = modelEntity.getRelation(relationName);
        if (relation == null) {
            throw new GenericModelException("Could not find relation for relationName: " + relationName + " for value " + value);
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (int i = 0; i < relation.getKeyMapsSize(); ++i) {
            ModelKeyMap keyMap = relation.getKeyMap(i);
            fields.put(keyMap.getRelFieldName(), value.get(keyMap.getFieldName()));
        }
        return this.removeByAnd(relation.getRelEntityName(), fields, doCacheClear);
    }

    @Override
    public void refresh(GenericValue value) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        this.refresh(value, true);
    }

    @Override
    public void refresh(GenericValue value, boolean doCacheClear) throws GenericEntityException {
        GenericPK pk;
        GenericValue newValue;
        GenericDelegator.checkIfLocked();
        if (doCacheClear) {
            this.clearCacheLine(value);
        }
        if ((newValue = this.findByPrimaryKey(pk = value.getPrimaryKey())) == null) {
            throw new IllegalArgumentException("[GenericDelegator.refresh] could not refresh value: " + value);
        }
        value.fields = newValue.fields;
        value.setDelegator(this);
        value.modified = false;
    }

    @Override
    public int store(GenericValue value) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.store(value, true);
    }

    @Override
    public int store(GenericValue value, boolean doCacheClear) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        GenericHelper helper = this.getEntityHelper(value.getEntityName());
        if (doCacheClear) {
            this.clearCacheLine(value);
        }
        int retVal = helper.store(value);
        if (value.lockEnabled()) {
            this.refresh(value, doCacheClear);
        }
        return retVal;
    }

    @Override
    public int storeAll(List<? extends GenericValue> values) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.storeAll(values, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int storeAll(List<? extends GenericValue> values, boolean doCacheClear) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        if (values == null) {
            return 0;
        }
        HashMap valuesPerHelper = new HashMap();
        for (GenericValue genericValue : values) {
            void var7_10;
            String helperName = this.getEntityHelperName(genericValue.getEntityName());
            List list = (List)valuesPerHelper.get(helperName);
            if (list == null) {
                LinkedList linkedList = new LinkedList();
                valuesPerHelper.put(helperName, linkedList);
            }
            var7_10.add(genericValue);
        }
        boolean bl = false;
        int numberChanged = 0;
        try {
            boolean bl2;
            if (valuesPerHelper.size() > 1) {
                bl2 = TransactionUtil.begin();
            }
            for (Map.Entry stringListEntry : valuesPerHelper.entrySet()) {
                String helperName = (String)stringListEntry.getKey();
                GenericHelper helper = GenericHelperFactory.getHelper(helperName);
                if (doCacheClear) {
                    this.clearAllCacheLinesByValue((Collection)stringListEntry.getValue());
                }
                numberChanged += helper.storeAll((List)stringListEntry.getValue());
            }
            TransactionUtil.commit(bl2);
        }
        catch (GenericEntityException genericEntityException) {
            try {
                TransactionUtil.rollback(bl);
            }
            catch (GenericEntityException e2) {
                Debug.logError((String)"[GenericDelegator.storeAll] Could not rollback transaction: ", (String)module);
                Debug.logError((Throwable)((Object)e2), (String)module);
            }
            throw genericEntityException;
        }
        for (GenericValue genericValue : values) {
            if (!genericValue.lockEnabled()) continue;
            this.refresh(genericValue);
        }
        return numberChanged;
    }

    @Override
    public int removeAll(List<? extends GenericEntity> dummyPKs) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        return this.removeAll(dummyPKs, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int removeAll(List<? extends GenericEntity> dummyPKs, boolean doCacheClear) throws GenericEntityException {
        void var5_8;
        GenericDelegator.checkIfLocked();
        if (dummyPKs == null) {
            return 0;
        }
        HashMap<String, LinkedList<GenericEntity>> valuesPerHelper = new HashMap<String, LinkedList<GenericEntity>>();
        for (GenericEntity genericEntity : dummyPKs) {
            String helperName = this.getEntityHelperName(genericEntity.getEntityName());
            LinkedList<GenericEntity> helperValues = (LinkedList<GenericEntity>)valuesPerHelper.get(helperName);
            if (helperValues == null) {
                helperValues = new LinkedList<GenericEntity>();
                valuesPerHelper.put(helperName, helperValues);
            }
            helperValues.add(genericEntity);
        }
        boolean beganTransaction = false;
        boolean bl = false;
        try {
            if (valuesPerHelper.size() > 1) {
                beganTransaction = TransactionUtil.begin();
            }
            for (Map.Entry entry : valuesPerHelper.entrySet()) {
                String helperName = (String)entry.getKey();
                GenericHelper helper = GenericHelperFactory.getHelper(helperName);
                if (doCacheClear) {
                    this.clearAllCacheLinesByDummyPK((Collection)entry.getValue());
                }
                var5_8 += helper.removeAll((List)entry.getValue());
            }
            TransactionUtil.commit(beganTransaction);
        }
        catch (GenericEntityException e) {
            try {
                TransactionUtil.rollback(beganTransaction);
            }
            catch (GenericEntityException e2) {
                Debug.logError((String)"[GenericDelegator.removeAll] Could not rollback transaction: ", (String)module);
                Debug.logError((Throwable)((Object)e2), (String)module);
            }
            throw e;
        }
        return (int)var5_8;
    }

    @Override
    public void clearAllCaches() {
        GenericDelegator.checkIfLocked();
        this.clearAllCaches(true);
    }

    @Override
    public void clearAllCaches(boolean distribute) {
        GenericDelegator.checkIfLocked();
        if (this.allCache != null) {
            this.allCache.clear();
        }
        if (this.andCache != null) {
            this.andCache.clear();
        }
        if (this.andCacheFieldSets != null) {
            this.andCacheFieldSets.clear();
        }
        if (this.primaryKeyCache != null) {
            this.primaryKeyCache.clear();
        }
        if (distribute && this.distributedCacheClear != null) {
            this.distributedCacheClear.clearAllCaches();
        }
    }

    @Override
    public void clearCacheLine(String entityName, Map<String, ?> fields) {
        GenericDelegator.checkIfLocked();
        if (fields == null && this.allCache != null) {
            this.allCache.remove((Object)entityName);
            return;
        }
        ModelEntity entity = this.getModelEntity(entityName);
        if (entity == null) {
            throw new IllegalArgumentException("[GenericDelegator.clearCacheLine] could not find entity for entityName: " + entityName);
        }
        if (entity.getNeverCache()) {
            return;
        }
        GenericPK dummyPK = new GenericPK(entity, fields);
        this.clearCacheLineFlexible(dummyPK);
    }

    @Override
    public void clearCacheLineFlexible(GenericEntity dummyPK) {
        GenericDelegator.checkIfLocked();
        this.clearCacheLineFlexible(dummyPK, true);
    }

    @Override
    public void clearCacheLineFlexible(GenericEntity dummyPK, boolean distribute) {
        GenericDelegator.checkIfLocked();
        if (dummyPK != null) {
            if (dummyPK.getModelEntity().getNeverCache()) {
                return;
            }
            if (this.allCache != null) {
                this.allCache.remove((Object)dummyPK.getEntityName());
            }
            if (dummyPK.isPrimaryKey()) {
                if (this.primaryKeyCache != null) {
                    this.primaryKeyCache.remove((Object)dummyPK);
                }
            } else if (dummyPK.size() > 0 && this.andCache != null) {
                this.andCache.remove((Object)dummyPK);
            }
            if (distribute && this.distributedCacheClear != null) {
                this.distributedCacheClear.distributedClearCacheLineFlexible(dummyPK);
            }
        }
    }

    @Override
    public void clearCacheLine(GenericPK primaryKey) {
        GenericDelegator.checkIfLocked();
        this.clearCacheLine(primaryKey, true);
    }

    @Override
    public void clearCacheLine(GenericPK primaryKey, boolean distribute) {
        GenericDelegator.checkIfLocked();
        if (primaryKey == null) {
            return;
        }
        if (primaryKey.getModelEntity().getNeverCache()) {
            return;
        }
        if (this.allCache != null) {
            this.allCache.remove((Object)primaryKey.getEntityName());
        }
        if (this.primaryKeyCache != null) {
            this.primaryKeyCache.remove((Object)primaryKey);
        }
        if (distribute && this.distributedCacheClear != null) {
            this.distributedCacheClear.distributedClearCacheLine(primaryKey);
        }
    }

    @Override
    public void clearCacheLine(GenericValue value) {
        GenericDelegator.checkIfLocked();
        this.clearCacheLine(value, true);
    }

    @Override
    public void clearCacheLine(GenericValue value, boolean distribute) {
        Set<Set<String>> fieldNameSets;
        GenericDelegator.checkIfLocked();
        if (value == null) {
            return;
        }
        if (value.getModelEntity().getNeverCache()) {
            return;
        }
        if (this.allCache != null) {
            this.allCache.remove((Object)value.getEntityName());
        }
        if (this.primaryKeyCache != null) {
            this.primaryKeyCache.remove((Object)value.getPrimaryKey());
        }
        if ((fieldNameSets = this.andCacheFieldSets.get(value.getEntityName())) != null) {
            for (Set<String> fieldNameSet : fieldNameSets) {
                HashMap<String, Object> originalFieldValues = null;
                if (value.isModified() && value.originalDbValuesAvailable()) {
                    originalFieldValues = new HashMap<String, Object>();
                }
                HashMap<String, Object> fieldValues = new HashMap<String, Object>();
                for (String fieldName : fieldNameSet) {
                    fieldValues.put(fieldName, value.get(fieldName));
                    if (originalFieldValues == null) continue;
                    originalFieldValues.put(fieldName, value.getOriginalDbValue(fieldName));
                }
                GenericPK dummyPK = new GenericPK(value.getModelEntity(), fieldValues);
                this.andCache.remove((Object)dummyPK);
                if (originalFieldValues == null || originalFieldValues.equals(fieldValues)) continue;
                GenericPK dummyPKOriginal = new GenericPK(value.getModelEntity(), originalFieldValues);
                this.andCache.remove((Object)dummyPKOriginal);
            }
        }
        if (distribute && this.distributedCacheClear != null) {
            this.distributedCacheClear.distributedClearCacheLine(value);
        }
    }

    @Override
    public Set<Set<String>> getFieldNameSetsCopy(String entityName) {
        GenericDelegator.checkIfLocked();
        Set<Set<String>> fieldNameSets = this.andCacheFieldSets.get(entityName);
        if (fieldNameSets == null) {
            return null;
        }
        TreeSet<Set<String>> setsCopy = new TreeSet<Set<String>>();
        for (Set<String> fieldNameSet : fieldNameSets) {
            setsCopy.add(new TreeSet<String>(fieldNameSet));
        }
        return setsCopy;
    }

    @Override
    public void clearAllCacheLinesByDummyPK(Collection<? extends GenericEntity> dummyPKs) {
        GenericDelegator.checkIfLocked();
        if (dummyPKs == null) {
            return;
        }
        for (GenericEntity genericEntity : dummyPKs) {
            this.clearCacheLineFlexible(genericEntity);
        }
    }

    @Override
    public void clearAllCacheLinesByValue(Collection<? extends GenericValue> values) {
        GenericDelegator.checkIfLocked();
        if (values == null) {
            return;
        }
        for (GenericValue genericValue : values) {
            this.clearCacheLine(genericValue);
        }
    }

    @Override
    public GenericValue getFromPrimaryKeyCache(GenericPK primaryKey) {
        GenericDelegator.checkIfLocked();
        if (primaryKey == null) {
            return null;
        }
        return (GenericValue)this.primaryKeyCache.get((Object)primaryKey);
    }

    @Override
    public List<GenericValue> getFromAllCache(String entityName) {
        GenericDelegator.checkIfLocked();
        if (entityName == null) {
            return null;
        }
        return (List)this.allCache.get((Object)entityName);
    }

    @Override
    public List<GenericValue> getFromAndCache(String entityName, Map<String, ?> fields) {
        GenericDelegator.checkIfLocked();
        if (entityName == null || fields == null) {
            return null;
        }
        ModelEntity entity = this.getModelEntity(entityName);
        return this.getFromAndCache(entity, fields);
    }

    @Override
    public List<GenericValue> getFromAndCache(ModelEntity entity, Map<String, ?> fields) {
        GenericDelegator.checkIfLocked();
        if (entity == null || fields == null) {
            return null;
        }
        GenericPK tempPK = new GenericPK(entity, fields);
        return (List)this.andCache.get((Object)tempPK);
    }

    @Override
    public void putInPrimaryKeyCache(GenericPK primaryKey, GenericValue value) {
        GenericDelegator.checkIfLocked();
        if (primaryKey == null || value == null) {
            return;
        }
        if (value.getModelEntity().getNeverCache()) {
            Debug.logWarning((String)("Tried to put a value of the " + value.getEntityName() + " entity in the BY PRIMARY KEY cache but this entity has never-cache set to true, not caching."));
            return;
        }
        this.primaryKeyCache.put((Object)primaryKey, (Object)value);
    }

    @Override
    public void putAllInPrimaryKeyCache(List<? extends GenericValue> values) {
        GenericDelegator.checkIfLocked();
        if (values == null) {
            return;
        }
        for (GenericValue genericValue : values) {
            this.putInPrimaryKeyCache(genericValue.getPrimaryKey(), genericValue);
        }
    }

    @Override
    public void putInAllCache(String entityName, List<? extends GenericValue> values) {
        GenericDelegator.checkIfLocked();
        if (entityName == null || values == null) {
            return;
        }
        ModelEntity entity = this.getModelEntity(entityName);
        this.putInAllCache(entity, values);
    }

    @Override
    public void putInAllCache(ModelEntity entity, List<? extends GenericValue> values) {
        GenericDelegator.checkIfLocked();
        if (entity == null || values == null) {
            return;
        }
        if (entity.getNeverCache()) {
            Debug.logWarning((String)("Tried to put values of the " + entity.getEntityName() + " entity in the ALL cache but this entity has never-cache set to true, not caching."));
            return;
        }
        this.allCache.put((Object)entity.getEntityName(), Collections.unmodifiableList(values));
    }

    @Override
    public void putInAndCache(String entityName, Map<String, ?> fields, List<? extends GenericValue> values) {
        GenericDelegator.checkIfLocked();
        if (entityName == null || fields == null || values == null) {
            return;
        }
        ModelEntity entity = this.getModelEntity(entityName);
        this.putInAndCache(entity, fields, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putInAndCache(ModelEntity entity, Map<String, ?> fields, List<? extends GenericValue> values) {
        GenericDelegator.checkIfLocked();
        if (entity == null || fields == null || values == null) {
            return;
        }
        if (entity.getNeverCache()) {
            Debug.logWarning((String)("Tried to put values of the " + entity.getEntityName() + " entity in the BY AND cache but this entity has never-cache set to true, not caching."));
            return;
        }
        GenericPK tempPK = new GenericPK(entity, fields);
        this.andCache.put((Object)tempPK, Collections.unmodifiableList(values));
        Set<Set<String>> fieldNameSets = this.andCacheFieldSets.get(entity.getEntityName());
        if (fieldNameSets == null) {
            GenericDelegator genericDelegator = this;
            synchronized (genericDelegator) {
                fieldNameSets = this.andCacheFieldSets.get(entity.getEntityName());
                if (fieldNameSets == null) {
                    fieldNameSets = new HashSet<Set<String>>();
                    this.andCacheFieldSets.put(entity.getEntityName(), fieldNameSets);
                }
            }
        }
        fieldNameSets.add(new HashSet<String>(fields.keySet()));
    }

    public List<GenericValue> readXmlDocument(URL url) throws SAXException, ParserConfigurationException, IOException {
        if (url == null) {
            return null;
        }
        return this.makeValues(UtilXml.readXmlDocument((URL)url, (boolean)false));
    }

    public List<GenericValue> makeValues(Document document) {
        GenericDelegator.checkIfLocked();
        if (document == null) {
            return null;
        }
        LinkedList<GenericValue> values = new LinkedList<GenericValue>();
        Element docElement = document.getDocumentElement();
        if (docElement == null) {
            return null;
        }
        if (!"entity-engine-xml".equals(docElement.getTagName())) {
            Debug.logError((String)"[GenericDelegator.makeValues] Root node was not <entity-engine-xml>", (String)module);
            throw new IllegalArgumentException("Root node was not <entity-engine-xml>");
        }
        docElement.normalize();
        Node curChild = docElement.getFirstChild();
        if (curChild != null) {
            do {
                Element element;
                GenericValue value;
                if (curChild.getNodeType() != 1 || (value = this.makeValue(element = (Element)curChild)) == null) continue;
                values.add(value);
            } while ((curChild = curChild.getNextSibling()) != null);
        } else {
            Debug.logWarning((String)"[GenericDelegator.makeValues] No child nodes found in document.", (String)module);
        }
        return values;
    }

    public GenericPK makePK(Element element) {
        GenericDelegator.checkIfLocked();
        GenericValue value = this.makeValue(element);
        return value.getPrimaryKey();
    }

    public GenericValue makeValue(Element element) {
        GenericDelegator.checkIfLocked();
        if (element == null) {
            return null;
        }
        String entityName = this.getEntityName(element);
        GenericValue value = this.makeValue(entityName, null);
        ModelEntity modelEntity = value.getModelEntity();
        Iterator<ModelField> modelFields = modelEntity.getFieldsIterator();
        while (modelFields.hasNext()) {
            ModelField modelField = modelFields.next();
            String name = modelField.getName();
            String attr = element.getAttribute(name);
            if (attr != null && attr.length() > 0) {
                value.setString(name, attr);
                continue;
            }
            Element subElement = UtilXml.firstChildElement((Element)element, (String)name);
            if (subElement == null) continue;
            value.setString(name, UtilXml.elementValue((Element)subElement));
        }
        return value;
    }

    private String getEntityName(Element element) {
        String tagName = element.getTagName();
        if (tagName.indexOf(45) > 0) {
            return tagName.substring(tagName.indexOf(45) + 1);
        }
        if (tagName.indexOf(58) > 0) {
            return tagName.substring(tagName.indexOf(58) + 1);
        }
        return tagName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getNextSeqId(String seqName) {
        GenericDelegator.checkIfLocked();
        if (this.sequencer == null) {
            GenericDelegator genericDelegator = this;
            synchronized (genericDelegator) {
                if (this.sequencer == null) {
                    String helperName = this.getEntityHelperName("SequenceValueItem");
                    ModelEntity seqEntity = this.getModelEntity("SequenceValueItem");
                    this.sequencer = new SequenceUtil(helperName, seqEntity, "seqName", "seqId");
                }
            }
        }
        return this.sequencer.getNextSeqId(seqName);
    }

    @Override
    public void setSequencer(SequenceUtil sequencer) {
        GenericDelegator.checkIfLocked();
        this.sequencer = sequencer;
    }

    @Override
    public void refreshSequencer() {
        GenericDelegator.checkIfLocked();
        this.sequencer = null;
    }

    protected void absorbList(List<GenericValue> lst) {
        if (lst == null) {
            return;
        }
        for (GenericValue aLst : lst) {
            aLst.setDelegator(this);
        }
    }

    @Override
    public UtilCache<GenericEntity, GenericValue> getPrimaryKeyCache() {
        GenericDelegator.checkIfLocked();
        return this.primaryKeyCache;
    }

    @Override
    public UtilCache<GenericPK, List<GenericValue>> getAndCache() {
        GenericDelegator.checkIfLocked();
        return this.andCache;
    }

    @Override
    public UtilCache<String, List<GenericValue>> getAllCache() {
        GenericDelegator.checkIfLocked();
        return this.allCache;
    }

    @Override
    public List<GenericValue> transform(String entityName, EntityCondition entityCondition, List<String> orderBy, String lockField, Transformation transformation) throws GenericEntityException {
        GenericDelegator.checkIfLocked();
        ModelEntity modelEntity = this.getModelReader().getModelEntity(entityName);
        GenericHelper entityHelper = this.getEntityHelper(entityName);
        List<GenericValue> transformedEntities = entityHelper.transform(modelEntity, entityCondition, orderBy, lockField, transformation);
        for (GenericValue genericValue : transformedEntities) {
            genericValue.setDelegator(this);
        }
        return transformedEntities;
    }

    private static void checkIfLocked() {
        if (GenericDelegator.isLocked()) {
            throw new UnsupportedOperationException(MESSAGE);
        }
    }
}

