/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.ofbiz.core.entity.GenericHelper;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.util.Debug;

public class GenericHelperFactory {
    protected static Map<String, GenericHelper> helperCache = CopyOnWriteMap.newHashMap();

    public static synchronized void removeHelper(String helperName) {
        helperCache.remove(helperName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GenericHelper getHelper(String helperName) {
        GenericHelper helper = helperCache.get(helperName);
        if (helper != null) return helper;
        Class<GenericHelperFactory> clazz = GenericHelperFactory.class;
        synchronized (GenericHelperFactory.class) {
            helper = helperCache.get(helperName);
            if (helper != null) return helper;
            try {
                DatasourceInfo datasourceInfo = EntityConfigUtil.getInstance().getDatasourceInfo(helperName);
                if (datasourceInfo == null) {
                    throw new IllegalStateException("Could not find datasource definition with name " + helperName);
                }
                String helperClassName = datasourceInfo.getHelperClass();
                Class<?> helperClass = null;
                if (helperClassName != null && helperClassName.length() > 0) {
                    try {
                        ClassLoader loader = Thread.currentThread().getContextClassLoader();
                        helperClass = loader.loadClass(helperClassName);
                    }
                    catch (ClassNotFoundException e) {
                        Debug.logWarning((Throwable)e);
                        throw new IllegalStateException("Error loading GenericHelper class \"" + helperClassName + "\": " + e.getMessage());
                    }
                }
                Class[] paramTypes = new Class[]{String.class};
                Object[] params = new Object[]{helperName};
                Constructor<?> helperConstructor = null;
                if (helperClass != null) {
                    try {
                        helperConstructor = helperClass.getConstructor(paramTypes);
                    }
                    catch (NoSuchMethodException e) {
                        Debug.logWarning((Throwable)e);
                        throw new IllegalStateException("Error loading GenericHelper class \"" + helperClassName + "\": " + e.getMessage());
                    }
                }
                try {
                    helper = (GenericHelper)helperConstructor.newInstance(params);
                }
                catch (IllegalAccessException e) {
                    Debug.logWarning((Throwable)e);
                    throw new IllegalStateException("Error loading GenericHelper class \"" + helperClassName + "\": " + e.getMessage());
                }
                catch (InstantiationException e) {
                    Debug.logWarning((Throwable)e);
                    throw new IllegalStateException("Error loading GenericHelper class \"" + helperClassName + "\": " + e.getMessage());
                }
                catch (InvocationTargetException e) {
                    Debug.logWarning((Throwable)e);
                    throw new IllegalStateException("Error loading GenericHelper class \"" + helperClassName + "\": " + e.getMessage());
                }
                if (helper == null) return helper;
                helperCache.put(helperName, helper);
            }
            catch (SecurityException e) {
                Debug.logError((Throwable)e);
                throw new IllegalStateException("Error loading GenericHelper class: " + e.toString());
            }
            return helper;
        }
    }
}

