/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Status;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;
import org.ofbiz.core.entity.ConnectionFactory;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericTransactionException;
import org.ofbiz.core.entity.TransactionFactory;
import org.ofbiz.core.util.Debug;

public class TransactionUtil
implements Status {
    public static final String module = TransactionUtil.class.getName();
    public static final ThreadLocal<Connection> localTransaction = new ThreadLocal();

    public static boolean begin() throws GenericTransactionException {
        UserTransaction ut = TransactionFactory.getUserTransaction();
        if (ut != null) {
            try {
                if (ut.getStatus() == 0) {
                    Debug.logVerbose((String)"[TransactionUtil.begin] active transaction in place, so no transaction begun", (String)module);
                    return false;
                }
                ut.begin();
                Debug.logVerbose((String)"[TransactionUtil.begin] transaction begun", (String)module);
                return true;
            }
            catch (NotSupportedException e) {
                throw new GenericTransactionException("Not Supported error, could not begin transaction (probably a nesting problem)", e);
            }
            catch (SystemException e) {
                throw new GenericTransactionException("System error, could not begin transaction", e);
            }
        }
        Debug.logInfo((String)"[TransactionUtil.begin] no user transaction, so no transaction begun", (String)module);
        return false;
    }

    public static int getStatus() throws GenericTransactionException {
        UserTransaction ut = TransactionFactory.getUserTransaction();
        if (ut != null) {
            try {
                return ut.getStatus();
            }
            catch (SystemException e) {
                throw new GenericTransactionException("System error, could not get status", e);
            }
        }
        return 6;
    }

    public static void commit(boolean beganTransaction) throws GenericTransactionException {
        if (beganTransaction) {
            TransactionUtil.commit();
        }
    }

    public static void commit() throws GenericTransactionException {
        UserTransaction ut = TransactionFactory.getUserTransaction();
        if (ut != null) {
            try {
                int status = ut.getStatus();
                if (status != 6) {
                    ut.commit();
                    Debug.logVerbose((String)"[TransactionUtil.commit] transaction committed", (String)module);
                }
                Debug.logInfo((String)"[TransactionUtil.commit] Not committing transaction, status is STATUS_NO_TRANSACTION", (String)module);
            }
            catch (RollbackException e) {
                throw new GenericTransactionException("Roll back error, could not commit transaction, was rolled back instead", e);
            }
            catch (HeuristicMixedException e) {
                throw new GenericTransactionException("Could not commit transaction, HeuristicMixed exception", e);
            }
            catch (HeuristicRollbackException e) {
                throw new GenericTransactionException("Could not commit transaction, HeuristicRollback exception", e);
            }
            catch (SystemException e) {
                throw new GenericTransactionException("System error, could not commit transaction", e);
            }
        } else {
            Debug.logInfo((String)"[TransactionUtil.commit] UserTransaction is null, not commiting", (String)module);
        }
    }

    public static void rollback(boolean beganTransaction) throws GenericTransactionException {
        if (beganTransaction) {
            TransactionUtil.rollback();
        } else {
            TransactionUtil.setRollbackOnly();
        }
    }

    public static void rollback() throws GenericTransactionException {
        UserTransaction ut = TransactionFactory.getUserTransaction();
        if (ut != null) {
            try {
                int status = ut.getStatus();
                if (status != 6) {
                    ut.rollback();
                    Debug.logInfo((String)"[TransactionUtil.rollback] transaction rolled back", (String)module);
                }
                Debug.logInfo((String)"[TransactionUtil.rollback] transaction not rolled back, status is STATUS_NO_TRANSACTION", (String)module);
            }
            catch (SystemException e) {
                throw new GenericTransactionException("System error, could not roll back transaction", e);
            }
        } else {
            Debug.logInfo((String)"[TransactionUtil.rollback] No UserTransaction, transaction not rolled back", (String)module);
        }
    }

    public static void setRollbackOnly() throws GenericTransactionException {
        UserTransaction ut = TransactionFactory.getUserTransaction();
        if (ut != null) {
            try {
                int status = ut.getStatus();
                if (status != 6) {
                    ut.setRollbackOnly();
                    Debug.logInfo((String)"[TransactionUtil.setRollbackOnly] transaction roll back only set", (String)module);
                }
                Debug.logInfo((String)"[TransactionUtil.setRollbackOnly] transaction roll back only set, status is STATUS_NO_TRANSACTION", (String)module);
            }
            catch (SystemException e) {
                throw new GenericTransactionException("System error, could not set roll back only on transaction", e);
            }
        } else {
            Debug.logInfo((String)"[TransactionUtil.setRollbackOnly] No UserTransaction, transaction roll back only not set", (String)module);
        }
    }

    public static void setTransactionTimeout(int seconds) throws GenericTransactionException {
        UserTransaction ut = TransactionFactory.getUserTransaction();
        if (ut != null) {
            try {
                ut.setTransactionTimeout(seconds);
            }
            catch (SystemException e) {
                throw new GenericTransactionException("System error, could not set transaction timeout", e);
            }
        }
    }

    public static Connection enlistConnection(XAConnection xacon) throws GenericTransactionException {
        if (xacon == null) {
            return null;
        }
        try {
            XAResource resource = xacon.getXAResource();
            TransactionUtil.enlistResource(resource);
            return xacon.getConnection();
        }
        catch (SQLException e) {
            throw new GenericTransactionException("SQL error, could not enlist connection in transaction even though transactions are available", e);
        }
    }

    public static void enlistResource(XAResource resource) throws GenericTransactionException {
        if (resource == null) {
            return;
        }
        try {
            Transaction tx;
            TransactionManager tm = TransactionFactory.getTransactionManager();
            if (tm != null && tm.getStatus() == 0 && (tx = tm.getTransaction()) != null) {
                tx.enlistResource(resource);
            }
        }
        catch (RollbackException e) {
            throw new GenericTransactionException("Roll Back error, could not enlist connection in transaction even though transactions are available, current transaction rolled back", e);
        }
        catch (SystemException e) {
            throw new GenericTransactionException("System error, could not enlist connection in transaction even though transactions are available", e);
        }
    }

    public static boolean beginLocalTransaction(String helperName, int transactionIsolationLevel) throws GenericTransactionException {
        try {
            if (TransactionUtil.isTransactionActive()) {
                Debug.logInfo((String)"[TransactionUtil.beginLocalTransaction] Transaction already started so not starting transaction.", (String)module);
                return false;
            }
            Debug.logInfo((String)"[TransactionUtil.beginLocalTransaction] Transaction not started so starting transaction.", (String)module);
            Connection connection = ConnectionFactory.getConnection(helperName);
            if (transactionIsolationLevel >= 0) {
                connection.setTransactionIsolation(transactionIsolationLevel);
            }
            connection.setAutoCommit(false);
            localTransaction.set(connection);
            Debug.logInfo((String)"[TransactionUtil.beginLocalTransaction] Transaction started.", (String)module);
            return true;
        }
        catch (SQLException e) {
            throw new GenericTransactionException("Error occurred while starting transaction.", e);
        }
        catch (GenericEntityException e) {
            throw new GenericTransactionException("Error occurred while starting transaction.", (Throwable)((Object)e));
        }
    }

    public static Connection getLocalTransactionConnection() {
        return localTransaction.get();
    }

    public static boolean isTransactionActive() {
        return TransactionUtil.getLocalTransactionConnection() != null;
    }

    public static void commitLocalTransaction(boolean beganTransaction) throws GenericTransactionException {
        if (!beganTransaction) {
            Debug.logInfo((String)"[TransactionUtil.commitLocalTransaction] Transaction not started so not committing transaction.", (String)module);
            return;
        }
        if (TransactionUtil.isTransactionActive()) {
            try {
                Debug.logInfo((String)"[TransactionUtil.commitLocalTransaction] Transaction started and active so committing transaction.", (String)module);
                TransactionUtil.getLocalTransactionConnection().commit();
                Debug.logInfo((String)"[TransactionUtil.commitLocalTransaction] Transaction committed.", (String)module);
            }
            catch (SQLException e) {
                throw new GenericTransactionException("Error occurred while committing transaction.", e);
            }
            finally {
                TransactionUtil.closeAndClearThreadLocalConnection();
            }
        } else {
            Debug.logInfo((String)"[TransactionUtil.commitLocalTransaction] Transaction not active so not committing transaction.", (String)module);
        }
    }

    public static void rollbackLocalTransaction(boolean beganTransaction) throws GenericTransactionException {
        if (!beganTransaction) {
            Debug.logInfo((String)"[TransactionUtil.rollbackLocalTransaction] Transaction not started so not rolling back.", (String)module);
            return;
        }
        if (TransactionUtil.isTransactionActive()) {
            try {
                Debug.logInfo((String)"[TransactionUtil.rollbackLocalTransaction] Transaction started and active so rolling back.", (String)module);
                TransactionUtil.getLocalTransactionConnection().rollback();
                Debug.logInfo((String)"[TransactionUtil.rollbackLocalTransaction] Transaction rolled back.", (String)module);
            }
            catch (SQLException e) {
                throw new GenericTransactionException("Error occurred while rolling back transaction.", e);
            }
            finally {
                TransactionUtil.closeAndClearThreadLocalConnection();
            }
        } else {
            Debug.logInfo((String)"[TransactionUtil.rollbackLocalTransaction] Transaction not active so not rolling back.", (String)module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAndClearThreadLocalConnection() {
        Connection connection = TransactionUtil.getLocalTransactionConnection();
        try {
            if (connection != null) {
                connection.close();
                Debug.logInfo((String)"Connection closed.", (String)module);
            }
        }
        catch (SQLException se) {
            Debug.logInfo((Throwable)se, (String)"Exception occurred while closing connection after transaction commit. Ignoring the exception.", (String)module);
        }
        finally {
            TransactionUtil.clearTransactionThreadLocal();
        }
    }

    public static void clearTransactionThreadLocal() {
        localTransaction.set(null);
        Debug.logInfo((String)"Thread local cleared.", (String)module);
    }
}

