/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.util.List;
import org.ofbiz.core.entity.model.ModelField;

public class LimitHelper {
    private final String databaseTypeName;
    private final int SELECT_OFFSET = 7;
    private final String SUBQUERY_VARIABLE = "sq_";

    public LimitHelper(String databaseTypeName) {
        this.databaseTypeName = databaseTypeName;
    }

    public String addLimitClause(String sql, List<ModelField> selectFields, int maxResults) {
        return this.addLimitClause(sql, selectFields, 0, maxResults);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String addLimitClause(String sql, List<ModelField> selectFields, int offset, int maxResults) {
        StringBuilder sqlBuilder = new StringBuilder();
        int limit = maxResults + offset;
        if (offset < 0) {
            throw new IllegalArgumentException(String.format("Offset %d is invalid, it  must be a valid non-negative integer.", offset));
        }
        if (sql.indexOf("ORDER BY") < 0) {
            throw new IllegalArgumentException(String.format("The SQL %s is invalid it does not have an ORDER BY clause.", sql));
        }
        if (maxResults <= 0) {
            sqlBuilder.append(sql);
            return sqlBuilder.toString();
        }
        if (this.databaseTypeName.equals("mysql") || this.databaseTypeName.startsWith("postgres")) {
            sqlBuilder.append(sql);
            sqlBuilder.append(" LIMIT ");
            sqlBuilder.append(maxResults);
            if (offset <= 0) return sqlBuilder.toString();
            sqlBuilder.append(" OFFSET ");
            sqlBuilder.append(offset);
            return sqlBuilder.toString();
        }
        if (this.databaseTypeName.equals("hsql")) {
            if (offset > 0) {
                sqlBuilder.append(sql);
                sqlBuilder.insert(7, "LIMIT " + offset + " " + maxResults + " ");
                return sqlBuilder.toString();
            }
            sqlBuilder = new StringBuilder(this.buildTopClause(sql, maxResults));
            return sqlBuilder.toString();
        }
        if (this.databaseTypeName.equals("mssql")) {
            return new MSSQLClauseBuilder(selectFields, offset, limit, sql).buildSqlClause();
        }
        if (this.databaseTypeName.startsWith("oracle")) {
            return new OracleClauseBuilder(selectFields, offset, limit, sql).buildSqlClause();
        }
        throw new IllegalArgumentException(String.format("The database type %s is not a supported database type.", this.databaseTypeName));
    }

    private String buildTopClause(String sql, int maxResults) {
        StringBuilder sqlBuilder = new StringBuilder(sql);
        sqlBuilder.insert(7, "TOP " + maxResults + " ");
        return sqlBuilder.toString();
    }

    private String getParentClause(List<ModelField> modelFields, boolean useSubQueryVariable) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT ");
        if (modelFields.isEmpty()) {
            if (useSubQueryVariable) {
                sqlBuilder.append("sq_");
                sqlBuilder.append(".");
            }
            sqlBuilder.append("*");
        } else {
            int i;
            for (i = 0; i < modelFields.size() - 1; ++i) {
                sqlBuilder.append(this.createQualifiedColumnName(modelFields.get(i).getColName(), useSubQueryVariable));
                sqlBuilder.append(",");
            }
            sqlBuilder.append(this.createQualifiedColumnName(modelFields.get(i).getColName(), useSubQueryVariable));
        }
        sqlBuilder.append(" FROM (");
        return sqlBuilder.toString();
    }

    private String createQualifiedColumnName(String colName, boolean useSubQueryVariable) {
        String subQueryPrefix = useSubQueryVariable ? "sq_." : "";
        return subQueryPrefix + this.stripTableName(colName);
    }

    private String stripTableName(String columnName) {
        return columnName.replaceAll(".*\\.", "");
    }

    private class MSSQLClauseBuilder {
        private final List<ModelField> selectFields;
        private final int offset;
        private final int limit;
        private final String sql;
        private static final String ROW_NUMBER_FUNCTION = ", ROW_NUMBER() OVER (";

        public MSSQLClauseBuilder(List<ModelField> selectFields, int offset, int limit, String sql) {
            this.selectFields = selectFields;
            this.offset = offset;
            this.limit = limit;
            this.sql = sql;
        }

        public String buildSqlClause() {
            String subQuery = this.buildlimitSqlClause();
            if (this.offset > 0) {
                subQuery = this.appendOffset(subQuery);
            }
            return subQuery;
        }

        private String buildlimitSqlClause() {
            StringBuilder sqlBuilder = new StringBuilder(this.moveOrderByClause(this.sql));
            sqlBuilder.insert(0, LimitHelper.this.getParentClause(this.selectFields, true));
            sqlBuilder.append(") ");
            sqlBuilder.append("sq_");
            sqlBuilder.append(" WHERE ");
            sqlBuilder.append("sq_");
            sqlBuilder.append(".rnum <= ");
            sqlBuilder.append(this.limit);
            return sqlBuilder.toString();
        }

        private String moveOrderByClause(String sql) {
            StringBuilder builder = new StringBuilder();
            int orderByPosition = sql.indexOf("ORDER BY");
            builder.append(sql.substring(0, orderByPosition - 1));
            String orderBy = sql.substring(orderByPosition);
            int insertPosition = sql.indexOf("FROM") - 1;
            if (insertPosition > 0) {
                builder.insert(insertPosition, ROW_NUMBER_FUNCTION + orderBy + ") rnum");
            }
            return builder.toString();
        }

        private String appendOffset(String subQuery) {
            StringBuilder builder = new StringBuilder(subQuery);
            builder.append(" AND ");
            builder.append("sq_");
            builder.append(".rnum > ");
            builder.append(this.offset);
            return builder.toString();
        }
    }

    private class OracleClauseBuilder {
        private final List<ModelField> selectFields;
        private final int offset;
        private final int limit;
        private final String sql;

        public OracleClauseBuilder(List<ModelField> selectFields, int offset, int limit, String sql) {
            this.selectFields = selectFields;
            this.offset = offset;
            this.limit = limit;
            this.sql = sql;
        }

        public String buildSqlClause() {
            String subQuery = this.buildlimitSqlClause();
            if (this.offset > 0) {
                subQuery = this.surroundSubQueryWithOffset(subQuery);
            }
            return subQuery;
        }

        private String buildlimitSqlClause() {
            StringBuilder sqlBuilder = new StringBuilder(this.sql);
            sqlBuilder.insert(0, LimitHelper.this.getParentClause(this.selectFields, true));
            sqlBuilder.append(") ");
            sqlBuilder.append("sq_");
            sqlBuilder.append(" WHERE ROWNUM <= ");
            sqlBuilder.append(this.limit);
            return sqlBuilder.toString();
        }

        private String surroundSubQueryWithOffset(String subQuery) {
            StringBuilder fullQueryBuilder = new StringBuilder(this.appendRownumInQuery(subQuery));
            fullQueryBuilder.insert(0, LimitHelper.this.getParentClause(this.selectFields, false));
            fullQueryBuilder.append(") WHERE rnum > ");
            fullQueryBuilder.append(this.offset);
            return fullQueryBuilder.toString();
        }

        private String appendRownumInQuery(String subQuery) {
            StringBuilder builder = new StringBuilder(subQuery);
            int insertPosition = subQuery.indexOf("FROM") - 1;
            if (insertPosition > 0) {
                builder.insert(insertPosition, ",ROWNUM rnum");
            }
            return builder.toString();
        }
    }
}

