/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.config.ResourceHandler;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.model.ModelFieldType;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilCache;
import org.ofbiz.core.util.UtilTimer;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModelFieldTypeReader {
    public static final String module = ModelFieldTypeReader.class.getName();
    public static UtilCache readers = new UtilCache("entity.ModelFieldTypeReader", 0L, 0L);
    public Map fieldTypeCache = null;
    public int numEntities = 0;
    public int numFields = 0;
    public int numRelations = 0;
    public String modelName;
    public ResourceHandler fieldTypeResourceHandler;
    public String entityFileName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ModelFieldTypeReader getModelFieldTypeReader(String helperName) {
        DatasourceInfo datasourceInfo = EntityConfigUtil.getInstance().getDatasourceInfo(helperName);
        if (datasourceInfo == null) {
            throw new IllegalArgumentException("Could not find a datasource/helper with the name " + helperName);
        }
        String tempModelName = datasourceInfo.getFieldTypeName();
        ModelFieldTypeReader reader = (ModelFieldTypeReader)readers.get((Object)tempModelName);
        if (reader != null) return reader;
        Class<ModelFieldTypeReader> clazz = ModelFieldTypeReader.class;
        synchronized (ModelFieldTypeReader.class) {
            reader = (ModelFieldTypeReader)readers.get((Object)tempModelName);
            if (reader != null) return reader;
            reader = new ModelFieldTypeReader(tempModelName);
            readers.put((Object)tempModelName, (Object)reader);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return reader;
        }
    }

    public ModelFieldTypeReader(String modelName) {
        this.modelName = modelName;
        EntityConfigUtil.FieldTypeInfo fieldTypeInfo = EntityConfigUtil.getInstance().getFieldTypeInfo(modelName);
        if (fieldTypeInfo == null) {
            throw new IllegalStateException("Could not find a field-type definition with name \"" + modelName + "\"");
        }
        this.fieldTypeResourceHandler = new ResourceHandler("entityengine.xml", fieldTypeInfo.resourceElement);
        this.getFieldTypeCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map getFieldTypeCache() {
        if (this.fieldTypeCache != null) return this.fieldTypeCache;
        Class<ModelFieldTypeReader> clazz = ModelFieldTypeReader.class;
        synchronized (ModelFieldTypeReader.class) {
            if (this.fieldTypeCache != null) return this.fieldTypeCache;
            this.fieldTypeCache = new HashMap();
            UtilTimer utilTimer = new UtilTimer();
            Document document = null;
            try {
                document = this.fieldTypeResourceHandler.getDocument();
            }
            catch (GenericConfigException e) {
                Debug.logError((Throwable)e, (String)"Error loading field type file");
            }
            if (document == null) {
                this.fieldTypeCache = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            Element docElement = document.getDocumentElement();
            if (docElement == null) {
                this.fieldTypeCache = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            docElement.normalize();
            Node curChild = docElement.getFirstChild();
            int i = 0;
            if (curChild != null) {
                utilTimer.timerString("Before start of field type loop");
                do {
                    if (curChild.getNodeType() != 1 || !"field-type-def".equals(curChild.getNodeName())) continue;
                    ++i;
                    Element curFieldType = (Element)curChild;
                    String fieldTypeName = UtilXml.checkEmpty((String)curFieldType.getAttribute("type"), (String)"[No type name]");
                    ModelFieldType fieldType = this.createModelFieldType(curFieldType, docElement, null);
                    if (fieldType != null) {
                        this.fieldTypeCache.put(fieldTypeName, fieldType);
                        if (!Debug.verboseOn()) continue;
                        Debug.logVerbose((String)("-- getModelFieldType: #" + i + " Created fieldType: " + fieldTypeName), (String)module);
                        continue;
                    }
                    Debug.logWarning((String)("-- -- ENTITYGEN ERROR:getModelFieldType: Could not create fieldType for fieldTypeName: " + fieldTypeName), (String)module);
                } while ((curChild = curChild.getNextSibling()) != null);
            } else {
                Debug.logWarning((String)"No child nodes found.", (String)module);
            }
            utilTimer.timerString("FINISHED - Total Field Types: " + i + " FINISHED");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.fieldTypeCache;
        }
    }

    public Collection getFieldTypeNames() {
        Map ftc = this.getFieldTypeCache();
        return ftc.keySet();
    }

    public Collection getFieldTypes() {
        Map ftc = this.getFieldTypeCache();
        return ftc.values();
    }

    public ModelFieldType getModelFieldType(String fieldTypeName) {
        Map ftc = this.getFieldTypeCache();
        if (ftc != null) {
            return (ModelFieldType)ftc.get(fieldTypeName);
        }
        return null;
    }

    ModelFieldType createModelFieldType(Element fieldTypeElement, Element docElement, UtilTimer utilTimer) {
        if (fieldTypeElement == null) {
            return null;
        }
        ModelFieldType field = new ModelFieldType(fieldTypeElement);
        return field;
    }
}

