/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.TreeSet;
import org.ofbiz.core.entity.ByteWrapper;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericNotImplementedException;
import org.ofbiz.core.entity.GenericPK;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.jdbc.SqlJdbcUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelFieldType;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilFormatOut;
import org.ofbiz.core.util.UtilValidate;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GenericEntity
extends Observable
implements Map,
Serializable,
Comparable,
Cloneable {
    public String delegatorName = null;
    public transient GenericDelegator internalDelegator = null;
    protected Map fields;
    public String entityName = null;
    public transient ModelEntity modelEntity = null;
    public boolean modified = false;

    public GenericEntity() {
        this.entityName = null;
        this.modelEntity = null;
        this.fields = new HashMap();
    }

    public GenericEntity(ModelEntity modelEntity) {
        if (modelEntity == null) {
            throw new IllegalArgumentException("Cannont create a GenericEntity with a null modelEntity parameter");
        }
        this.modelEntity = modelEntity;
        this.entityName = modelEntity.getEntityName();
        this.fields = new HashMap();
    }

    public GenericEntity(ModelEntity modelEntity, Map fields) {
        if (modelEntity == null) {
            throw new IllegalArgumentException("Cannont create a GenericEntity with a null modelEntity parameter");
        }
        this.modelEntity = modelEntity;
        this.entityName = modelEntity.getEntityName();
        this.fields = new HashMap();
        this.setFields(fields);
    }

    public GenericEntity(GenericEntity value) {
        this.entityName = value.modelEntity.getEntityName();
        this.modelEntity = value.modelEntity;
        this.fields = value.fields == null ? new HashMap() : new HashMap(value.fields);
        this.delegatorName = value.delegatorName;
        this.internalDelegator = value.internalDelegator;
    }

    public boolean isModified() {
        return this.modified;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public ModelEntity getModelEntity() {
        if (this.modelEntity == null) {
            if (this.entityName != null) {
                this.modelEntity = this.getDelegator().getModelEntity(this.entityName);
            }
            if (this.modelEntity == null) {
                throw new IllegalStateException("[GenericEntity.getModelEntity] could not find modelEntity for entityName " + this.entityName);
            }
        }
        return this.modelEntity;
    }

    public GenericDelegator getDelegator() {
        if (this.internalDelegator == null) {
            if (this.delegatorName != null) {
                this.internalDelegator = GenericDelegator.getGenericDelegator(this.delegatorName);
            }
            if (this.internalDelegator == null) {
                throw new IllegalStateException("[GenericEntity.getDelegator] could not find delegator with name " + this.delegatorName);
            }
        }
        return this.internalDelegator;
    }

    public void setDelegator(GenericDelegator internalDelegator) {
        if (internalDelegator == null) {
            return;
        }
        this.delegatorName = internalDelegator.getDelegatorName();
        this.internalDelegator = internalDelegator;
    }

    public Object get(String name) {
        if (this.getModelEntity().getField(name) == null) {
            throw new IllegalArgumentException("[GenericEntity.get] \"" + name + "\" is not a field of " + this.entityName);
        }
        return this.fields.get(name);
    }

    public boolean isPrimaryKey() {
        TreeSet fieldKeys = new TreeSet(this.fields.keySet());
        for (int i = 0; i < this.getModelEntity().getPksSize(); ++i) {
            if (!fieldKeys.contains(this.getModelEntity().getPk(i).getName())) {
                return false;
            }
            fieldKeys.remove(this.getModelEntity().getPk(i).getName());
        }
        return fieldKeys.isEmpty();
    }

    public boolean containsPrimaryKey() {
        TreeSet fieldKeys = new TreeSet(this.fields.keySet());
        for (int i = 0; i < this.getModelEntity().getPksSize(); ++i) {
            if (fieldKeys.contains(this.getModelEntity().getPk(i).getName())) continue;
            return false;
        }
        return true;
    }

    public void set(String name, Object value) {
        this.set(name, value, true);
    }

    public synchronized Object set(String name, Object value, boolean setIfNull) {
        ModelField modelField = this.getModelEntity().getField(name);
        if (modelField == null) {
            throw new IllegalArgumentException("[GenericEntity.set] \"" + name + "\" is not a field of " + this.entityName);
        }
        if (value != null || setIfNull) {
            if (value instanceof Boolean) {
                ModelFieldType type = null;
                try {
                    type = this.getDelegator().getEntityFieldType(this.getModelEntity(), modelField.getType());
                }
                catch (GenericEntityException e) {
                    Debug.logWarning((Throwable)((Object)e));
                }
                if (type == null) {
                    throw new IllegalArgumentException("Type " + modelField.getType() + " not found");
                }
                try {
                    int fieldType = SqlJdbcUtil.getType(type.getJavaType());
                    if (fieldType != 9) {
                        value = (Boolean)value != false ? "Y" : "N";
                    }
                }
                catch (GenericNotImplementedException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
            Object old = this.fields.put(name, value);
            this.modified = true;
            this.setChanged();
            this.notifyObservers(name);
            return old;
        }
        return this.fields.get(name);
    }

    public void dangerousSetNoCheckButFast(ModelField modelField, Object value) {
        if (modelField == null) {
            throw new IllegalArgumentException("Cannot set field with a null modelField");
        }
        this.fields.put(modelField.getName(), value);
    }

    public Object dangerousGetNoCheckButFast(ModelField modelField) {
        if (modelField == null) {
            throw new IllegalArgumentException("Cannot get field with a null modelField");
        }
        return this.fields.get(modelField.getName());
    }

    public void setString(String name, String value) {
        ModelField field = this.getModelEntity().getField(name);
        if (field == null) {
            this.set(name, value);
        }
        ModelFieldType type = null;
        try {
            type = this.getDelegator().getEntityFieldType(this.getModelEntity(), field.getType());
        }
        catch (GenericEntityException e) {
            Debug.logWarning((Throwable)((Object)e));
        }
        if (type == null) {
            throw new IllegalArgumentException("Type " + field.getType() + " not found");
        }
        String fieldType = type.getJavaType();
        try {
            switch (SqlJdbcUtil.getType(fieldType)) {
                case 1: {
                    this.set(name, value);
                    break;
                }
                case 2: {
                    this.set(name, Timestamp.valueOf(value));
                    break;
                }
                case 3: {
                    this.set(name, Time.valueOf(value));
                    break;
                }
                case 4: {
                    this.set(name, Date.valueOf(value));
                    break;
                }
                case 5: {
                    this.set(name, Integer.valueOf(value));
                    break;
                }
                case 6: {
                    this.set(name, Long.valueOf(value));
                    break;
                }
                case 7: {
                    this.set(name, Float.valueOf(value));
                    break;
                }
                case 8: {
                    this.set(name, Double.valueOf(value));
                    break;
                }
                case 9: {
                    this.set(name, Boolean.valueOf(value));
                    break;
                }
                case 10: {
                    this.set(name, value);
                }
            }
        }
        catch (GenericNotImplementedException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public void setBytes(String name, byte[] bytes) {
        this.set(name, new ByteWrapper(bytes));
    }

    public Boolean getBoolean(String name) {
        Object obj = this.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            String value = (String)obj;
            if ("Y".equals(value)) {
                return Boolean.TRUE;
            }
            if ("N".equals(value)) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("getBoolean could not map the String '" + value + "' to Boolean type");
        }
        throw new IllegalArgumentException("getBoolean could not map the object '" + obj.toString() + "' to Boolean type, unknown object type: " + obj.getClass().getName());
    }

    public String getString(String name) {
        Object object = this.get(name);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    public Timestamp getTimestamp(String name) {
        return (Timestamp)this.get(name);
    }

    public Time getTime(String name) {
        return (Time)this.get(name);
    }

    public Date getDate(String name) {
        return (Date)this.get(name);
    }

    public Integer getInteger(String name) {
        return (Integer)this.get(name);
    }

    public Long getLong(String name) {
        return (Long)this.get(name);
    }

    public Float getFloat(String name) {
        return (Float)this.get(name);
    }

    public Double getDouble(String name) {
        return (Double)this.get(name);
    }

    public byte[] getBytes(String name) {
        ByteWrapper wrapper = (ByteWrapper)this.get(name);
        if (wrapper == null) {
            return null;
        }
        return wrapper.getBytes();
    }

    public GenericPK getPrimaryKey() {
        LinkedList<String> pkNames = new LinkedList<String>();
        Iterator iter = this.getModelEntity().getPksIterator();
        while (iter != null && iter.hasNext()) {
            ModelField curField = (ModelField)iter.next();
            pkNames.add(curField.getName());
        }
        return new GenericPK(this.getModelEntity(), this.getFields(pkNames));
    }

    public void setPKFields(Map fields) {
        this.setPKFields(fields, true);
    }

    public void setPKFields(Map fields, boolean setIfEmpty) {
        Iterator iter = this.getModelEntity().getPksIterator();
        while (iter != null && iter.hasNext()) {
            ModelField curField = (ModelField)iter.next();
            if (!fields.containsKey(curField.getName())) continue;
            Object field = fields.get(curField.getName());
            if (setIfEmpty) {
                if (field != null && field instanceof String && ((String)field).length() == 0) {
                    this.set(curField.getName(), null);
                    continue;
                }
                this.set(curField.getName(), field);
                continue;
            }
            if (field == null) continue;
            if (field instanceof String) {
                String fieldStr = (String)field;
                if (fieldStr.length() <= 0) continue;
                this.set(curField.getName(), field);
                continue;
            }
            this.set(curField.getName(), field);
        }
    }

    public void setNonPKFields(Map fields) {
        this.setNonPKFields(fields, true);
    }

    public void setNonPKFields(Map fields, boolean setIfEmpty) {
        Iterator iter = this.getModelEntity().getNopksIterator();
        while (iter != null && iter.hasNext()) {
            ModelField curField = (ModelField)iter.next();
            if (!fields.containsKey(curField.getName())) continue;
            Object field = fields.get(curField.getName());
            if (setIfEmpty) {
                if (field != null && field instanceof String && ((String)field).length() == 0) {
                    this.set(curField.getName(), null);
                    continue;
                }
                this.set(curField.getName(), field);
                continue;
            }
            if (field == null) continue;
            if (field instanceof String) {
                String fieldStr = (String)field;
                if (fieldStr.length() <= 0) continue;
                this.set(curField.getName(), field);
                continue;
            }
            this.set(curField.getName(), field);
        }
    }

    public Collection getAllKeys() {
        return this.fields.keySet();
    }

    public Map getAllFields() {
        return new HashMap(this.fields);
    }

    public Map getFields(Collection keysofFields) {
        if (keysofFields == null) {
            return null;
        }
        Iterator keys = keysofFields.iterator();
        Object aKey = null;
        HashMap aMap = new HashMap();
        while (keys.hasNext()) {
            aKey = keys.next();
            aMap.put(aKey, this.fields.get(aKey));
        }
        return aMap;
    }

    public synchronized void setFields(Map keyValuePairs) {
        if (keyValuePairs == null) {
            return;
        }
        Iterator entries = keyValuePairs.entrySet().iterator();
        Map.Entry anEntry = null;
        while (entries.hasNext()) {
            anEntry = entries.next();
            this.set((String)anEntry.getKey(), anEntry.getValue(), true);
        }
    }

    public boolean matchesFields(Map keyValuePairs) {
        if (this.fields == null) {
            return true;
        }
        if (keyValuePairs == null || keyValuePairs.size() == 0) {
            return true;
        }
        for (Map.Entry anEntry : keyValuePairs.entrySet()) {
            if (UtilValidate.areEqual(anEntry.getValue(), this.fields.get(anEntry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public boolean lockEnabled() {
        return this.modelEntity.lock();
    }

    public static Document makeXmlDocument(Collection values) {
        Document document = UtilXml.makeEmptyXmlDocument((String)"entity-engine-xml");
        if (document == null) {
            return null;
        }
        GenericEntity.addToXmlDocument(values, document);
        return document;
    }

    public static int addToXmlDocument(Collection values, Document document) {
        if (values == null) {
            return 0;
        }
        if (document == null) {
            return 0;
        }
        Element rootElement = document.getDocumentElement();
        Iterator iter = values.iterator();
        int numberAdded = 0;
        while (iter.hasNext()) {
            GenericValue value = (GenericValue)iter.next();
            Element valueElement = value.makeXmlElement(document);
            rootElement.appendChild(valueElement);
            ++numberAdded;
        }
        return numberAdded;
    }

    public Element makeXmlElement(Document document) {
        return this.makeXmlElement(document, null);
    }

    public Element makeXmlElement(Document document, String prefix) {
        Element element = null;
        if (prefix == null) {
            prefix = "";
        }
        if (document != null) {
            element = document.createElement(prefix + this.getEntityName());
        }
        if (element == null) {
            return null;
        }
        ModelEntity modelEntity = this.getModelEntity();
        Iterator modelFields = modelEntity.getFieldsIterator();
        while (modelFields.hasNext()) {
            ModelField modelField = (ModelField)modelFields.next();
            String name = modelField.getName();
            String value = this.getString(name);
            if (value == null) continue;
            if (value.indexOf(10) >= 0 || value.indexOf(13) >= 0) {
                UtilXml.addChildElementCDATAValue((Element)element, (String)name, (String)this.escapeCDATA(value), (Document)document);
                continue;
            }
            element.setAttribute(name, value);
        }
        return element;
    }

    public void writeXmlText(PrintWriter writer, String prefix) {
        int indent = 4;
        if (prefix == null) {
            prefix = "";
        }
        ModelEntity modelEntity = this.getModelEntity();
        for (int i = 0; i < 4; ++i) {
            writer.print(' ');
        }
        writer.print('<');
        writer.print(prefix);
        writer.print(this.getEntityName());
        HashMap<String, String> cdataMap = new HashMap<String, String>();
        Iterator modelFields = modelEntity.getFieldsIterator();
        while (modelFields.hasNext()) {
            ModelField modelField = (ModelField)modelFields.next();
            String name = modelField.getName();
            String value = this.getString(name);
            if (value == null) continue;
            if (value.indexOf(10) >= 0 || value.indexOf(13) >= 0) {
                cdataMap.put(name, value);
                continue;
            }
            writer.print(' ');
            writer.print(name);
            writer.print("=\"");
            writer.print(UtilFormatOut.encodeXmlValue((String)value));
            writer.print("\"");
        }
        if (cdataMap.size() == 0) {
            writer.println("/>");
        } else {
            writer.println('>');
            for (Map.Entry entry : cdataMap.entrySet()) {
                for (int i = 0; i < 8; ++i) {
                    writer.print(' ');
                }
                writer.print('<');
                writer.print((String)entry.getKey());
                writer.print("><![CDATA[");
                this.writeCdata(writer, (String)entry.getValue());
                writer.print("]]></");
                writer.print((String)entry.getKey());
                writer.println('>');
            }
            for (int i = 0; i < 4; ++i) {
                writer.print(' ');
            }
            writer.print("</");
            writer.print(this.getEntityName());
            writer.println(">");
        }
    }

    private void writeCdata(PrintWriter writer, String s) {
        if (s == null) {
            writer.print(s);
            return;
        }
        int index = 0;
        int oldIndex = 0;
        while ((index = s.indexOf("]]>", oldIndex)) > -1) {
            writer.print(s.substring(oldIndex, index));
            oldIndex = index + 3;
            writer.print("]]]]><![CDATA[>");
        }
        writer.print(s.substring(oldIndex));
    }

    private String escapeCDATA(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        int oldIndex = 0;
        while ((index = s.indexOf("]]>", oldIndex)) > -1) {
            buffer.append(s.substring(oldIndex, index));
            oldIndex = index + 3;
            buffer.append("]]]]><![CDATA[>");
        }
        buffer.append(s.substring(oldIndex));
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.compareTo(obj) == 0;
    }

    public int hashCode() {
        return this.getEntityName().hashCode() >> 1 + ((Object)this.fields).hashCode() >> 1;
    }

    public String toString() {
        StringBuffer theString = new StringBuffer();
        theString.append("[GenericEntity:");
        theString.append(this.getEntityName());
        theString.append(']');
        Iterator entries = this.fields.entrySet().iterator();
        Map.Entry anEntry = null;
        while (entries.hasNext()) {
            anEntry = entries.next();
            theString.append('[');
            theString.append(anEntry.getKey());
            theString.append(',');
            theString.append(anEntry.getValue());
            theString.append(']');
        }
        return theString.toString();
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return -1;
        }
        GenericEntity that = (GenericEntity)obj;
        int tempResult = this.entityName.compareTo(that.entityName);
        if (tempResult != 0) {
            return tempResult;
        }
        int pksSize = this.modelEntity.getPksSize();
        for (int i = 0; i < pksSize; ++i) {
            ModelField curField = this.modelEntity.getPk(i);
            Comparable thisVal = (Comparable)this.fields.get(curField.getName());
            Comparable thatVal = (Comparable)that.fields.get(curField.getName());
            tempResult = thisVal == null ? (thatVal == null ? 0 : 1) : (thatVal == null ? -1 : thisVal.compareTo(thatVal));
            if (tempResult == 0) continue;
            return tempResult;
        }
        int nopksSize = this.modelEntity.getNopksSize();
        for (int i = 0; i < nopksSize; ++i) {
            ModelField curField = this.modelEntity.getNopk(i);
            Comparable thisVal = (Comparable)this.fields.get(curField.getName());
            Comparable thatVal = (Comparable)that.fields.get(curField.getName());
            tempResult = thisVal == null ? (thatVal == null ? 0 : 1) : (thatVal == null ? -1 : thisVal.compareTo(thatVal));
            if (tempResult == 0) continue;
            return tempResult;
        }
        return tempResult;
    }

    public Object clone() {
        GenericEntity newEntity = new GenericEntity(this);
        newEntity.setDelegator(this.internalDelegator);
        return newEntity;
    }

    public Object remove(Object key) {
        return this.fields.remove(key);
    }

    public boolean containsKey(Object key) {
        return this.fields.containsKey(key);
    }

    public Set entrySet() {
        return this.fields.entrySet();
    }

    public Object put(Object key, Object value) {
        return this.set((String)key, value, true);
    }

    public void putAll(Map map) {
        this.setFields(map);
    }

    public void clear() {
        this.fields.clear();
    }

    public Object get(Object key) {
        return this.get((String)key);
    }

    public Set keySet() {
        return this.fields.keySet();
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public Collection values() {
        return this.fields.values();
    }

    public boolean containsValue(Object value) {
        return this.fields.containsValue(value);
    }

    public int size() {
        return this.fields.size();
    }
}

