/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericTransactionException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.TransactionUtil;
import org.ofbiz.core.util.Debug;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class EntitySaxReader
implements ContentHandler,
ErrorHandler {
    public static final String module = EntitySaxReader.class.getName();
    protected Locator locator;
    protected GenericDelegator delegator;
    protected GenericValue currentValue = null;
    protected String currentFieldName = null;
    protected String currentFieldValue = null;
    protected long numberRead = 0L;
    protected int valuesPerWrite = 100;
    protected int valuesPerMessage = 1000;
    protected int transactionTimeout = 7200;
    protected List valuesToWrite = new ArrayList(this.valuesPerWrite);

    protected EntitySaxReader() {
    }

    public EntitySaxReader(GenericDelegator delegator) {
        this.delegator = delegator;
    }

    public int getValuesPerWrite() {
        return this.valuesPerWrite;
    }

    public void setValuesPerWrite(int valuesPerWrite) {
        this.valuesPerWrite = valuesPerWrite;
    }

    public int getValuesPerMessage() {
        return this.valuesPerMessage;
    }

    public void setValuesPerMessage(int valuesPerMessage) {
        this.valuesPerMessage = valuesPerMessage;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) throws GenericTransactionException {
        if (this.transactionTimeout != transactionTimeout) {
            TransactionUtil.setTransactionTimeout(transactionTimeout);
            this.transactionTimeout = transactionTimeout;
        }
    }

    public long parse(String content) throws SAXException, IOException {
        if (content == null) {
            Debug.logWarning((String)"content was null, doing nothing", (String)module);
            return 0L;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(content.getBytes());
        return this.parse(bis, "Internal Content");
    }

    public long parse(URL location) throws SAXException, IOException {
        if (location == null) {
            Debug.logWarning((String)"location URL was null, doing nothing", (String)module);
            return 0L;
        }
        return this.parse(location.openStream(), location.toString());
    }

    public long parse(InputStream is, String docDescription) throws SAXException, IOException {
        XMLReader reader = null;
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            reader = parser.getXMLReader();
        }
        catch (ParserConfigurationException e) {
            Debug.logError((Throwable)e, (String)"Failed to get a SAX XML parser");
            throw new IllegalStateException("Failed to get a SAX XML parser");
        }
        reader.setContentHandler(this);
        reader.setErrorHandler(this);
        this.numberRead = 0L;
        try {
            boolean beganTransaction = TransactionUtil.begin();
            TransactionUtil.setTransactionTimeout(this.transactionTimeout);
            Debug.logImportant((String)("Transaction Timeout set to " + this.transactionTimeout / 3600 + " hours (" + this.transactionTimeout + " seconds)"));
            try {
                reader.parse(new InputSource(is));
                if (this.valuesToWrite.size() > 0) {
                    this.delegator.storeAll(this.valuesToWrite);
                    this.valuesToWrite.clear();
                }
                TransactionUtil.commit(beganTransaction);
            }
            catch (Exception e) {
                Debug.logError((Throwable)e, (String)"An error occurred saving the data, rolling back transaction");
                TransactionUtil.rollback(beganTransaction);
                throw new SAXException("A transaction error occurred reading data", e);
            }
        }
        catch (GenericTransactionException e) {
            throw new SAXException("A transaction error occurred reading data", (Exception)((Object)e));
        }
        Debug.logImportant((String)("Finished writing " + this.numberRead + " values to the database from " + docDescription));
        return this.numberRead;
    }

    public void characters(char[] values, int offset, int count) throws SAXException {
        if (this.currentValue != null && this.currentFieldName != null) {
            String value = new String(values, offset, count);
            this.currentFieldValue = this.currentFieldValue == null ? value : this.currentFieldValue + value;
        }
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String namespaceURI, String localName, String fullName) throws SAXException {
        if ("entity-engine-xml".equals(fullName)) {
            return;
        }
        if (this.currentValue != null) {
            if (this.currentFieldName != null) {
                if (this.currentFieldValue != null && this.currentFieldValue.length() > 0) {
                    this.currentValue.setString(this.currentFieldName, this.currentFieldValue);
                    this.currentFieldValue = null;
                }
                this.currentFieldName = null;
            } else {
                try {
                    this.valuesToWrite.add(this.currentValue);
                    if (this.valuesToWrite.size() >= this.valuesPerWrite) {
                        this.delegator.storeAll(this.valuesToWrite);
                        this.valuesToWrite.clear();
                    }
                    ++this.numberRead;
                    if (this.numberRead % (long)this.valuesPerMessage == 0L) {
                        Debug.logImportant((String)("Another " + this.valuesPerMessage + " values imported: now up to " + this.numberRead));
                    }
                    this.currentValue = null;
                }
                catch (GenericEntityException e) {
                    throw new SAXException("Error storing value", (Exception)((Object)e));
                }
            }
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] values, int offset, int count) throws SAXException {
        String value = new String(values, offset, count);
    }

    public void processingInstruction(String target, String instruction) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String namepsaceURI, String localName, String fullName, Attributes attributes) throws SAXException {
        if ("entity-engine-xml".equals(fullName)) {
            return;
        }
        if (this.currentValue != null) {
            this.currentFieldName = fullName;
        } else {
            String entityName = fullName;
            if (entityName.indexOf(45) > 0) {
                entityName = entityName.substring(entityName.indexOf(45) + 1);
            }
            if (entityName.indexOf(58) > 0) {
                entityName = entityName.substring(entityName.indexOf(58) + 1);
            }
            try {
                this.currentValue = this.delegator.makeValue(entityName, null);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.currentValue != null) {
                int length = attributes.getLength();
                for (int i = 0; i < length; ++i) {
                    String name = attributes.getLocalName(i);
                    String value = attributes.getValue(i);
                    if (name == null || name.length() == 0) {
                        name = attributes.getQName(i);
                    }
                    try {
                        if (value == null || value.length() <= 0) continue;
                        this.currentValue.setString(name, value);
                        continue;
                    }
                    catch (Exception e) {
                        Debug.logWarning((Throwable)e, (String)("Could not set field " + name + " to the value " + value));
                    }
                }
            }
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void error(SAXParseException exception) throws SAXException {
        Debug.logWarning((Throwable)exception, (String)("Error reading XML on line " + exception.getLineNumber() + ", column " + exception.getColumnNumber()), (String)module);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        Debug.logError((Throwable)exception, (String)("Fatal Error reading XML on line " + exception.getLineNumber() + ", column " + exception.getColumnNumber()), (String)module);
        throw new SAXException("Fatal Error reading XML on line " + exception.getLineNumber() + ", column " + exception.getColumnNumber(), exception);
    }

    public void warning(SAXParseException exception) throws SAXException {
        Debug.logWarning((Throwable)exception, (String)("Warning reading XML on line " + exception.getLineNumber() + ", column " + exception.getColumnNumber()), (String)module);
    }
}

