/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.util.List;
import org.ofbiz.core.entity.model.ModelField;

public class LimitHelper {
    private final String fieldTypeName;

    public LimitHelper(String fieldTypeName) {
        this.fieldTypeName = fieldTypeName;
    }

    public String addLimitClause(String sql, List<ModelField> selectFields, int maxResults) {
        StringBuilder sqlBuilder = new StringBuilder(sql);
        if (maxResults > 0) {
            if (this.fieldTypeName.equals("mysql") || this.fieldTypeName.startsWith("postgres")) {
                sqlBuilder.append(" LIMIT ");
                sqlBuilder.append(maxResults);
            }
            if (this.fieldTypeName.equals("hsql") || this.fieldTypeName.equals("mssql")) {
                sqlBuilder.insert(7, "TOP " + maxResults + " ");
            }
            if (this.fieldTypeName.startsWith("oracle")) {
                sqlBuilder.insert(0, this.getOracleParentClause(selectFields));
                sqlBuilder.append(") WHERE ROWNUM <= ");
                sqlBuilder.append(maxResults);
            }
        }
        return sqlBuilder.toString();
    }

    private String getOracleParentClause(List<ModelField> modelFields) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT ");
        if (modelFields.isEmpty()) {
            sqlBuilder.append("*");
        } else {
            int i;
            for (i = 0; i < modelFields.size() - 1; ++i) {
                sqlBuilder.append(this.stripTableName(modelFields.get(i).getColName()));
                sqlBuilder.append(",");
            }
            sqlBuilder.append(this.stripTableName(modelFields.get(i).getColName()));
        }
        sqlBuilder.append(" FROM (");
        return sqlBuilder.toString();
    }

    private String stripTableName(String columnName) {
        return columnName.replaceAll(".*\\.", "");
    }
}

