/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.transaction;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.commons.dbcp.ManagedBasicDataSourceFactory;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;
import org.ofbiz.core.entity.config.JdbcDatasourceInfo;
import org.ofbiz.core.entity.jdbc.interceptors.connection.ConnectionTracker;
import org.ofbiz.core.entity.transaction.TransactionIsolations;
import org.ofbiz.core.entity.util.PropertyUtils;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.StringUtil;
import org.ofbiz.core.util.UtilValidate;

public class DBCPConnectionFactory {
    private static final Logger log = Logger.getLogger(DBCPConnectionFactory.class);
    private static final String DBCP_PROPERTIES = "dbcp.properties";
    protected static final Map<String, BasicDataSource> dsCache = CopyOnWriteMap.newHashMap();
    protected static final Map<String, ConnectionTracker> trackerCache = CopyOnWriteMap.newHashMap();
    private static final String PROP_JMX = "jmx";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String helperName, JdbcDatasourceInfo jdbcDatasource) throws SQLException, GenericEntityException {
        BasicDataSource dataSource = dsCache.get(helperName);
        if (dataSource != null) {
            return DBCPConnectionFactory.trackConnection(helperName, (DataSource)dataSource);
        }
        try {
            Class<DBCPConnectionFactory> clazz = DBCPConnectionFactory.class;
            synchronized (DBCPConnectionFactory.class) {
                ConnectionPoolInfo poolInfo;
                Properties info;
                dataSource = dsCache.get(helperName);
                if (dataSource != null) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return DBCPConnectionFactory.trackConnection(helperName, (DataSource)dataSource);
                }
                Properties properties = info = jdbcDatasource.getConnectionProperties() != null ? PropertyUtils.copyOf(jdbcDatasource.getConnectionProperties()) : new Properties();
                if (jdbcDatasource.getUsername() != null) {
                    info.setProperty("user", jdbcDatasource.getUsername());
                }
                if (jdbcDatasource.getPassword() != null) {
                    info.setProperty("password", jdbcDatasource.getPassword());
                }
                dataSource = DBCPConnectionFactory.createDataSource();
                dataSource.setDriverClassLoader(Thread.currentThread().getContextClassLoader());
                dataSource.setDriverClassName(jdbcDatasource.getDriverClassName());
                dataSource.setUrl(jdbcDatasource.getUri());
                dataSource.setConnectionProperties(DBCPConnectionFactory.toString(info));
                if (UtilValidate.isNotEmpty((String)jdbcDatasource.getIsolationLevel())) {
                    dataSource.setDefaultTransactionIsolation(TransactionIsolations.fromString(jdbcDatasource.getIsolationLevel()));
                }
                if ((poolInfo = jdbcDatasource.getConnectionPoolInfo()) != null) {
                    dataSource.setMaxActive(poolInfo.getMaxSize());
                    dataSource.setMaxWait(poolInfo.getMaxWait());
                    if (UtilValidate.isNotEmpty((String)poolInfo.getValidationQuery())) {
                        dataSource.setTestOnBorrow(true);
                        dataSource.setValidationQuery(poolInfo.getValidationQuery());
                    }
                    if (poolInfo.getMinEvictableTimeMillis() != null) {
                        dataSource.setMinEvictableIdleTimeMillis(poolInfo.getMinEvictableTimeMillis().longValue());
                    }
                    if (poolInfo.getTimeBetweenEvictionRunsMillis() != null) {
                        dataSource.setTimeBetweenEvictionRunsMillis(poolInfo.getTimeBetweenEvictionRunsMillis().longValue());
                    }
                }
                dataSource.setLogWriter(Debug.getPrintWriter());
                dsCache.put(helperName, dataSource);
                trackerCache.put(helperName, new ConnectionTracker(poolInfo));
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return DBCPConnectionFactory.trackConnection(helperName, (DataSource)dataSource);
            }
        }
        catch (Exception e) {
            Debug.logError((Throwable)e, (String)("Error getting datasource via DBCP: " + jdbcDatasource));
            return null;
        }
    }

    private static BasicDataSource createDataSource() throws Exception {
        Properties dbcpProperties = DBCPConnectionFactory.loadDbcpProperties();
        if (dbcpProperties.containsKey(PROP_JMX) && Boolean.valueOf(dbcpProperties.getProperty(PROP_JMX)).booleanValue()) {
            return (BasicDataSource)ManagedBasicDataSourceFactory.createDataSource((Properties)dbcpProperties);
        }
        return (BasicDataSource)BasicDataSourceFactory.createDataSource((Properties)dbcpProperties);
    }

    private static String toString(Properties properties) {
        ArrayList<String> props = new ArrayList<String>();
        for (String key : properties.stringPropertyNames()) {
            props.add(key + "=" + properties.getProperty(key));
        }
        return StringUtil.join(props, (String)";");
    }

    private static Properties loadDbcpProperties() {
        Properties dbcpProperties = new Properties();
        InputStream fileProperties = DBCPConnectionFactory.class.getResourceAsStream("/dbcp.properties");
        if (fileProperties != null) {
            try {
                dbcpProperties.load(fileProperties);
            }
            catch (IOException e) {
                log.error((Object)"Error loading dbcp.properties", (Throwable)e);
            }
        }
        Properties systemProperties = System.getProperties();
        for (String systemProp : systemProperties.stringPropertyNames()) {
            String prefix = "dbcp.";
            if (!systemProp.startsWith("dbcp.")) continue;
            dbcpProperties.setProperty(systemProp.substring("dbcp.".length()), System.getProperty(systemProp));
        }
        return dbcpProperties;
    }

    private static Connection trackConnection(String helperName, final DataSource dataSource) {
        ConnectionTracker connectionTracker = trackerCache.get(helperName);
        return connectionTracker.trackConnection(helperName, new Callable<Connection>(){

            @Override
            public Connection call() throws Exception {
                return dataSource.getConnection();
            }
        });
    }

    public static synchronized void removeDatasource(String helperName) {
        BasicDataSource dataSource = dsCache.get(helperName);
        if (dataSource != null) {
            try {
                dataSource.close();
            }
            catch (Exception e) {
                Debug.logError((Throwable)e, (String)"Error closing connection pool in DBCP");
            }
            dsCache.remove(helperName);
        }
        trackerCache.remove(helperName);
    }
}

