/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.util.Iterator;
import java.util.List;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionParam;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericModelException;
import org.ofbiz.core.entity.model.ModelEntity;

public class EntityExprList
extends EntityCondition {
    protected List<? extends EntityExpr> exprList;
    protected EntityOperator operator;

    protected EntityExprList() {
    }

    public EntityExprList(List<? extends EntityExpr> exprList, EntityOperator operator) {
        this.exprList = exprList;
        this.operator = operator;
    }

    public EntityOperator getOperator() {
        return this.operator;
    }

    public EntityExpr getExpr(int index) {
        return this.exprList.get(index);
    }

    public int getExprListSize() {
        return this.exprList.size();
    }

    public Iterator<? extends EntityExpr> getExprIterator() {
        return this.exprList.iterator();
    }

    @Override
    public String makeWhereString(ModelEntity modelEntity, List<? super EntityConditionParam> entityConditionParams) {
        StringBuffer whereStringBuffer = new StringBuffer();
        if (this.exprList != null && this.exprList.size() > 0) {
            for (int i = 0; i < this.exprList.size(); ++i) {
                EntityExpr expr = this.exprList.get(i);
                whereStringBuffer.append('(');
                whereStringBuffer.append(expr.makeWhereString(modelEntity, entityConditionParams));
                whereStringBuffer.append(')');
                if (i >= this.exprList.size() - 1) continue;
                whereStringBuffer.append(' ');
                whereStringBuffer.append(this.operator.getCode());
                whereStringBuffer.append(' ');
            }
        }
        return whereStringBuffer.toString();
    }

    @Override
    public void checkCondition(ModelEntity modelEntity) throws GenericModelException {
        for (EntityExpr entityExpr : this.exprList) {
            entityExpr.checkCondition(modelEntity);
        }
    }

    public String toString() {
        StringBuffer toStringBuffer = new StringBuffer();
        toStringBuffer.append("[ExprList::");
        if (this.exprList != null && this.exprList.size() > 0) {
            for (int i = 0; i < this.exprList.size(); ++i) {
                EntityExpr expr = this.exprList.get(i);
                toStringBuffer.append(expr.toString());
                if (i <= 0) continue;
                toStringBuffer.append("::");
            }
        }
        toStringBuffer.append(']');
        return toStringBuffer.toString();
    }
}

