/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.util.Iterator;
import java.util.List;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionParam;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericModelException;
import org.ofbiz.core.entity.model.ModelEntity;

public class EntityConditionList
extends EntityCondition {
    protected List<? extends EntityCondition> conditionList;
    protected EntityOperator operator;

    protected EntityConditionList() {
    }

    public EntityConditionList(List<? extends EntityCondition> conditionList, EntityOperator operator) {
        this.conditionList = conditionList;
        this.operator = operator;
    }

    public EntityOperator getOperator() {
        return this.operator;
    }

    public EntityCondition getCondition(int index) {
        return this.conditionList.get(index);
    }

    public int getConditionListSize() {
        return this.conditionList.size();
    }

    public Iterator<? extends EntityCondition> getConditionIterator() {
        return this.conditionList.iterator();
    }

    @Override
    public String makeWhereString(ModelEntity modelEntity, List<? super EntityConditionParam> entityConditionParams) {
        StringBuffer whereStringBuffer = new StringBuffer();
        if (this.conditionList != null && this.conditionList.size() > 0) {
            for (int i = 0; i < this.conditionList.size(); ++i) {
                EntityCondition condition = this.conditionList.get(i);
                whereStringBuffer.append('(');
                whereStringBuffer.append(condition.makeWhereString(modelEntity, entityConditionParams));
                whereStringBuffer.append(')');
                if (i >= this.conditionList.size() - 1) continue;
                whereStringBuffer.append(' ');
                whereStringBuffer.append(this.operator.getCode());
                whereStringBuffer.append(' ');
            }
        }
        return whereStringBuffer.toString();
    }

    @Override
    public void checkCondition(ModelEntity modelEntity) throws GenericModelException {
        for (EntityCondition entityCondition : this.conditionList) {
            entityCondition.checkCondition(modelEntity);
        }
    }

    public String toString() {
        StringBuffer toStringBuffer = new StringBuffer();
        toStringBuffer.append("[conditionList::");
        if (this.conditionList != null && this.conditionList.size() > 0) {
            for (int i = 0; i < this.conditionList.size(); ++i) {
                EntityCondition condition = this.conditionList.get(i);
                toStringBuffer.append(condition.toString());
                if (i <= 0) continue;
                toStringBuffer.append("::");
            }
        }
        toStringBuffer.append(']');
        return toStringBuffer.toString();
    }
}

