/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionParam;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericModelException;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;

public class EntityExpr
extends EntityCondition {
    private Object lhs;
    private boolean leftUpper = false;
    private EntityOperator operator;
    private Object rhs;
    private boolean rightUpper = false;

    protected EntityExpr() {
    }

    public EntityExpr(String lhs, EntityOperator operator, Object rhs) {
        if (lhs == null) {
            throw new IllegalArgumentException("The field name cannot be null");
        }
        if (operator == null) {
            throw new IllegalArgumentException("The operator argument cannot be null");
        }
        this.lhs = lhs;
        this.operator = operator;
        this.rhs = rhs;
    }

    public EntityExpr(String lhs, boolean leftUpper, EntityOperator operator, Object rhs, boolean rightUpper) {
        this(lhs, operator, rhs);
        this.leftUpper = leftUpper;
        this.rightUpper = rightUpper;
    }

    public EntityExpr(EntityCondition lhs, EntityOperator operator, EntityCondition rhs) {
        if (lhs == null) {
            throw new IllegalArgumentException("The left EntityCondition argument cannot be null");
        }
        if (rhs == null) {
            throw new IllegalArgumentException("The right EntityCondition argument cannot be null");
        }
        if (operator == null) {
            throw new IllegalArgumentException("The operator argument cannot be null");
        }
        this.lhs = lhs;
        this.operator = operator;
        this.rhs = rhs;
    }

    public void setLUpper(boolean upper) {
        this.leftUpper = upper;
    }

    public boolean isLUpper() {
        return this.leftUpper;
    }

    public boolean isRUpper() {
        return this.rightUpper;
    }

    public void setRUpper(boolean upper) {
        this.rightUpper = upper;
    }

    public Object getLhs() {
        return this.lhs;
    }

    public EntityOperator getOperator() {
        return this.operator;
    }

    public Object getRhs() {
        return this.rhs;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String makeWhereString(ModelEntity modelEntity, List<? super EntityConditionParam> entityConditionParams) {
        StringBuffer whereStringBuffer = new StringBuffer();
        if (this.lhs instanceof String) {
            ModelField field = modelEntity.getField((String)this.getLhs());
            if (field == null) throw new IllegalArgumentException("ModelField with field name " + this.getLhs() + " not found");
            if (this.getRhs() == null) {
                whereStringBuffer.append(field.getColName());
                if (EntityOperator.NOT_EQUAL.equals(this.getOperator())) {
                    whereStringBuffer.append(" IS NOT NULL ");
                    return whereStringBuffer.toString();
                } else {
                    whereStringBuffer.append(" IS NULL ");
                }
                return whereStringBuffer.toString();
            } else {
                if (this.isLUpper()) {
                    whereStringBuffer.append("UPPER(" + field.getColName() + ")");
                } else {
                    whereStringBuffer.append(field.getColName());
                }
                whereStringBuffer.append(' ');
                whereStringBuffer.append(this.getOperator().toString());
                whereStringBuffer.append(' ');
                if (EntityOperator.IN.equals(this.getOperator())) {
                    whereStringBuffer.append('(');
                    if (this.rhs instanceof Collection) {
                        Iterator rhsIter = ((Collection)this.rhs).iterator();
                        while (rhsIter.hasNext()) {
                            void var6_6;
                            Object e = rhsIter.next();
                            whereStringBuffer.append('?');
                            if (rhsIter.hasNext()) {
                                whereStringBuffer.append(", ");
                            }
                            if (this.isRUpper() && e instanceof String) {
                                String string = ((String)e).toUpperCase();
                            }
                            entityConditionParams.add(new EntityConditionParam(field, var6_6));
                        }
                    } else {
                        whereStringBuffer.append(" ? ");
                        if (this.isRUpper() && this.rhs instanceof String) {
                            this.rhs = ((String)this.rhs).toUpperCase();
                        }
                        entityConditionParams.add(new EntityConditionParam(field, this.rhs));
                    }
                    whereStringBuffer.append(") ");
                    return whereStringBuffer.toString();
                } else {
                    whereStringBuffer.append(" ? ");
                    if (this.isRUpper() && this.rhs instanceof String) {
                        this.rhs = ((String)this.rhs).toUpperCase();
                    }
                    entityConditionParams.add(new EntityConditionParam(field, this.rhs));
                }
            }
            return whereStringBuffer.toString();
        } else {
            if (!(this.lhs instanceof EntityCondition)) return whereStringBuffer.toString();
            whereStringBuffer.append('(');
            whereStringBuffer.append(((EntityCondition)this.lhs).makeWhereString(modelEntity, entityConditionParams));
            whereStringBuffer.append(") ");
            whereStringBuffer.append(this.getOperator().toString());
            whereStringBuffer.append(" (");
            whereStringBuffer.append(((EntityCondition)this.rhs).makeWhereString(modelEntity, entityConditionParams));
            whereStringBuffer.append(')');
        }
        return whereStringBuffer.toString();
    }

    @Override
    public void checkCondition(ModelEntity modelEntity) throws GenericModelException {
        if (this.lhs instanceof String) {
            if (modelEntity.getField((String)this.lhs) == null) {
                throw new GenericModelException("Field with name " + this.lhs + " not found in the " + modelEntity.getEntityName() + " Entity");
            }
        } else if (this.lhs instanceof EntityCondition) {
            ((EntityCondition)this.lhs).checkCondition(modelEntity);
            ((EntityCondition)this.rhs).checkCondition(modelEntity);
        }
    }

    public String toString() {
        return "[Expr::" + this.lhs + "::" + this.operator + "::" + this.rhs + "]";
    }
}

