/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class UtilURL {
    public static URL fromClass(Class<?> contextClass) {
        Object resourceName = contextClass.getName();
        int dotIndex = ((String)resourceName).lastIndexOf(46);
        if (dotIndex != -1) {
            resourceName = ((String)resourceName).substring(0, dotIndex);
        }
        resourceName = (String)resourceName + ".properties";
        return UtilURL.fromResource(contextClass, (String)resourceName);
    }

    public static URL fromResource(String resourceName) {
        return UtilURL.fromResource(resourceName, null);
    }

    public static URL fromResource(Class<?> contextClass, String resourceName) {
        if (contextClass == null) {
            return UtilURL.fromResource(resourceName, null);
        }
        return UtilURL.fromResource(resourceName, contextClass.getClassLoader());
    }

    public static URL fromResource(String resourceName, ClassLoader loader) {
        URL url = null;
        if (loader != null && url == null) {
            url = loader.getResource(resourceName);
        }
        if (loader != null && url == null) {
            url = loader.getResource(resourceName + ".properties");
        }
        if (loader == null && url == null) {
            try {
                loader = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException e) {
                UtilURL utilURL = new UtilURL();
                loader = utilURL.getClass().getClassLoader();
            }
        }
        if (url == null) {
            url = loader.getResource(resourceName);
        }
        if (url == null) {
            url = loader.getResource(resourceName + ".properties");
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(resourceName);
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(resourceName + ".properties");
        }
        if (url == null) {
            url = UtilURL.fromFilename(resourceName);
        }
        return url;
    }

    public static URL fromFilename(String filename) {
        if (filename == null) {
            return null;
        }
        File file = new File(filename);
        URL url = null;
        try {
            if (file.exists()) {
                url = file.toURL();
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            url = null;
        }
        return url;
    }
}

