/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;

public class StringUtil {
    public static String replaceString(String mainString, String oldString, String newString) {
        if (mainString == null) {
            return null;
        }
        if (oldString == null || oldString.length() == 0) {
            return mainString;
        }
        if (newString == null) {
            newString = "";
        }
        return mainString.replace(oldString, newString);
    }

    public static String join(List<String> list, String delim) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (delim == null) {
            delim = "";
        }
        return String.join((CharSequence)delim, list);
    }

    public static List<String> split(String str, String delim) {
        ArrayList<String> splitList = null;
        StringTokenizer st = null;
        if (str == null) {
            return splitList;
        }
        st = delim != null ? new StringTokenizer(str, delim) : new StringTokenizer(str);
        if (st != null && st.hasMoreTokens()) {
            splitList = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                splitList.add(st.nextToken());
            }
        }
        return splitList;
    }

    public static List<String> quoteStrList(List<String> list) {
        return list.stream().map(str -> "'" + str + "'").collect(Collectors.toList());
    }

    public static Map<String, String> strToMap(String str) {
        if (str == null) {
            return null;
        }
        HashMap<String, String> decodedMap = new HashMap<String, String>();
        List<String> elements = StringUtil.split(str, "|");
        for (String element : elements) {
            List<String> e = StringUtil.split(element, "=");
            if (e.size() != 2) continue;
            String name = e.get(0);
            String value = e.get(1);
            decodedMap.put(URLDecoder.decode(name), URLDecoder.decode(value));
        }
        return decodedMap;
    }

    public static String mapToStr(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        Set<?> keySet = map.keySet();
        Iterator<?> i = keySet.iterator();
        boolean first = true;
        while (i.hasNext()) {
            Object key = i.next();
            Object value = map.get(key);
            if (!(key instanceof String) || !(value instanceof String)) continue;
            String encodedName = URLEncoder.encode((String)key);
            String encodedValue = URLEncoder.encode((String)value);
            if (first) {
                first = false;
            } else {
                buf.append("|");
            }
            buf.append(encodedName);
            buf.append("=");
            buf.append(encodedValue);
        }
        return buf.toString();
    }

    public static String cleanUpPathPrefix(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return "";
        }
        StringBuilder cppBuff = new StringBuilder(prefix.replace('\\', '/'));
        if (cppBuff.charAt(0) != '/') {
            cppBuff.insert(0, '/');
        }
        if (cppBuff.charAt(cppBuff.length() - 1) == '/') {
            cppBuff.deleteCharAt(cppBuff.length() - 1);
        }
        return cppBuff.toString();
    }

    public static String removeSpaces(String str) {
        return str.replaceAll("\\s+", "");
    }
}

