/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilDateTime;

public class UtilValidate {
    public static final boolean defaultEmptyOK = true;
    public static final String digits = "0123456789";
    public static final String lowercaseLetters = "abcdefghijklmnopqrstuvwxyz";
    public static final String uppercaseLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String whitespace = " \t\n\r";
    public static final String decimalPointDelimiter = ".";
    public static final String phoneNumberDelimiters = "()- ";
    public static final String validUSPhoneChars = "0123456789()- ";
    public static final String validWorldPhoneChars = "0123456789()- +";
    public static final String SSNDelimiters = "- ";
    public static final String validSSNChars = "0123456789- ";
    public static final int digitsInSocialSecurityNumber = 9;
    public static final int digitsInUSPhoneNumber = 10;
    public static final int digitsInUSPhoneAreaCode = 3;
    public static final int digitsInUSPhoneMainNumber = 7;
    public static final String ZipCodeDelimiters = "-";
    public static final String ZipCodeDelimeter = "-";
    public static final String validZipCodeChars = "0123456789-";
    public static final int digitsInZipCode1 = 5;
    public static final int digitsInZipCode2 = 9;
    public static final String creditCardDelimiters = " -";
    public static final String isNotEmptyMsg = "This field cannot be empty, please enter a value.";
    public static final String isStateCodeMsg = "The State Code must be a valid two character U.S. state abbreviation(like CA for California).";
    public static final String isContiguousStateCodeMsg = "The State Code must be a valid two character U.S. state abbreviation for one of the 48 contiguous United States (like CA for California).";
    public static final String isZipCodeMsg = "The ZIP Code must be a 5 or 9 digit U.S. ZIP Code(like 94043).";
    public static final String isUSPhoneMsg = "The US Phone must be a 10 digit U.S. phone number(like 415-555-1212).";
    public static final String isUSPhoneAreaCodeMsg = "The Phone Number Area Code must be 3 digits.";
    public static final String isUSPhoneMainNumberMsg = "The Phone Number must be 7 digits.";
    public static final String isContiguousZipCodeMsg = "Zip Code is not a valid Zip Code for one of the 48 contiguous United States .";
    public static final String isInternationalPhoneNumberMsg = "The World Phone must be a valid international phone number.";
    public static final String isSSNMsg = "The SSN must be a 9 digit U.S. social security number(like 123-45-6789).";
    public static final String isEmailMsg = "The Email must be a valid email address(like john@email.com). Please re-enter it now.";
    public static final String isAnyCardMsg = "The credit card number is not a valid card number.";
    public static final String isCreditCardPrefixMsg = " is not a valid ";
    public static final String isCreditCardSuffixMsg = " credit card number.";
    public static final String isDayMsg = "The Day must be a day number between 1 and 31. ";
    public static final String isMonthMsg = "The Month must be a month number between 1 and 12. ";
    public static final String isYearMsg = "The Year must be a 2 or 4 digit year number. ";
    public static final String isDatePrefixMsg = "The Day, Month, and Year for ";
    public static final String isDateSuffixMsg = " do not form a valid date.  Please reenter them now.";
    public static final String isHourMsg = "The Hour must be a number between 0 and 23.";
    public static final String isMinuteMsg = "The Hour must be a number between 0 and 59.";
    public static final String isSecondMsg = "The Hour must be a number between 0 and 59.";
    public static final String isTimeMsg = "The Time must be a valid time formed like: HH:MM or HH:MM:SS.";
    public static final String isDateMsg = "The Date must be a valid date formed like: MM/YY, MM/YYYY, MM/DD/YY, or MM/DD/YYYY.";
    public static final String isDateAfterToday = "The Date must be a valid date after today, and formed like: MM/YY, MM/YYYY, MM/DD/YY, or MM/DD/YYYY.";
    public static final String isIntegerMsg = "The Number must be a valid unsigned whole decimal number.";
    public static final String isSignedIntegerMsg = "The Number must be a valid signed whole decimal number.";
    public static final String isLongMsg = "The Number must be a valid unsigned whole decimal number.";
    public static final String isSignedLongMsg = "The Number must be a valid signed whole decimal number.";
    public static final String isFloatMsg = "The Number must be a valid unsigned decimal number.";
    public static final String isSignedFloatMsg = "The Number must be a valid signed decimal number.";
    public static final String isSignedDoubleMsg = "The Number must be a valid signed decimal number.";
    public static final int[] daysInMonth = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final String USStateCodeDelimiter = "|";
    public static final String USStateCodes = "AL|AK|AS|AZ|AR|CA|CO|CT|DE|DC|FM|FL|GA|GU|HI|ID|IL|IN|IA|KS|KY|LA|ME|MH|MD|MA|MI|MN|MS|MO|MT|NE|NV|NH|NJ|NM|NY|NC|ND|MP|OH|OK|OR|PW|PA|PR|RI|SC|SD|TN|TX|UT|VT|VI|VA|WA|WV|WI|WY|AE|AA|AE|AE|AP";
    public static final String ContiguousUSStateCodes = "AL|AZ|AR|CA|CO|CT|DE|DC|FL|GA|ID|IL|IN|IA|KS|KY|LA|ME|MD|MA|MI|MN|MS|MO|MT|NE|NV|NH|NJ|NM|NY|NC|ND|OH|OK|OR|PA|RI|SC|SD|TN|TX|UT|VT|VA|WA|WV|WI|WY";

    public static boolean areEqual(Object obj, Object obj2) {
        if (obj == null) {
            return obj2 == null;
        }
        return obj.equals(obj2);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isEmpty(Collection c) {
        return c == null || c.size() == 0;
    }

    public static boolean isNotEmpty(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean isNotEmpty(Collection c) {
        return c != null && c.size() > 0;
    }

    public static boolean isWhitespace(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (whitespace.indexOf(c) != -1) continue;
            return false;
        }
        return true;
    }

    public static String stripCharsInBag(String s, String bag) {
        String returnString = "";
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (bag.indexOf(c) != -1) continue;
            returnString = returnString + c;
        }
        return returnString;
    }

    public static String stripCharsNotInBag(String s, String bag) {
        String returnString = "";
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (bag.indexOf(c) == -1) continue;
            returnString = returnString + c;
        }
        return returnString;
    }

    public static String stripWhitespace(String s) {
        return UtilValidate.stripCharsInBag(s, whitespace);
    }

    public static boolean charInString(char c, String s) {
        return s.indexOf(c) != -1;
    }

    public static String stripInitialWhitespace(String s) {
        int i;
        for (i = 0; i < s.length() && UtilValidate.charInString(s.charAt(i), whitespace); ++i) {
        }
        return s.substring(i);
    }

    public static boolean isLetter(char c) {
        return Character.isLetter(c);
    }

    public static boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    public static boolean isLetterOrDigit(char c) {
        return Character.isLetterOrDigit(c);
    }

    public static boolean isInteger(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (UtilValidate.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSignedInteger(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        try {
            int temp = Integer.parseInt(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isSignedLong(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        try {
            long temp = Long.parseLong(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isPositiveInteger(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        try {
            long temp = Long.parseLong(s);
            return temp > 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNonnegativeInteger(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        try {
            int temp = Integer.parseInt(s);
            return temp >= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNegativeInteger(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        try {
            int temp = Integer.parseInt(s);
            return temp < 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNonpositiveInteger(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        try {
            int temp = Integer.parseInt(s);
            return temp <= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFloat(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        boolean seenDecimalPoint = false;
        if (s.startsWith(decimalPointDelimiter)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == decimalPointDelimiter.charAt(0)) {
                if (!seenDecimalPoint) {
                    seenDecimalPoint = true;
                    continue;
                }
                return false;
            }
            if (UtilValidate.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSignedFloat(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        try {
            float temp = Float.parseFloat(s);
            return temp <= 0.0f;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isSignedDouble(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        try {
            double temp = Double.parseDouble(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isAlphabetic(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (UtilValidate.isLetter(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumeric(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (UtilValidate.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSSN(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        String normalizedSSN = UtilValidate.stripCharsInBag(s, SSNDelimiters);
        return UtilValidate.isInteger(normalizedSSN) && normalizedSSN.length() == 9;
    }

    public static boolean isUSPhoneNumber(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        String normalizedPhone = UtilValidate.stripCharsInBag(s, phoneNumberDelimiters);
        return UtilValidate.isInteger(normalizedPhone) && normalizedPhone.length() == 10;
    }

    public static boolean isUSPhoneAreaCode(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        String normalizedPhone = UtilValidate.stripCharsInBag(s, phoneNumberDelimiters);
        return UtilValidate.isInteger(normalizedPhone) && normalizedPhone.length() == 3;
    }

    public static boolean isUSPhoneMainNumber(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        String normalizedPhone = UtilValidate.stripCharsInBag(s, phoneNumberDelimiters);
        return UtilValidate.isInteger(normalizedPhone) && normalizedPhone.length() == 7;
    }

    public static boolean isInternationalPhoneNumber(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        String normalizedPhone = UtilValidate.stripCharsInBag(s, phoneNumberDelimiters);
        return UtilValidate.isPositiveInteger(normalizedPhone);
    }

    public static boolean isZipCode(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        String normalizedZip = UtilValidate.stripCharsInBag(s, "-");
        return UtilValidate.isInteger(normalizedZip) && (normalizedZip.length() == 5 || normalizedZip.length() == 9);
    }

    public static boolean isContiguousZipCode(String s) {
        boolean retval = false;
        if (UtilValidate.isZipCode(s)) {
            String normalizedZip;
            int iZip;
            retval = UtilValidate.isEmpty(s) ? true : !((iZip = Integer.parseInt(normalizedZip = s.substring(0, 5))) >= 96701 && iZip <= 96898 || iZip >= 99501 && iZip <= 99950);
        }
        return retval;
    }

    public static boolean isStateCode(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        return USStateCodes.indexOf(s) != -1 && s.indexOf(USStateCodeDelimiter) == -1;
    }

    public static boolean isContiguousStateCode(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        return ContiguousUSStateCodes.indexOf(s) != -1 && s.indexOf(USStateCodeDelimiter) == -1;
    }

    public static boolean isEmail(String s) {
        int i;
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        if (UtilValidate.isWhitespace(s)) {
            return false;
        }
        int sLength = s.length();
        for (i = 1; i < sLength && s.charAt(i) != '@'; ++i) {
        }
        return i < sLength - 1 && s.charAt(i) == '@';
    }

    public static boolean isYear(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        if (!UtilValidate.isNonnegativeInteger(s)) {
            return false;
        }
        return s.length() == 2 || s.length() == 4;
    }

    public static boolean isIntegerInRange(String s, int a, int b) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        if (!UtilValidate.isSignedInteger(s)) {
            return false;
        }
        int num = Integer.parseInt(s);
        return num >= a && num <= b;
    }

    public static boolean isMonth(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        return UtilValidate.isIntegerInRange(s, 1, 12);
    }

    public static boolean isDay(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        return UtilValidate.isIntegerInRange(s, 1, 31);
    }

    public static int daysInFebruary(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0) ? 29 : 28;
    }

    public static boolean isHour(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        return UtilValidate.isIntegerInRange(s, 0, 23);
    }

    public static boolean isMinute(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        return UtilValidate.isIntegerInRange(s, 0, 59);
    }

    public static boolean isSecond(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        return UtilValidate.isIntegerInRange(s, 0, 59);
    }

    public static boolean isDate(String year, String month, String day) {
        if (!(UtilValidate.isYear(year) && UtilValidate.isMonth(month) && UtilValidate.isDay(day))) {
            return false;
        }
        int intYear = Integer.parseInt(year);
        int intMonth = Integer.parseInt(month);
        int intDay = Integer.parseInt(day);
        if (intDay > daysInMonth[intMonth - 1]) {
            return false;
        }
        return intMonth != 2 || intDay <= UtilValidate.daysInFebruary(intYear);
    }

    public static boolean isDate(String date) {
        if (UtilValidate.isEmpty(date)) {
            return true;
        }
        int dateSlash1 = date.indexOf("/");
        int dateSlash2 = date.lastIndexOf("/");
        if (dateSlash1 <= 0 || dateSlash1 == dateSlash2) {
            return false;
        }
        String month = date.substring(0, dateSlash1);
        String day = date.substring(dateSlash1 + 1, dateSlash2);
        String year = date.substring(dateSlash2 + 1);
        return UtilValidate.isDate(year, month, day);
    }

    public static boolean isDateAfterToday(String date) {
        String month;
        if (UtilValidate.isEmpty(date)) {
            return true;
        }
        int dateSlash1 = date.indexOf("/");
        int dateSlash2 = date.lastIndexOf("/");
        if (dateSlash1 <= 0) {
            return false;
        }
        Date passed = null;
        if (dateSlash1 == dateSlash2) {
            month = date.substring(0, dateSlash1);
            String day = "28";
            String year = date.substring(dateSlash1 + 1);
            if (!UtilValidate.isDate(year, month, day)) {
                return false;
            }
            try {
                int monthInt = Integer.parseInt(month);
                int yearInt = Integer.parseInt(year);
                Calendar calendar = Calendar.getInstance();
                calendar.set(yearInt, monthInt - 1, 0, 0, 0, 0);
                calendar.add(2, 1);
                passed = new Date(calendar.getTime().getTime());
            }
            catch (Exception e) {
                passed = null;
            }
        } else {
            month = date.substring(0, dateSlash1);
            String day = date.substring(dateSlash1 + 1, dateSlash2);
            String year = date.substring(dateSlash2 + 1);
            if (!UtilValidate.isDate(year, month, day)) {
                return false;
            }
            passed = UtilDateTime.toDate(month, day, year, "0", "0", "0");
        }
        Date now = UtilDateTime.nowDate();
        if (passed != null) {
            return passed.after(now);
        }
        return false;
    }

    public static boolean isTime(String hour, String minute, String second) {
        return UtilValidate.isHour(hour) && UtilValidate.isMinute(minute) && UtilValidate.isSecond(second);
    }

    public static boolean isTime(String time) {
        String second;
        String minute;
        if (UtilValidate.isEmpty(time)) {
            return true;
        }
        int timeColon1 = time.indexOf(":");
        int timeColon2 = time.lastIndexOf(":");
        if (timeColon1 <= 0) {
            return false;
        }
        String hour = time.substring(0, timeColon1);
        if (timeColon1 == timeColon2) {
            minute = time.substring(timeColon1 + 1);
            second = "0";
        } else {
            minute = time.substring(timeColon1 + 1, timeColon2);
            second = time.substring(timeColon2 + 1);
        }
        return UtilValidate.isTime(hour, minute, second);
    }

    public static boolean isCreditCard(String stPassed) {
        if (UtilValidate.isEmpty(stPassed)) {
            return true;
        }
        String st = UtilValidate.stripCharsInBag(stPassed, creditCardDelimiters);
        int sum = 0;
        int mul = 1;
        int l = st.length();
        if (l > 19) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            String digit = st.substring(l - i - 1, l - i);
            int tproduct = 0;
            try {
                tproduct = Integer.parseInt(digit, 10) * mul;
            }
            catch (Exception e) {
                Debug.logWarning(e.getMessage());
                return false;
            }
            sum = tproduct >= 10 ? (sum += tproduct % 10 + 1) : (sum += tproduct);
            if (mul == 1) {
                ++mul;
                continue;
            }
            --mul;
        }
        return sum % 10 == 0;
    }

    public static boolean isVisa(String cc) {
        if ((cc.length() == 16 || cc.length() == 13) && cc.substring(0, 1).equals("4")) {
            return UtilValidate.isCreditCard(cc);
        }
        return false;
    }

    public static boolean isMasterCard(String cc) {
        int firstdig = Integer.parseInt(cc.substring(0, 1));
        int seconddig = Integer.parseInt(cc.substring(1, 2));
        if (cc.length() == 16 && firstdig == 5 && seconddig >= 1 && seconddig <= 5) {
            return UtilValidate.isCreditCard(cc);
        }
        return false;
    }

    public static boolean isAmericanExpress(String cc) {
        int firstdig = Integer.parseInt(cc.substring(0, 1));
        int seconddig = Integer.parseInt(cc.substring(1, 2));
        if (cc.length() == 15 && firstdig == 3 && (seconddig == 4 || seconddig == 7)) {
            return UtilValidate.isCreditCard(cc);
        }
        return false;
    }

    public static boolean isDinersClub(String cc) {
        int firstdig = Integer.parseInt(cc.substring(0, 1));
        int seconddig = Integer.parseInt(cc.substring(1, 2));
        if (cc.length() == 14 && firstdig == 3 && (seconddig == 0 || seconddig == 6 || seconddig == 8)) {
            return UtilValidate.isCreditCard(cc);
        }
        return false;
    }

    public static boolean isCarteBlanche(String cc) {
        return UtilValidate.isDinersClub(cc);
    }

    public static boolean isDiscover(String cc) {
        String first4digs = cc.substring(0, 4);
        if (cc.length() == 16 && first4digs.equals("6011")) {
            return UtilValidate.isCreditCard(cc);
        }
        return false;
    }

    public static boolean isEnRoute(String cc) {
        String first4digs = cc.substring(0, 4);
        if (cc.length() == 15 && (first4digs.equals("2014") || first4digs.equals("2149"))) {
            return UtilValidate.isCreditCard(cc);
        }
        return false;
    }

    public static boolean isJCB(String cc) {
        String first4digs = cc.substring(0, 4);
        if (cc.length() == 16 && (first4digs.equals("3088") || first4digs.equals("3096") || first4digs.equals("3112") || first4digs.equals("3158") || first4digs.equals("3337") || first4digs.equals("3528"))) {
            return UtilValidate.isCreditCard(cc);
        }
        return false;
    }

    public static boolean isAnyCard(String ccPassed) {
        if (UtilValidate.isEmpty(ccPassed)) {
            return true;
        }
        String cc = UtilValidate.stripCharsInBag(ccPassed, creditCardDelimiters);
        if (!UtilValidate.isCreditCard(cc)) {
            return false;
        }
        return UtilValidate.isMasterCard(cc) || UtilValidate.isVisa(cc) || UtilValidate.isAmericanExpress(cc) || UtilValidate.isDinersClub(cc) || UtilValidate.isDiscover(cc) || UtilValidate.isEnRoute(cc) || UtilValidate.isJCB(cc);
    }

    public static String getCardType(String ccPassed) {
        if (UtilValidate.isEmpty(ccPassed)) {
            return "Unknown";
        }
        String cc = UtilValidate.stripCharsInBag(ccPassed, creditCardDelimiters);
        if (!UtilValidate.isCreditCard(cc)) {
            return "Unknown";
        }
        if (UtilValidate.isMasterCard(cc)) {
            return "MasterCard";
        }
        if (UtilValidate.isVisa(cc)) {
            return "Visa";
        }
        if (UtilValidate.isAmericanExpress(cc)) {
            return "AmericanExpress";
        }
        if (UtilValidate.isDinersClub(cc)) {
            return "DinersClub";
        }
        if (UtilValidate.isDiscover(cc)) {
            return "Discover";
        }
        if (UtilValidate.isEnRoute(cc)) {
            return "EnRoute";
        }
        if (UtilValidate.isJCB(cc)) {
            return "JCB";
        }
        return "Unknown";
    }

    public static boolean isCardMatch(String cardType, String cardNumberPassed) {
        if (UtilValidate.isEmpty(cardType)) {
            return true;
        }
        if (UtilValidate.isEmpty(cardNumberPassed)) {
            return true;
        }
        String cardNumber = UtilValidate.stripCharsInBag(cardNumberPassed, creditCardDelimiters);
        if (cardType.equalsIgnoreCase("VISA") && UtilValidate.isVisa(cardNumber)) {
            return true;
        }
        if (cardType.equalsIgnoreCase("MASTERCARD") && UtilValidate.isMasterCard(cardNumber)) {
            return true;
        }
        if ((cardType.equalsIgnoreCase("AMERICANEXPRESS") || cardType.equalsIgnoreCase("AMEX")) && UtilValidate.isAmericanExpress(cardNumber)) {
            return true;
        }
        if (cardType.equalsIgnoreCase("DISCOVER") && UtilValidate.isDiscover(cardNumber)) {
            return true;
        }
        if (cardType.equalsIgnoreCase("JCB") && UtilValidate.isJCB(cardNumber)) {
            return true;
        }
        if ((cardType.equalsIgnoreCase("DINERSCLUB") || cardType.equalsIgnoreCase("DINERS")) && UtilValidate.isDinersClub(cardNumber)) {
            return true;
        }
        if (cardType.equalsIgnoreCase("CARTEBLANCHE") && UtilValidate.isCarteBlanche(cardNumber)) {
            return true;
        }
        return cardType.equalsIgnoreCase("ENROUTE") && UtilValidate.isEnRoute(cardNumber);
    }

    public static boolean isNotPoBox(String s) {
        if (UtilValidate.isEmpty(s)) {
            return true;
        }
        String sl = s.toLowerCase();
        if (sl.indexOf("p.o. b") != -1) {
            return false;
        }
        if (sl.indexOf("p.o.b") != -1) {
            return false;
        }
        if (sl.indexOf("p.o b") != -1) {
            return false;
        }
        if (sl.indexOf("p o b") != -1) {
            return false;
        }
        if (sl.indexOf("po b") != -1) {
            return false;
        }
        if (sl.indexOf("pobox") != -1) {
            return false;
        }
        if (sl.indexOf("po#") != -1) {
            return false;
        }
        if (sl.indexOf("po #") != -1) {
            return false;
        }
        if (sl.indexOf("p.0. b") != -1) {
            return false;
        }
        if (sl.indexOf("p.0.b") != -1) {
            return false;
        }
        if (sl.indexOf("p.0 b") != -1) {
            return false;
        }
        if (sl.indexOf("p 0 b") != -1) {
            return false;
        }
        if (sl.indexOf("p0 b") != -1) {
            return false;
        }
        if (sl.indexOf("p0box") != -1) {
            return false;
        }
        if (sl.indexOf("p0#") != -1) {
            return false;
        }
        return sl.indexOf("p0 #") == -1;
    }
}

