/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilCache;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigXMLReader {
    public static final String module = ConfigXMLReader.class.getName();
    public static UtilCache requestCache = new UtilCache("webapp.ConfigXMLReader.Request");
    public static UtilCache viewCache = new UtilCache("webapp.ConfigXMLReader.View");
    public static UtilCache headCache = new UtilCache("webapp.ConfigXMLReader.Config");
    public static UtilCache handlerCache = new UtilCache("webapp.ConfigXMLReader.Handler");
    public static final String DEFAULT_ERROR_PAGE = "errorpage";
    public static final String SITE_OWNER = "owner";
    public static final String SECURITY_CLASS = "security-class";
    public static final String FIRSTVISIT = "firstvisit";
    public static final String PREPROCESSOR = "preprocessor";
    public static final String POSTPROCESSOR = "postprocessor";
    public static final String INCLUDE = "include";
    public static final String INCLUDE_FILE = "file";
    public static final String INCLUDE_URL = "url";
    public static final String REQUEST_MAPPING = "request-map";
    public static final String REQUEST_URI = "uri";
    public static final String REQUEST_EDIT = "edit";
    public static final String REQUEST_DESCRIPTION = "description";
    public static final String ERROR_PAGE = "error";
    public static final String NEXT_PAGE = "success";
    public static final String SECURITY = "security";
    public static final String SECURITY_HTTPS = "https";
    public static final String SECURITY_AUTH = "auth";
    public static final String SECURITY_EXTVIEW = "external-view";
    public static final String SECURITY_DIRECT = "direct-request";
    public static final String EVENT = "event";
    public static final String EVENT_PATH = "path";
    public static final String EVENT_TYPE = "type";
    public static final String EVENT_METHOD = "invoke";
    public static final String RESPONSE = "response";
    public static final String RESPONSE_NAME = "name";
    public static final String RESPONSE_TYPE = "type";
    public static final String RESPONSE_VALUE = "value";
    public static final String VIEW_MAPPING = "view-map";
    public static final String VIEW_NAME = "name";
    public static final String VIEW_PAGE = "page";
    public static final String VIEW_TYPE = "type";
    public static final String VIEW_INFO = "info";
    public static final String VIEW_CONTENT_TYPE = "content-type";
    public static final String VIEW_ENCODING = "encoding";
    public static final String VIEW_DESCRIPTION = "description";
    public static final String HANDLER = "handler";
    public static final String HANDLER_NAME = "name";
    public static final String HANDLER_TYPE = "type";
    public static final String HANDLER_CLASS = "class";

    public static Element loadDocument(URL location) {
        Document document = null;
        try {
            document = UtilXml.readXmlDocument(location, true);
            Element rootElement = document.getDocumentElement();
            if (Debug.verboseOn()) {
                Debug.logVerbose("Loaded XML Config - " + location, module);
            }
            return rootElement;
        }
        catch (Exception e) {
            Debug.logError(e, module);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static HashMap getRequestMap(URL xml) {
        HashMap requestMap = (HashMap)requestCache.get(xml);
        if (requestMap == null) {
            Class<ConfigXMLReader> clazz = ConfigXMLReader.class;
            // MONITORENTER : org.ofbiz.core.util.ConfigXMLReader.class
            requestMap = (HashMap)requestCache.get(xml);
            if (requestMap == null) {
                requestMap = ConfigXMLReader.loadRequestMap(xml);
                requestCache.put(xml, requestMap);
            }
            // MONITOREXIT : clazz
        }
        if (requestMap != null) return requestMap;
        return new HashMap();
    }

    public static HashMap loadRequestMap(URL xml) {
        int rootCount;
        HashMap map = new HashMap();
        Element root = ConfigXMLReader.loadDocument(xml);
        if (root == null) {
            return map;
        }
        NodeList list = root.getElementsByTagName(INCLUDE);
        for (rootCount = 0; rootCount < list.getLength(); ++rootCount) {
            String includeURL;
            Node node = list.item(rootCount);
            if (!(node instanceof Element)) continue;
            Element mapping = (Element)node;
            String includeFile = mapping.getAttribute(INCLUDE_FILE);
            if (includeFile != null && includeFile.length() > 0) {
                File oldFile = new File(xml.getFile());
                File newFile = new File("" + oldFile.getParent() + File.separator + includeFile);
                try {
                    HashMap subMap = ConfigXMLReader.loadRequestMap(newFile.toURL());
                    map.putAll(subMap);
                }
                catch (MalformedURLException mue) {
                    mue.printStackTrace();
                }
            }
            if ((includeURL = mapping.getAttribute(INCLUDE_URL)) == null || includeURL.length() <= 0) continue;
            try {
                HashMap subMap = ConfigXMLReader.loadRequestMap(new URL(includeURL));
                map.putAll(subMap);
                continue;
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
        }
        list = root.getElementsByTagName(REQUEST_MAPPING);
        for (rootCount = 0; rootCount < list.getLength(); ++rootCount) {
            NodeList descList;
            Node eventNode;
            NodeList eventList;
            Node securityNode;
            NodeList securityList;
            HashMap<String, String> uriMap = new HashMap<String, String>();
            Node node = list.item(rootCount);
            if (!(node instanceof Element)) continue;
            Element mapping = (Element)node;
            String uri = mapping.getAttribute(REQUEST_URI);
            String edit = mapping.getAttribute(REQUEST_EDIT);
            if (edit == null || edit.equals("")) {
                edit = "true";
            }
            if (uri != null) {
                uriMap.put(REQUEST_URI, uri);
                uriMap.put(REQUEST_EDIT, edit);
            }
            if ((securityList = mapping.getElementsByTagName(SECURITY)).getLength() > 0 && (securityNode = securityList.item(0)) instanceof Element) {
                Element security = (Element)securityNode;
                String securityHttps = security.getAttribute(SECURITY_HTTPS);
                String securityAuth = security.getAttribute(SECURITY_AUTH);
                String securityExtView = security.getAttribute(SECURITY_EXTVIEW);
                String securityDirectRequest = security.getAttribute(SECURITY_DIRECT);
                uriMap.put(SECURITY_HTTPS, securityHttps);
                uriMap.put(SECURITY_AUTH, securityAuth);
                uriMap.put(SECURITY_EXTVIEW, securityExtView);
                uriMap.put(SECURITY_DIRECT, securityDirectRequest);
            }
            if ((eventList = mapping.getElementsByTagName(EVENT)).getLength() > 0 && (eventNode = eventList.item(0)) instanceof Element) {
                Element event = (Element)eventNode;
                String type = event.getAttribute("type");
                String path = event.getAttribute(EVENT_PATH);
                String invoke = event.getAttribute(EVENT_METHOD);
                uriMap.put("type", type);
                uriMap.put(EVENT_PATH, path);
                uriMap.put(EVENT_METHOD, invoke);
            }
            if ((descList = mapping.getElementsByTagName("description")).getLength() > 0) {
                NodeList children;
                Node descNode = descList.item(0);
                if (descNode instanceof Element && (children = descNode.getChildNodes()).getLength() > 0) {
                    Node cdata = children.item(0);
                    String description = cdata.getNodeValue();
                    description = description != null ? description.trim() : "";
                    uriMap.put("description", description);
                }
            } else {
                uriMap.put("description", "");
            }
            NodeList respList = mapping.getElementsByTagName(RESPONSE);
            for (int respCount = 0; respCount < respList.getLength(); ++respCount) {
                Node responseNode = respList.item(respCount);
                if (!(responseNode instanceof Element)) continue;
                Element response = (Element)responseNode;
                String name = response.getAttribute("name");
                String type = response.getAttribute("type");
                String value = response.getAttribute(RESPONSE_VALUE);
                uriMap.put(name, type + ":" + value);
            }
            if (uri == null) continue;
            map.put(uri, uriMap);
        }
        if (Debug.verboseOn()) {
            Debug.logVerbose("-------- Request Mappings --------", module);
        }
        HashMap debugMap = map;
        Set debugSet = debugMap.keySet();
        for (Object o : debugSet) {
            String request = (String)o;
            HashMap thisURI = (HashMap)debugMap.get(o);
            if (Debug.verboseOn()) {
                Debug.logVerbose(request, module);
            }
            for (Object lo : thisURI.keySet()) {
                String name = (String)lo;
                String value = (String)thisURI.get(lo);
                if (!Debug.verboseOn()) continue;
                Debug.logVerbose("\t" + name + " -> " + value, module);
            }
        }
        if (Debug.verboseOn()) {
            Debug.logVerbose("------ End Request Mappings ------", module);
        }
        if (Debug.infoOn()) {
            Debug.logInfo("RequestMap Created: (" + map.size() + ") records.", module);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Map getViewMap(URL xml) {
        Map viewMap = (HashMap)viewCache.get(xml);
        if (viewMap == null) {
            Class<ConfigXMLReader> clazz = ConfigXMLReader.class;
            // MONITORENTER : org.ofbiz.core.util.ConfigXMLReader.class
            viewMap = (HashMap)viewCache.get(xml);
            if (viewMap == null) {
                viewMap = ConfigXMLReader.loadViewMap(xml);
                viewCache.put(xml, viewMap);
            }
            // MONITOREXIT : clazz
        }
        if (viewMap != null) return viewMap;
        return new HashMap();
    }

    public static Map loadViewMap(URL xml) {
        int rootCount;
        HashMap map = new HashMap();
        Element root = ConfigXMLReader.loadDocument(xml);
        if (root == null) {
            return map;
        }
        NodeList list = root.getElementsByTagName(INCLUDE);
        for (rootCount = 0; rootCount < list.getLength(); ++rootCount) {
            String includeURL;
            Node node = list.item(rootCount);
            if (!(node instanceof Element)) continue;
            Element mapping = (Element)node;
            String includeFile = mapping.getAttribute(INCLUDE_FILE);
            if (includeFile != null && includeFile.length() > 0) {
                File oldFile = new File(xml.getFile());
                File newFile = new File("" + oldFile.getParent() + File.separator + includeFile);
                try {
                    Map subMap = ConfigXMLReader.loadViewMap(newFile.toURL());
                    map.putAll(subMap);
                }
                catch (MalformedURLException mue) {
                    mue.printStackTrace();
                }
            }
            if ((includeURL = mapping.getAttribute(INCLUDE_URL)) == null || includeURL.length() <= 0) continue;
            try {
                Map subMap = ConfigXMLReader.loadViewMap(new URL(includeURL));
                map.putAll(subMap);
                continue;
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
        }
        list = root.getElementsByTagName(VIEW_MAPPING);
        for (rootCount = 0; rootCount < list.getLength(); ++rootCount) {
            HashMap<String, String> uriMap = new HashMap<String, String>();
            Node node = list.item(rootCount);
            if (!(node instanceof Element)) continue;
            Element mapping = (Element)node;
            String name = mapping.getAttribute("name");
            String page = mapping.getAttribute(VIEW_PAGE);
            String type = mapping.getAttribute("type");
            if (page == null || page.length() == 0) {
                page = name;
            }
            uriMap.put("name", name);
            uriMap.put(VIEW_PAGE, page);
            uriMap.put("type", type);
            uriMap.put(VIEW_INFO, mapping.getAttribute(VIEW_INFO));
            uriMap.put(VIEW_CONTENT_TYPE, mapping.getAttribute(VIEW_CONTENT_TYPE));
            uriMap.put(VIEW_ENCODING, mapping.getAttribute(VIEW_ENCODING));
            NodeList descList = mapping.getElementsByTagName("description");
            if (descList.getLength() > 0) {
                NodeList children;
                Node descNode = descList.item(0);
                if (descNode instanceof Element && (children = descNode.getChildNodes()).getLength() > 0) {
                    Node cdata = children.item(0);
                    String description = cdata.getNodeValue();
                    description = description != null ? description.trim() : "";
                    uriMap.put("description", description);
                }
            } else {
                uriMap.put("description", "");
            }
            if (name == null) continue;
            map.put(name, uriMap);
        }
        Debug.logVerbose("-------- View Mappings --------", module);
        HashMap debugMap = map;
        Set debugSet = debugMap.keySet();
        for (Object o : debugSet) {
            String request = (String)o;
            HashMap thisURI = (HashMap)debugMap.get(o);
            Debug.logVerbose(request, module);
            for (Object lo : thisURI.keySet()) {
                String name = (String)lo;
                String value = (String)thisURI.get(lo);
                if (!Debug.verboseOn()) continue;
                Debug.logVerbose("\t" + name + " -> " + value, module);
            }
        }
        Debug.logVerbose("------ End View Mappings ------", module);
        if (Debug.infoOn()) {
            Debug.logInfo("ViewMap Created: (" + map.size() + ") records.", module);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Map getConfigMap(URL xml) {
        Map configMap = (HashMap)headCache.get(xml);
        if (configMap == null) {
            Class<ConfigXMLReader> clazz = ConfigXMLReader.class;
            // MONITORENTER : org.ofbiz.core.util.ConfigXMLReader.class
            configMap = (HashMap)headCache.get(xml);
            if (configMap == null) {
                configMap = ConfigXMLReader.loadConfigMap(xml);
                headCache.put(xml, configMap);
            }
            // MONITOREXIT : clazz
        }
        if (configMap != null) return configMap;
        return new HashMap();
    }

    public static Map loadConfigMap(URL xml) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Element root = ConfigXMLReader.loadDocument(xml);
        NodeList list = null;
        if (root != null) {
            HashMap<String, String> eventMap;
            String invoke;
            String path;
            String type;
            Element event;
            Node eventNode;
            int procCount;
            NodeList procEvents;
            Element nodeElement;
            Node node;
            ArrayList eventList;
            Node node2;
            NodeList children;
            Node child;
            list = root.getElementsByTagName(DEFAULT_ERROR_PAGE);
            if (list.getLength() > 0 && (child = (children = (node2 = list.item(0)).getChildNodes()).item(0)).getNodeName() != null) {
                map.put(DEFAULT_ERROR_PAGE, child.getNodeValue());
            }
            list = null;
            list = root.getElementsByTagName(SITE_OWNER);
            if (list.getLength() > 0 && (child = (children = (node2 = list.item(0)).getChildNodes()).item(0)).getNodeName() != null) {
                map.put(SITE_OWNER, child.getNodeValue());
            }
            list = null;
            list = root.getElementsByTagName(SECURITY_CLASS);
            if (list.getLength() > 0 && (child = (children = (node2 = list.item(0)).getChildNodes()).item(0)).getNodeName() != null) {
                map.put(SECURITY_CLASS, child.getNodeValue());
            }
            list = null;
            list = root.getElementsByTagName(FIRSTVISIT);
            if (list.getLength() > 0) {
                eventList = new ArrayList();
                node = list.item(0);
                if (node instanceof Element) {
                    nodeElement = (Element)node;
                    procEvents = nodeElement.getElementsByTagName(EVENT);
                    for (procCount = 0; procCount < procEvents.getLength(); ++procCount) {
                        eventNode = procEvents.item(procCount);
                        if (!(eventNode instanceof Element)) continue;
                        event = (Element)eventNode;
                        type = event.getAttribute("type");
                        path = event.getAttribute(EVENT_PATH);
                        invoke = event.getAttribute(EVENT_METHOD);
                        eventMap = new HashMap<String, String>();
                        eventMap.put("type", type);
                        eventMap.put(EVENT_PATH, path);
                        eventMap.put(EVENT_METHOD, invoke);
                        eventList.add(eventMap);
                    }
                }
                map.put(FIRSTVISIT, eventList);
            }
            list = null;
            list = root.getElementsByTagName(PREPROCESSOR);
            if (list.getLength() > 0) {
                eventList = new ArrayList();
                node = list.item(0);
                if (node instanceof Element) {
                    nodeElement = (Element)node;
                    procEvents = nodeElement.getElementsByTagName(EVENT);
                    for (procCount = 0; procCount < procEvents.getLength(); ++procCount) {
                        eventNode = procEvents.item(procCount);
                        if (!(eventNode instanceof Element)) continue;
                        event = (Element)eventNode;
                        type = event.getAttribute("type");
                        path = event.getAttribute(EVENT_PATH);
                        invoke = event.getAttribute(EVENT_METHOD);
                        eventMap = new HashMap();
                        eventMap.put("type", type);
                        eventMap.put(EVENT_PATH, path);
                        eventMap.put(EVENT_METHOD, invoke);
                        eventList.add(eventMap);
                    }
                }
                map.put(PREPROCESSOR, eventList);
            }
            list = null;
            list = root.getElementsByTagName(POSTPROCESSOR);
            if (list.getLength() > 0) {
                eventList = new ArrayList();
                node = list.item(0);
                if (node instanceof Element) {
                    nodeElement = (Element)node;
                    procEvents = nodeElement.getElementsByTagName(EVENT);
                    for (procCount = 0; procCount < procEvents.getLength(); ++procCount) {
                        eventNode = procEvents.item(procCount);
                        if (!(eventNode instanceof Element)) continue;
                        event = (Element)eventNode;
                        type = event.getAttribute("type");
                        path = event.getAttribute(EVENT_PATH);
                        invoke = event.getAttribute(EVENT_METHOD);
                        eventMap = new HashMap();
                        eventMap.put("type", type);
                        eventMap.put(EVENT_PATH, path);
                        eventMap.put(EVENT_METHOD, invoke);
                        eventList.add(eventMap);
                    }
                }
                map.put(POSTPROCESSOR, eventList);
            }
            list = null;
        }
        if (Debug.infoOn()) {
            Debug.logInfo("ConfigMap Created: (" + map.size() + ") records.", module);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Map getHandlerMap(URL xml) {
        Map handlerMap = (HashMap)handlerCache.get(xml);
        if (handlerMap == null) {
            Class<ConfigXMLReader> clazz = ConfigXMLReader.class;
            // MONITORENTER : org.ofbiz.core.util.ConfigXMLReader.class
            handlerMap = (HashMap)handlerCache.get(xml);
            if (handlerMap == null) {
                handlerMap = ConfigXMLReader.loadHandlerMap(xml);
                handlerCache.put(xml, handlerMap);
            }
            // MONITOREXIT : clazz
        }
        if (handlerMap != null) return handlerMap;
        return new HashMap();
    }

    public static Map loadHandlerMap(URL xml) {
        String className;
        String handlerName;
        Set debugSet;
        HashMap map = new HashMap();
        Element root = ConfigXMLReader.loadDocument(xml);
        NodeList list = null;
        if (root != null) {
            HashMap<String, String> rMap = new HashMap<String, String>();
            HashMap<String, String> vMap = new HashMap<String, String>();
            list = root.getElementsByTagName(HANDLER);
            for (int i = 0; i < list.getLength(); ++i) {
                Element handler = (Element)list.item(i);
                String hName = ConfigXMLReader.checkEmpty(handler.getAttribute("name"));
                String hClass = ConfigXMLReader.checkEmpty(handler.getAttribute(HANDLER_CLASS));
                String hType = ConfigXMLReader.checkEmpty(handler.getAttribute("type"));
                if (hType.equals("view")) {
                    vMap.put(hName, hClass);
                    continue;
                }
                rMap.put(hName, hClass);
            }
            map.put("view", vMap);
            map.put(EVENT, rMap);
        }
        Debug.logVerbose("-------- Handler Mappings --------", module);
        Map debugMap = (Map)map.get(EVENT);
        if (debugMap != null && debugMap.size() > 0) {
            Debug.logVerbose("-------------- EVENT -------------", module);
            debugSet = debugMap.keySet();
            for (Object o : debugSet) {
                handlerName = (String)o;
                className = (String)debugMap.get(o);
                if (!Debug.verboseOn()) continue;
                Debug.logVerbose("[EH] : " + handlerName + " => " + className, module);
            }
        }
        if ((debugMap = (Map)map.get("view")) != null && debugMap.size() > 0) {
            Debug.logVerbose("-------------- VIEW --------------", module);
            debugSet = debugMap.keySet();
            for (Object o : debugSet) {
                handlerName = (String)o;
                className = (String)debugMap.get(o);
                if (!Debug.verboseOn()) continue;
                Debug.logVerbose("[VH] : " + handlerName + " => " + className, module);
            }
        }
        Debug.logVerbose("------ End Handler Mappings ------", module);
        if (Debug.infoOn()) {
            Debug.logInfo("HandlerMap Created: (" + map.size() + ") records.", module);
        }
        return map;
    }

    private static String checkEmpty(String string) {
        if (string != null && string.length() > 0) {
            return string;
        }
        return "";
    }

    public static String getSubTagValue(Node node, String subTagName) {
        String returnString = "";
        if (node != null) {
            NodeList children = node.getChildNodes();
            for (int innerLoop = 0; innerLoop < children.getLength(); ++innerLoop) {
                Node grandChild;
                Node child = children.item(innerLoop);
                if (child == null || child.getNodeName() == null || !child.getNodeName().equals(subTagName) || (grandChild = child.getFirstChild()).getNodeValue() == null) continue;
                return grandChild.getNodeValue();
            }
        }
        return returnString;
    }

    public static void main(String[] args) throws Exception {
        if (args[0] == null) {
            System.out.println("Please give a path to the config file you wish to test.");
            return;
        }
        System.out.println("----------------------------------");
        System.out.println("Request Mappings:");
        System.out.println("----------------------------------");
        HashMap debugMap = ConfigXMLReader.getRequestMap(new URL(args[0]));
        Set debugSet = debugMap.keySet();
        for (Object o : debugSet) {
            String request = (String)o;
            HashMap thisURI = (HashMap)debugMap.get(o);
            System.out.println(request);
            for (Object lo : thisURI.keySet()) {
                String name = (String)lo;
                String value = (String)thisURI.get(lo);
                System.out.println("\t" + name + " -> " + value);
            }
        }
        System.out.println("----------------------------------");
        System.out.println("End Request Mappings.");
        System.out.println("----------------------------------");
    }
}

