package com.atlassian.oauth2.scopes.api;

import java.util.Map;

public interface ScopeDescriptionService {

    /**
     * Used to get the description title and description body for all scopes.
     *
     * @return Returns a map of scope names to their descriptions.
     */
    Map<String, ScopeDescriptionWithTitle> getScopeDescriptionsWithTitle();

    /**
     * Used to get the descriptions for all scopes.
     *
     * @return Returns a map of scope names to their descriptions.
     */
    Map<String, ScopeDescription> getScopeDescriptions();

}
