package com.atlassian.oauth2.scopes.api;

import java.util.Objects;

public class Permission {

    private final String key;
    private final Object target;
    private final Object targetExcluded;

    public static Permission permission(final String permission) {
        return new Permission(permission, null, null);
    }

    public static Permission permissionWithTarget(final String permission, final Object target) {
        return new Permission(permission, target, null);
    }

    public static Permission permissionWithTargetExcluded(final String permission, final Object notTarget) {
        return new Permission(permission, null, notTarget);
    }

    private Permission(final String key, final Object target, final Object targetExcluded) {
        this.key = key;
        this.target = target;
        this.targetExcluded = targetExcluded;
    }

    public boolean hasPermission(final String key) {
        return key.equals(this.key);
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final Permission that = (Permission) o;
        final boolean isSameKey = Objects.equals(key, that.key);
        final boolean isNullTarget = Objects.isNull(target) || Objects.isNull(that.target);
        final boolean isNullNotTarget = Objects.isNull(targetExcluded) && Objects.isNull(that.targetExcluded);

        return isSameKey
                && (isNullTarget || Objects.equals(target, that.target))
                && (isNullNotTarget || !Objects.equals(targetExcluded, that.target));
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, target);
    }

    @Override
    public String toString() {
        if (target != null) {
            return key + ":" + target;
        }
        if (targetExcluded != null) {
            return key + ":!" + targetExcluded;
        }
        return key;
    }
}
