package com.atlassian.oauth2.provider.api.token.access.dao;

import com.atlassian.oauth2.provider.api.token.access.AccessToken;

import javax.annotation.Nonnull;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public interface AccessTokenDao {

    @Nonnull
    AccessToken create(AccessToken accessTokenEntity);

    void updateTokenLastAccessed(String tokenId);

    @Nonnull
    Collection<AccessToken> findByClientId(String clientId);

    @Nonnull
    Optional<AccessToken> findByToken(String tokenId);

    @Nonnull
    Optional<AccessToken> removeTokenById(String tokenId);

    @Nonnull
    List<AccessToken> removeAllByClientId(String clientId);

    @Nonnull
    List<AccessToken> removeAllByUserKey(String userKey);

    void removeExpiredTokensAfter(Duration expiration);

    @Nonnull
    List<String> findUserKeysByClientId(String clientId);

    @Nonnull
    List<AccessToken> findByUserKey(String userKey);
}
