package com.atlassian.oauth2.provider.api.external;

import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.provider.api.token.access.AccessToken;
import com.atlassian.oauth2.provider.api.token.refresh.RefreshToken;

import java.util.List;
import java.util.Optional;

public interface OAuth2ProviderService {

    /**
     * Gets all Clients
     * @return the clients stored in the system
     */
    List<Client> listClients();

    /**
     * Find the client using the clientId
     * @return the found Client or empty if not found
     */
    Optional<Client> findClient(String clientId);

    /**
     * Gets all the current users access tokens
     * @return the tokens for the current user or an empty list
     */
    List<AccessToken> listCurrentUsersAccessTokens();

    /**
     * Gets all the current users refresh tokens
     * @return the tokens for the current user or an empty list
     */
    List<RefreshToken> listCurrentUsersRefreshTokens();

    /**
     * Gets the OAuth 2 server metadata: endpoints, response types supported, scopes supported etc
     * @return OAuth 2 server metadata
     */
    OAuth2AuthorizationServerMetadata getOAuth2AuthorizationServerMetadata();

}
