package com.atlassian.oauth2.provider.api.external;

import lombok.Builder;
import lombok.Data;
import lombok.NonNull;

import java.util.Set;

/**
 * Metadata object following spec: https://datatracker.ietf.org/doc/html/rfc8414
 */
@Data
@Builder
public class OAuth2AuthorizationServerMetadata {

    @NonNull
    private final String issuer;
    @NonNull
    private final String tokenEndpoint;
    @NonNull
    private final String authorizationEndpoint;
    @NonNull
    private final String revocationEndpoint;
    @NonNull
    private final Set<String> scopesSupported;
    @NonNull
    private final Set<String> responseTypesSupported;
    @NonNull
    private final Set<String> responseModesSupported;
    @NonNull
    private final Set<String> grantTypesSupported;
    @NonNull
    private final Set<String> tokenEndpointAuthMethodsSupported;
    @NonNull
    private final Set<String> revocationEndpointAuthMethodsSupported;

}
